/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import org.apache.commons.numbers.fraction.GeneralizedContinuedFraction;
import org.apache.commons.numbers.gamma.BoostGamma;
import org.apache.commons.numbers.gamma.BoostMath;
import org.apache.commons.numbers.gamma.BoostTools;
import org.apache.commons.numbers.gamma.GammaRatio;
import org.apache.commons.numbers.gamma.Policy;

final class BoostBeta {
    private static final double EPSILON = 2.220446049250313E-16;
    private static final int LOG_MAX_VALUE = 709;
    private static final int LOG_MIN_VALUE = -708;
    private static final double HALF_PI = 1.5707963267948966;
    private static final int MAX_FACTORIAL = 170;
    private static final int PN_SIZE = 30;
    private static final double TWO_POW_53 = 9.007199254740992E15;
    private static final double TWO_POW_M53 = (double)1.110223E-16f;

    private BoostBeta() {
    }

    static double beta(double p, double q) {
        if (!(p > 0.0) || !(q > 0.0)) {
            return Double.NaN;
        }
        double c = p + q;
        if (c == p && q < 2.220446049250313E-16) {
            return 1.0 / q;
        }
        if (c == q && p < 2.220446049250313E-16) {
            return 1.0 / p;
        }
        if (q == 1.0) {
            return 1.0 / p;
        }
        if (p == 1.0) {
            return 1.0 / q;
        }
        if (c < 2.220446049250313E-16) {
            return c / p / q;
        }
        double a = p < q ? q : p;
        double b = p < q ? p : q;
        double agh = a + 5.52468004077673;
        double bgh = b + 5.52468004077673;
        double cgh = c + 5.52468004077673;
        double result = BoostGamma.Lanczos.lanczosSumExpGScaled(a) * (BoostGamma.Lanczos.lanczosSumExpGScaled(b) / BoostGamma.Lanczos.lanczosSumExpGScaled(c));
        double ambh = a - 0.5 - b;
        result = Math.abs(b * ambh) < cgh * 100.0 && a > 100.0 ? (result *= Math.exp(ambh * Math.log1p(-b / cgh))) : (result *= Math.pow(agh / cgh, ambh));
        result = cgh > 1.0E10 ? (result *= Math.pow(agh / cgh * (bgh / cgh), b)) : (result *= Math.pow(agh * bgh / (cgh * cgh), b));
        return result *= Math.sqrt(Math.E / bgh);
    }

    static double ibetaDerivative(double a, double b, double x) {
        if (!(a > 0.0 && b > 0.0 && x >= 0.0 && x <= 1.0)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            if (a > 1.0) {
                return 0.0;
            }
            return a == 1.0 ? b : Double.POSITIVE_INFINITY;
        }
        if (x == 1.0) {
            if (b > 1.0) {
                return 0.0;
            }
            return b == 1.0 ? a : Double.POSITIVE_INFINITY;
        }
        if (b == 1.0) {
            return a * Math.pow(x, a - 1.0);
        }
        if (a == 1.0) {
            if (x >= 0.5) {
                return b * Math.pow(1.0 - x, b - 1.0);
            }
            return b * Math.exp(Math.log1p(-x) * (b - 1.0));
        }
        double y = (1.0 - x) * x;
        return BoostBeta.ibetaPowerTerms(a, b, x, 1.0 - x, true, 1.0 / y);
    }

    private static double ibetaPowerTerms(double a, double b, double x, double y, boolean normalised) {
        return BoostBeta.ibetaPowerTerms(a, b, x, y, normalised, 1.0);
    }

    private static double ibetaPowerTerms(double a, double b, double x, double y, boolean normalised, double prefix) {
        if (!normalised) {
            return Math.pow(x, a) * Math.pow(y, b);
        }
        double c = a + b;
        double agh = a + 5.52468004077673;
        double bgh = b + 5.52468004077673;
        double cgh = c + 5.52468004077673;
        double result = BoostGamma.Lanczos.lanczosSumExpGScaled(c) / (BoostGamma.Lanczos.lanczosSumExpGScaled(a) * BoostGamma.Lanczos.lanczosSumExpGScaled(b));
        result *= prefix;
        result *= Math.sqrt(bgh / Math.E);
        result *= Math.sqrt(agh / cgh);
        double l1 = (x * b - y * agh) / agh;
        double l2 = (y * a - x * bgh) / bgh;
        if (Math.min(Math.abs(l1), Math.abs(l2)) < 0.2) {
            if (l1 * l2 > 0.0 || Math.min(a, b) < 1.0) {
                result = Math.abs(l1) < 0.1 ? (result *= Math.exp(a * Math.log1p(l1))) : (result *= Math.pow(x * cgh / agh, a));
                result = Math.abs(l2) < 0.1 ? (result *= Math.exp(b * Math.log1p(l2))) : (result *= Math.pow(y * cgh / bgh, b));
            } else if (Math.max(Math.abs(l1), Math.abs(l2)) < 0.5) {
                boolean smallA = a < b;
                double ratio = b / a;
                if (smallA && ratio * l2 < 0.1 || !smallA && l1 / ratio > 0.1) {
                    double l3 = Math.expm1(ratio * Math.log1p(l2));
                    l3 = l1 + l3 + l3 * l1;
                    l3 = a * Math.log1p(l3);
                    result *= Math.exp(l3);
                } else {
                    double l3 = Math.expm1(Math.log1p(l1) / ratio);
                    l3 = l2 + l3 + l3 * l2;
                    l3 = b * Math.log1p(l3);
                    result *= Math.exp(l3);
                }
            } else if (Math.abs(l1) < Math.abs(l2)) {
                double l = a * Math.log1p(l1) + b * Math.log(y * cgh / bgh);
                if (l <= -708.0 || l >= 709.0) {
                    l += Math.log(result);
                    result = Math.exp(l);
                } else {
                    result *= Math.exp(l);
                }
            } else {
                double l = b * Math.log1p(l2) + a * Math.log(x * cgh / agh);
                if (l <= -708.0 || l >= 709.0) {
                    l += Math.log(result);
                    result = Math.exp(l);
                } else {
                    result *= Math.exp(l);
                }
            }
        } else {
            double b1 = x * cgh / agh;
            double b2 = y * cgh / bgh;
            l1 = a * Math.log(b1);
            l2 = b * Math.log(b2);
            if (l1 >= 709.0 || l1 <= -708.0 || l2 >= 709.0 || l2 <= -708.0) {
                if (a < b) {
                    double p1 = Math.pow(b2, b / a);
                    double l3 = a * (Math.log(b1) + Math.log(p1));
                    if (l3 < 709.0 && l3 > -708.0) {
                        result *= Math.pow(p1 * b1, a);
                    } else {
                        l2 += l1 + Math.log(result);
                        result = Math.exp(l2);
                    }
                } else {
                    double p1 = Math.pow(b1, a / b);
                    double l3 = (Math.log(p1) + Math.log(b2)) * b;
                    if (l3 < 709.0 && l3 > -708.0) {
                        result *= Math.pow(p1 * b2, b);
                    } else {
                        l2 += l1 + Math.log(result);
                        result = Math.exp(l2);
                    }
                }
            } else {
                result *= Math.pow(b1, a) * Math.pow(b2, b);
            }
        }
        return result;
    }

    static double beta(double a, double b, double x) {
        return BoostBeta.betaIncompleteImp(a, b, x, Policy.getDefault(), false, false);
    }

    static double beta(double a, double b, double x, Policy policy) {
        return BoostBeta.betaIncompleteImp(a, b, x, policy, false, false);
    }

    static double betac(double a, double b, double x) {
        return BoostBeta.betaIncompleteImp(a, b, x, Policy.getDefault(), false, true);
    }

    static double betac(double a, double b, double x, Policy policy) {
        return BoostBeta.betaIncompleteImp(a, b, x, policy, false, true);
    }

    static double ibeta(double a, double b, double x) {
        return BoostBeta.betaIncompleteImp(a, b, x, Policy.getDefault(), true, false);
    }

    static double ibeta(double a, double b, double x, Policy policy) {
        return BoostBeta.betaIncompleteImp(a, b, x, policy, true, false);
    }

    static double ibetac(double a, double b, double x) {
        return BoostBeta.betaIncompleteImp(a, b, x, Policy.getDefault(), true, true);
    }

    static double ibetac(double a, double b, double x, Policy policy) {
        return BoostBeta.betaIncompleteImp(a, b, x, policy, true, true);
    }

    private static double betaIncompleteImp(double a, double b, double x, Policy pol, boolean normalised, boolean inv) {
        double fract;
        if (!(x >= 0.0) || !(x <= 1.0)) {
            return Double.NaN;
        }
        if (normalised) {
            if (!(a >= 0.0) || !(b >= 0.0)) {
                return Double.NaN;
            }
            if (a == 0.0) {
                if (b == 0.0) {
                    return Double.NaN;
                }
                return inv ? 0.0 : 1.0;
            }
            if (b == 0.0) {
                return inv ? 1.0 : 0.0;
            }
        } else if (!(a > 0.0) || !(b > 0.0)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            if (inv) {
                return normalised ? 1.0 : BoostBeta.beta(a, b);
            }
            return 0.0;
        }
        if (x == 1.0) {
            if (!inv) {
                return normalised ? 1.0 : BoostBeta.beta(a, b);
            }
            return 0.0;
        }
        if (a == 0.5 && b == 0.5) {
            double z = inv ? 1.0 - x : x;
            double asin = Math.asin(Math.sqrt(z));
            return normalised ? asin / 1.5707963267948966 : 2.0 * asin;
        }
        boolean invert = inv;
        double y = 1.0 - x;
        if (a == 1.0) {
            double tmp = a;
            a = b;
            b = tmp;
            tmp = x;
            x = y;
            y = tmp;
            boolean bl = invert = !invert;
        }
        if (b == 1.0) {
            double p;
            if (a == 1.0) {
                return invert ? y : x;
            }
            if (y < 0.5) {
                p = invert ? -Math.expm1(a * Math.log1p(-y)) : Math.exp(a * Math.log1p(-y));
            } else {
                double d = p = invert ? -BoostMath.powm1(x, a) : Math.pow(x, a);
            }
            if (!normalised) {
                p /= a;
            }
            return p;
        }
        if (Math.min(a, b) <= 1.0) {
            double tmp;
            if (x > 0.5) {
                tmp = a;
                a = b;
                b = tmp;
                tmp = x;
                x = y;
                y = tmp;
                boolean bl = invert = !invert;
            }
            if (Math.max(a, b) <= 1.0) {
                if (a >= Math.min(0.2, b) || Math.pow(x, a) <= 0.9) {
                    if (invert) {
                        fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                        invert = false;
                        fract = -BoostBeta.ibetaSeries(a, b, x, fract, normalised, pol);
                    } else {
                        fract = BoostBeta.ibetaSeries(a, b, x, 0.0, normalised, pol);
                    }
                } else {
                    tmp = a;
                    a = b;
                    b = tmp;
                    tmp = x;
                    x = y;
                    y = tmp;
                    boolean bl = invert = !invert;
                    if (y >= 0.3) {
                        if (invert) {
                            fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                            invert = false;
                            fract = -BoostBeta.ibetaSeries(a, b, x, fract, normalised, pol);
                        } else {
                            fract = BoostBeta.ibetaSeries(a, b, x, 0.0, normalised, pol);
                        }
                    } else {
                        double prefix = normalised ? 1.0 : BoostBeta.risingFactorialRatio(a + b, a, 20);
                        fract = BoostBeta.ibetaAStep(a, b, x, y, 20, normalised);
                        if (invert) {
                            fract -= normalised ? 1.0 : BoostBeta.beta(a, b);
                            invert = false;
                            fract = -BoostBeta.betaSmallBLargeASeries(a + 20.0, b, x, y, fract, prefix, pol, normalised);
                        } else {
                            fract = BoostBeta.betaSmallBLargeASeries(a + 20.0, b, x, y, fract, prefix, pol, normalised);
                        }
                    }
                }
            } else if (b <= 1.0 || x < 0.1 && Math.pow(b * x, a) <= 0.7) {
                if (invert) {
                    fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                    invert = false;
                    fract = -BoostBeta.ibetaSeries(a, b, x, fract, normalised, pol);
                } else {
                    fract = BoostBeta.ibetaSeries(a, b, x, 0.0, normalised, pol);
                }
            } else {
                tmp = a;
                a = b;
                b = tmp;
                tmp = x;
                x = y;
                y = tmp;
                boolean bl = invert = !invert;
                if (y >= 0.3) {
                    if (invert) {
                        fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                        invert = false;
                        fract = -BoostBeta.ibetaSeries(a, b, x, fract, normalised, pol);
                    } else {
                        fract = BoostBeta.ibetaSeries(a, b, x, 0.0, normalised, pol);
                    }
                } else if (a >= 15.0) {
                    if (invert) {
                        fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                        invert = false;
                        fract = -BoostBeta.betaSmallBLargeASeries(a, b, x, y, fract, 1.0, pol, normalised);
                    } else {
                        fract = BoostBeta.betaSmallBLargeASeries(a, b, x, y, 0.0, 1.0, pol, normalised);
                    }
                } else {
                    double prefix = normalised ? 1.0 : BoostBeta.risingFactorialRatio(a + b, a, 20);
                    fract = BoostBeta.ibetaAStep(a, b, x, y, 20, normalised);
                    if (invert) {
                        fract -= normalised ? 1.0 : BoostBeta.beta(a, b);
                        invert = false;
                        fract = -BoostBeta.betaSmallBLargeASeries(a + 20.0, b, x, y, fract, prefix, pol, normalised);
                    } else {
                        fract = BoostBeta.betaSmallBLargeASeries(a + 20.0, b, x, y, fract, prefix, pol, normalised);
                    }
                }
            }
        } else {
            double lambda = a < b ? a - (a + b) * x : (a + b) * y - b;
            if (lambda < 0.0) {
                double tmp = a;
                a = b;
                b = tmp;
                tmp = x;
                x = y;
                y = tmp;
                boolean bl = invert = !invert;
            }
            if (b < 40.0) {
                if (Math.rint(a) == a && Math.rint(b) == b && a < 2.147483547E9 && y != 1.0) {
                    int k = (int)(a - 1.0);
                    int n = (int)(b + (double)k);
                    fract = BoostBeta.binomialCCdf(n, k, x, y);
                    if (!normalised) {
                        fract *= BoostBeta.beta(a, b);
                    }
                } else if (b * x <= 0.7) {
                    if (invert) {
                        fract = -(normalised ? 1.0 : BoostBeta.beta(a, b));
                        invert = false;
                        fract = -BoostBeta.ibetaSeries(a, b, x, fract, normalised, pol);
                    } else {
                        fract = BoostBeta.ibetaSeries(a, b, x, 0.0, normalised, pol);
                    }
                } else if (a > 15.0) {
                    int n = (int)b;
                    if ((double)n == b) {
                        --n;
                    }
                    double bbar = b - (double)n;
                    double prefix = normalised ? 1.0 : BoostBeta.risingFactorialRatio(a + bbar, bbar, n);
                    fract = BoostBeta.ibetaAStep(bbar, a, y, x, n, normalised);
                    fract = BoostBeta.betaSmallBLargeASeries(a, bbar, x, y, fract, 1.0, pol, normalised);
                    fract /= prefix;
                } else if (normalised) {
                    int n = (int)Math.floor(b);
                    double bbar = b - (double)n;
                    if (bbar <= 0.0) {
                        --n;
                        bbar += 1.0;
                    }
                    fract = BoostBeta.ibetaAStep(bbar, a, y, x, n, normalised);
                    fract += BoostBeta.ibetaAStep(a, bbar, x, y, 20, normalised);
                    if (invert) {
                        fract -= 1.0;
                    }
                    fract = BoostBeta.betaSmallBLargeASeries(a + 20.0, bbar, x, y, fract, 1.0, pol, normalised);
                    if (invert) {
                        fract = -fract;
                        invert = false;
                    }
                } else {
                    fract = BoostBeta.ibetaFraction2(a, b, x, y, pol, normalised);
                }
            } else {
                fract = BoostBeta.ibetaFraction2(a, b, x, y, pol, normalised);
            }
        }
        if (invert) {
            return (normalised ? 1.0 : BoostBeta.beta(a, b)) - fract;
        }
        return fract;
    }

    private static double ibetaSeries(final double a, final double b, final double x, double s0, boolean normalised, Policy pol) {
        double result;
        if (normalised) {
            double c = a + b;
            double agh = a + 5.52468004077673;
            double bgh = b + 5.52468004077673;
            double cgh = c + 5.52468004077673;
            result = BoostGamma.Lanczos.lanczosSumExpGScaled(c) / (BoostGamma.Lanczos.lanczosSumExpGScaled(a) * BoostGamma.Lanczos.lanczosSumExpGScaled(b));
            double l1 = Math.log(cgh / bgh) * (b - 0.5);
            double l2 = Math.log(x * cgh / agh) * a;
            if (l1 > -708.0 && l1 < 709.0 && l2 > -708.0 && l2 < 709.0) {
                result = a * b < bgh * 10.0 ? (result *= Math.exp((b - 0.5) * Math.log1p(a / bgh))) : (result *= Math.pow(cgh / bgh, b - 0.5));
                result *= Math.pow(x * cgh / agh, a);
                result *= Math.sqrt(agh / Math.E);
            } else {
                result = Math.log(result) + l1 + l2 + (Math.log(agh) - 1.0) / 2.0;
                result = Math.exp(result);
            }
        } else {
            result = Math.pow(x, a);
        }
        double rescale = 1.0;
        if (result < Double.MIN_NORMAL) {
            if (s0 + result / a == s0) {
                return s0;
            }
            s0 *= 9.007199254740992E15;
            result *= 9.007199254740992E15;
            rescale = 1.110223E-16f;
        }
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        final double result1 = result;
        DoubleSupplier gen = new DoubleSupplier(){
            private double result;
            private final double poch;
            private int n;
            {
                this.result = result1;
                this.poch = -b;
            }

            @Override
            public double getAsDouble() {
                double r = this.result / (a + (double)this.n);
                ++this.n;
                this.result *= ((double)this.n + this.poch) * x / (double)this.n;
                return r;
            }
        };
        return BoostTools.sumSeries(gen, eps, maxIterations, s0) * rescale;
    }

    private static double risingFactorialRatio(double a, double b, int k) {
        double result = 1.0;
        for (int i = 0; i < k; ++i) {
            result *= (a + (double)i) / (b + (double)i);
        }
        return result;
    }

    private static double binomialCCdf(int n, int k, double x, double y) {
        double result = Math.pow(x, n);
        if (result > Double.MIN_NORMAL) {
            double term = result;
            for (int i = n - 1; i > k; --i) {
                result += (term *= (double)(i + 1) * y / ((double)(n - i) * x));
            }
        } else {
            int start = (int)((double)n * x);
            if (start <= k + 1) {
                start = k + 2;
            }
            if ((result = BoostBeta.binomialTerm(n, start, x, y)) == 0.0) {
                for (int i = start - 1; i > k; --i) {
                    result += BoostBeta.binomialTerm(n, i, x, y);
                }
            } else {
                int i;
                double term = result;
                double startTerm = result;
                for (i = start - 1; i > k; --i) {
                    result += (term *= (double)(i + 1) * y / ((double)(n - i) * x));
                }
                term = startTerm;
                for (i = start + 1; i <= n; ++i) {
                    result += (term *= (double)(n - i + 1) * x / ((double)i * y));
                }
            }
        }
        return result;
    }

    private static double binomialTerm(int n, int k, double x, double y) {
        double binom = BoostBeta.binomialCoefficient(n, k);
        if (!Double.isFinite(binom)) {
            return 0.0;
        }
        return binom * Math.pow(y, n - k) * Math.pow(x, k);
    }

    static double binomialCoefficient(int n, int k) {
        double result;
        int m = Math.min(k, n - k);
        if (m == 0) {
            return 1.0;
        }
        if (m == 1) {
            return n;
        }
        if (m == 2) {
            return 0.5 * (double)n * (double)(n - 1);
        }
        if (m == 3) {
            return 0.5 * (double)n * (double)(n - 1) * (double)(n - 2) / 3.0;
        }
        if (n <= 170) {
            result = BoostGamma.uncheckedFactorial(n);
            result /= BoostGamma.uncheckedFactorial(m);
            result /= BoostGamma.uncheckedFactorial(n - m);
        } else {
            result = 1.0;
            for (int i = 1; i < m; ++i) {
                result *= (double)(n - m + i);
                result /= (double)i;
            }
            if (result * (double)n > Double.MAX_VALUE) {
                result /= (double)m;
                result *= (double)n;
            } else {
                result *= (double)n;
                result /= (double)m;
            }
        }
        return Math.ceil(result - 0.5);
    }

    private static double ibetaAStep(double a, double b, double x, double y, int k, boolean normalised) {
        double prefix = BoostBeta.ibetaPowerTerms(a, b, x, y, normalised);
        if ((prefix /= a) == 0.0) {
            return prefix;
        }
        double sum = 1.0;
        double term = 1.0;
        for (int i = 0; i < k - 1; ++i) {
            sum += (term *= (a + b + (double)i) * x / (a + (double)i + 1.0));
        }
        return prefix *= sum;
    }

    private static double betaSmallBLargeASeries(double a, double b, double x, double y, double s0, double mult, Policy pol, boolean normalised) {
        double prefix;
        double bm1 = b - 1.0;
        double t = a + bm1 / 2.0;
        double lx = y < 0.35 ? Math.log1p(-y) : Math.log(x);
        double u = -t * lx;
        double h = BoostGamma.regularisedGammaPrefix(b, u);
        if (h <= Double.MIN_NORMAL) {
            if (s0 == 0.0) {
                return BoostBeta.ibetaFraction(a, b, x, y, pol, normalised);
            }
            return s0;
        }
        if (normalised) {
            prefix = h / GammaRatio.delta(a, b);
            prefix /= Math.pow(t, b);
        } else {
            prefix = BoostGamma.fullIgammaPrefix(b, u) / Math.pow(t, b);
        }
        double[] p = new double[30];
        p[0] = 1.0;
        double j = BoostGamma.gammaQ(b, u, pol) / h;
        double sum = s0 + (prefix *= mult) * j;
        int tnp1 = 1;
        double lx2 = lx / 2.0;
        lx2 *= lx2;
        double lxp = 1.0;
        double t4 = 4.0 * t * t;
        double b2n = b;
        for (int n = 1; n < 30; ++n) {
            double previous;
            tnp1 += 2;
            p[n] = 0.0;
            int tmp1 = 3;
            for (int m = 1; m < n; ++m) {
                double mbn = (double)m * b - (double)n;
                int n2 = n;
                p[n2] = p[n2] + mbn * p[n - m] / BoostGamma.uncheckedFactorial(tmp1);
                tmp1 += 2;
            }
            int n3 = n;
            p[n3] = p[n3] / (double)n;
            int n4 = n;
            p[n4] = p[n4] + bm1 / BoostGamma.uncheckedFactorial(tnp1);
            j = (b2n * (b2n + 1.0) * j + (u + b2n + 1.0) * lxp) / t4;
            lxp *= lx2;
            b2n += 2.0;
            double r = prefix * p[n] * j;
            if ((sum += r) == (previous = sum)) break;
        }
        return sum;
    }

    static double ibetaFraction2(final double a, final double b, final double x, final double y, Policy pol, boolean normalised) {
        double result = BoostBeta.ibetaPowerTerms(a, b, x, y, normalised);
        if (result == 0.0) {
            return result;
        }
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        Supplier<GeneralizedContinuedFraction.Coefficient> gen = new Supplier<GeneralizedContinuedFraction.Coefficient>(){
            private int m;

            @Override
            public GeneralizedContinuedFraction.Coefficient get() {
                double aN = (a + (double)this.m - 1.0) * (a + b + (double)this.m - 1.0) * (double)this.m * (b - (double)this.m) * x * x;
                double denom = a + (double)(2 * this.m) - 1.0;
                double bN = this.m;
                bN += (double)this.m * (b - (double)this.m) * x / (a + (double)(2 * this.m) - 1.0);
                ++this.m;
                return GeneralizedContinuedFraction.Coefficient.of((double)(aN /= denom * denom), (double)(bN += (a + (double)this.m) * (a * y - b * x + 1.0 + (double)this.m * (2.0 - x)) / (a + (double)(2 * this.m) + 1.0)));
            }
        };
        double fract = GeneralizedContinuedFraction.value((Supplier)gen, (double)eps, (int)maxIterations);
        return result / fract;
    }

    static double ibetaFraction(final double a, final double b, final double x, double y, Policy pol, boolean normalised) {
        double result = BoostBeta.ibetaPowerTerms(a, b, x, y, normalised);
        if (result == 0.0) {
            return result;
        }
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        Supplier<GeneralizedContinuedFraction.Coefficient> gen = new Supplier<GeneralizedContinuedFraction.Coefficient>(){
            private int n;

            @Override
            public GeneralizedContinuedFraction.Coefficient get() {
                int m = this.n;
                int k = m / 2;
                double aN = (m & 1) == 0 ? (double)k * (b - (double)k) * x / ((a + (double)m - 1.0) * (a + (double)m)) : -((a + (double)k) * (a + b + (double)k) * x) / ((a + (double)m - 1.0) * (a + (double)m));
                this.n = m + 1;
                return GeneralizedContinuedFraction.Coefficient.of((double)aN, (double)1.0);
            }
        };
        double fract = GeneralizedContinuedFraction.value((Supplier)gen, (double)eps, (int)maxIterations);
        return result / a / fract;
    }
}

