/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicOperationsTestCase
extends TestCase {
    public void executeIsEnabledTest(Log log) {
        try {
            log.isTraceEnabled();
            log.isDebugEnabled();
            log.isInfoEnabled();
            log.isWarnEnabled();
            log.isErrorEnabled();
            log.isFatalEnabled();
        }
        catch (Throwable t) {
            t.printStackTrace();
            BasicOperationsTestCase.fail((String)("Exception thrown: " + t));
        }
    }

    public void executeMessageWithExceptionTest(Log log) {
        try {
            log.trace((Object)"Hello, Mum", (Throwable)new ArithmeticException());
            log.debug((Object)"Hello, Mum", (Throwable)new ArithmeticException());
            log.info((Object)"Hello, Mum", (Throwable)new ArithmeticException());
            log.warn((Object)"Hello, Mum", (Throwable)new ArithmeticException());
            log.error((Object)"Hello, Mum", (Throwable)new ArithmeticException());
            log.fatal((Object)"Hello, Mum", (Throwable)new ArithmeticException());
        }
        catch (Throwable t) {
            t.printStackTrace();
            BasicOperationsTestCase.fail((String)("Exception thrown: " + t));
        }
    }

    public void executeMessageWithoutExceptionTest(Log log) {
        try {
            log.trace((Object)"Hello, Mum");
            log.debug((Object)"Hello, Mum");
            log.info((Object)"Hello, Mum");
            log.warn((Object)"Hello, Mum");
            log.error((Object)"Hello, Mum");
            log.fatal((Object)"Hello, Mum");
        }
        catch (Throwable t) {
            t.printStackTrace();
            BasicOperationsTestCase.fail((String)("Exception thrown: " + t));
        }
    }

    public void testIsEnabledClassLog() {
        Log log = LogFactory.getLog(BasicOperationsTestCase.class);
        this.executeIsEnabledTest(log);
    }

    public void testIsEnabledNamedLog() {
        Log log = LogFactory.getLog((String)BasicOperationsTestCase.class.getName());
        this.executeIsEnabledTest(log);
    }

    public void testMessageWithExceptionClassLog() {
        Log log = LogFactory.getLog(BasicOperationsTestCase.class);
        this.executeMessageWithExceptionTest(log);
    }

    public void testMessageWithExceptionNamedLog() {
        Log log = LogFactory.getLog((String)BasicOperationsTestCase.class.getName());
        this.executeMessageWithExceptionTest(log);
    }

    public void testMessageWithoutExceptionClassLog() {
        Log log = LogFactory.getLog(BasicOperationsTestCase.class);
        this.executeMessageWithoutExceptionTest(log);
    }

    public void testMessageWithoutExceptionNamedLog() {
        Log log = LogFactory.getLog((String)BasicOperationsTestCase.class.getName());
        this.executeMessageWithoutExceptionTest(log);
    }
}

