/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.swing.BindingException;
import org.apache.cayenne.util.Util;

public class BindingExpression {
    private Object compiled;
    protected String expression;

    static Throwable unwind(Throwable th) {
        if (th instanceof OgnlException) {
            Throwable reason = ((OgnlException)th).getReason();
            return reason != null ? BindingExpression.unwind(reason) : th;
        }
        return Util.unwindException((Throwable)th);
    }

    public BindingExpression(String expression) {
        try {
            this.compiled = Ognl.parseExpression((String)expression);
        }
        catch (OgnlException ex) {
            throw new CayenneRuntimeException("Invalid expression - " + expression, BindingBase.unwind(ex));
        }
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setValue(Object context, Map contextVariables, Object value) {
        if (context == null) {
            throw new BindingException("No context");
        }
        try {
            Ognl.setValue((Object)this.compiled, (Map)contextVariables, (Object)context, (Object)value);
        }
        catch (OgnlException ex) {
            throw new BindingException("Evaluation failed in context: " + context, BindingExpression.unwind(ex));
        }
    }

    public Object getValue(Object context, Map contextVariables) {
        if (context == null) {
            throw new BindingException("No context");
        }
        try {
            return Ognl.getValue((Object)this.compiled, (Map)contextVariables, (Object)context);
        }
        catch (OgnlException ex) {
            throw new BindingException("Evaluation failed in context: " + context, BindingExpression.unwind(ex));
        }
    }
}

