/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerConstants;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.project.CayenneUserDir;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {
    private static Log logObj = LogFactory.getLog(Main.class);

    public static void main(String[] args) {
        Main main = new Main();
        main.configureLogging();
        if (!main.checkJDKVersion()) {
            System.exit(1);
        }
        File projectFile = Main.projectFileFromArgs(args);
        main.runModeler(projectFile);
    }

    protected static File projectFileFromArgs(String[] args) {
        if (args.length == 1) {
            File f = new File(args[0]);
            if (f.isDirectory()) {
                f = new File(f, "cayenne.xml");
            }
            if (f.isFile() && "cayenne.xml".equals(f.getName())) {
                return f;
            }
        }
        return null;
    }

    protected static File projectFileFromPrefs() {
        PreferenceDetail autoLoadPref = Application.getInstance().getPreferenceDomain().getDetail("autoLoadProject", true);
        if (autoLoadPref != null && autoLoadPref.getBooleanProperty("autoLoadProject")) {
            ModelerPreferences modelerPreferences = ModelerPreferences.getPreferences();
            Vector arr = modelerPreferences.getVector("Editor.lastSeveralProjectFiles");
            return new File((String)arr.get(0));
        }
        return null;
    }

    protected void runModeler(final File projectFile) {
        logObj.info((Object)"Starting CayenneModeler.");
        this.configureLookAndFeel();
        Application.instance = new Application(projectFile);
        Runnable runnable = new Runnable(){

            public void run() {
                File projectFileFromPrefs;
                Application.instance.startup();
                if (null == projectFile && null != (projectFileFromPrefs = Main.projectFileFromPrefs())) {
                    OpenProjectAction action = new OpenProjectAction(Application.instance);
                    action.openProject(projectFileFromPrefs);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected boolean checkJDKVersion() {
        try {
            Class.forName("java.lang.StringBuilder");
            return true;
        }
        catch (Exception ex) {
            logObj.fatal((Object)"CayenneModeler requires JDK 1.5.");
            logObj.fatal((Object)("Found : '" + System.getProperty("java.version") + "' at " + System.getProperty("java.home")));
            JOptionPane.showMessageDialog(null, "Unsupported JDK at " + System.getProperty("java.home") + ". Set JAVA_HOME to the JDK1.5 location.", "Unsupported JDK Version", 0);
            return false;
        }
    }

    protected void configureLogging() {
        ModelerPreferences prefs = ModelerPreferences.getPreferences();
        boolean logfileEnabled = prefs.getBoolean("Editor.logfileEnabled", true);
        prefs.setProperty("Editor.logfileEnabled", String.valueOf(logfileEnabled));
        if (logfileEnabled) {
            String defaultPath = this.getLogFile().getPath();
            String logfilePath = prefs.getString("Editor.logfile", defaultPath);
            try {
                File logfile = new File(logfilePath);
                if (logfile != null) {
                    if (!logfile.exists()) {
                        File parent = logfile.getParentFile();
                        if (parent != null) {
                            parent.mkdirs();
                        }
                        if (!logfile.createNewFile()) {
                            return;
                        }
                    }
                    prefs.setProperty("Editor.logfile", logfilePath);
                }
            }
            catch (IOException ioex) {
                logObj.warn((Object)("Error setting logging - " + logfilePath), (Throwable)ioex);
            }
        }
    }

    protected String getLookAndFeelName() {
        ModelerPreferences prefs = ModelerPreferences.getPreferences();
        return prefs.getString("Editor.lookAndFeel", ModelerConstants.DEFAULT_LAF_NAME);
    }

    protected String getThemeName() {
        ModelerPreferences prefs = ModelerPreferences.getPreferences();
        return prefs.getString("Editor.theme", "Sky Bluer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureLookAndFeel() {
        ModelerPreferences prefs = ModelerPreferences.getPreferences();
        String lfName = this.getLookAndFeelName();
        String themeName = this.getThemeName();
        try {
            Class<?> lf = Class.forName(lfName);
            if (PlasticLookAndFeel.class.isAssignableFrom(lf)) {
                PlasticTheme foundTheme = this.themeWithName(themeName);
                if (foundTheme == null) {
                    logObj.warn((Object)("Could not set selected theme '" + themeName + "' - using default '" + "Sky Bluer" + "'."));
                    themeName = "Sky Bluer";
                    foundTheme = this.themeWithName(themeName);
                }
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)foundTheme);
            }
            UIManager.setLookAndFeel(lfName);
        }
        catch (Exception e) {
            logObj.warn((Object)("Could not set selected LookAndFeel '" + lfName + "' - using default '" + ModelerConstants.DEFAULT_LAF_NAME + "'."));
            lfName = ModelerConstants.DEFAULT_LAF_NAME;
            themeName = "Sky Bluer";
            PlasticTheme defaultTheme = this.themeWithName(themeName);
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)defaultTheme);
            try {
                UIManager.setLookAndFeel(lfName);
            }
            catch (Exception retry) {
                // empty catch block
            }
        }
        finally {
            prefs.setProperty("Editor.lookAndFeel", UIManager.getLookAndFeel().getClass().getName());
            prefs.setProperty("Editor.theme", themeName);
        }
    }

    protected PlasticTheme themeWithName(String themeName) {
        List availableThemes = PlasticLookAndFeel.getInstalledThemes();
        for (PlasticTheme aTheme : availableThemes) {
            if (!themeName.equals(aTheme.getName())) continue;
            return aTheme;
        }
        return null;
    }

    protected File getLogFile() {
        if (!CayenneUserDir.getInstance().canWrite()) {
            return null;
        }
        return CayenneUserDir.getInstance().resolveFile("modeler.log");
    }
}

