/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGeneratorResourceLoader;
import org.apache.cayenne.gen.DataMapArtifact;
import org.apache.cayenne.gen.EmbeddableArtifact;
import org.apache.cayenne.gen.EntityArtifact;
import org.apache.cayenne.gen.ImportUtils;
import org.apache.cayenne.gen.MetadataUtils;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.gen.ToolsUtilsFactory;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.slf4j.Logger;

public class ClassGenerationAction {
    private static final String TEMPLATES_DIR_NAME = "templates/v4_1/";
    public static final String SINGLE_CLASS_TEMPLATE = "templates/v4_1/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE = "templates/v4_1/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "templates/v4_1/superclass.vm";
    public static final String EMBEDDABLE_SINGLE_CLASS_TEMPLATE = "templates/v4_1/embeddable-singleclass.vm";
    public static final String EMBEDDABLE_SUBCLASS_TEMPLATE = "templates/v4_1/embeddable-subclass.vm";
    public static final String EMBEDDABLE_SUPERCLASS_TEMPLATE = "templates/v4_1/embeddable-superclass.vm";
    public static final String DATAMAP_SINGLE_CLASS_TEMPLATE = "templates/v4_1/datamap-singleclass.vm";
    public static final String DATAMAP_SUBCLASS_TEMPLATE = "templates/v4_1/datamap-subclass.vm";
    public static final String DATAMAP_SUPERCLASS_TEMPLATE = "templates/v4_1/datamap-superclass.vm";
    public static final String SUPERCLASS_PREFIX = "_";
    private static final String WILDCARD = "*";
    private static final String CGEN_ROOT_PATH = "cayenne.cgen.rootpath";
    protected CgenConfiguration cgenConfiguration;
    protected Logger logger;
    protected Context context;
    protected Map<String, Template> templateCache;
    private ToolsUtilsFactory utilsFactory;
    private MetadataUtils metadataUtils;

    public ClassGenerationAction(CgenConfiguration cgenConfig) {
        this.cgenConfiguration = cgenConfig;
        String toolConfigFile = cgenConfig.getExternalToolConfig();
        if (System.getProperty("org.apache.velocity.tools") != null || toolConfigFile != null) {
            ToolManager manager = new ToolManager(true, true);
            if (toolConfigFile != null) {
                FactoryConfiguration config = ConfigurationUtils.find((String)toolConfigFile);
                manager.getToolboxFactory().configure(config);
            }
            this.context = manager.createContext();
        } else {
            this.context = new VelocityContext();
        }
        this.templateCache = new HashMap<String, Template>(5);
    }

    public String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: {
                return SINGLE_CLASS_TEMPLATE;
            }
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return EMBEDDABLE_SUBCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUPERCLASS: {
                return EMBEDDABLE_SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return EMBEDDABLE_SINGLE_CLASS_TEMPLATE;
            }
            case DATAMAP_SINGLE_CLASS: {
                return DATAMAP_SINGLE_CLASS_TEMPLATE;
            }
            case DATAMAP_SUPERCLASS: {
                return DATAMAP_SUPERCLASS_TEMPLATE;
            }
            case DATAMAP_SUBCLASS: {
                return DATAMAP_SUBCLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    public String customTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: 
            case ENTITY_SUBCLASS: {
                return this.cgenConfiguration.getTemplate();
            }
            case ENTITY_SUPERCLASS: {
                return this.cgenConfiguration.getSuperTemplate();
            }
            case EMBEDDABLE_SUBCLASS: 
            case EMBEDDABLE_SINGLE_CLASS: {
                return this.cgenConfiguration.getEmbeddableTemplate();
            }
            case EMBEDDABLE_SUPERCLASS: {
                return this.cgenConfiguration.getEmbeddableSuperTemplate();
            }
            case DATAMAP_SINGLE_CLASS: 
            case DATAMAP_SUBCLASS: {
                return this.cgenConfiguration.getQueryTemplate();
            }
            case DATAMAP_SUPERCLASS: {
                return this.cgenConfiguration.getQuerySuperTemplate();
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    public void resetContextForArtifact(Artifact artifact) {
        StringUtils stringUtils = StringUtils.getInstance();
        String qualifiedClassName = artifact.getQualifiedClassName();
        String packageName = stringUtils.stripClass(qualifiedClassName);
        String className = stringUtils.stripPackageName(qualifiedClassName);
        String qualifiedBaseClassName = artifact.getQualifiedBaseClassName();
        String basePackageName = stringUtils.stripClass(qualifiedBaseClassName);
        String baseClassName = stringUtils.stripPackageName(qualifiedBaseClassName);
        String superClassName = SUPERCLASS_PREFIX + stringUtils.stripPackageName(qualifiedClassName);
        String superPackageName = this.cgenConfiguration.getSuperPkg();
        if (superPackageName == null || superPackageName.isEmpty()) {
            superPackageName = packageName + ".auto";
        }
        this.context.put("baseClassName", (Object)baseClassName);
        this.context.put("basePackageName", (Object)basePackageName);
        this.context.put("subClassName", (Object)className);
        this.context.put("subPackageName", (Object)packageName);
        this.context.put("superClassName", (Object)superClassName);
        this.context.put("superPackageName", (Object)superPackageName);
        this.context.put("object", artifact.getObject());
        this.context.put("stringUtils", (Object)stringUtils);
        this.context.put("createPropertyNames", (Object)this.cgenConfiguration.isCreatePropertyNames());
        this.context.put("createPKProperties", (Object)this.cgenConfiguration.isCreatePKProperties());
    }

    void resetContextForArtifactTemplate(Artifact artifact) {
        ImportUtils importUtils = this.utilsFactory.createImportUtils();
        this.context.put("importUtils", (Object)importUtils);
        this.context.put("propertyUtils", (Object)this.utilsFactory.createPropertyUtils(this.logger, importUtils));
        this.context.put("metadataUtils", (Object)this.metadataUtils);
        artifact.postInitContext(this.context);
    }

    public void addEntities(Collection<ObjEntity> entities) {
        if (entities != null) {
            for (ObjEntity entity : entities) {
                this.cgenConfiguration.addArtifact(new EntityArtifact(entity));
            }
        }
    }

    public void addEmbeddables(Collection<Embeddable> embeddables) {
        if (embeddables != null) {
            for (Embeddable embeddable : embeddables) {
                this.cgenConfiguration.addArtifact(new EmbeddableArtifact(embeddable));
            }
        }
    }

    public void addQueries(Collection<QueryDescriptor> queries) {
        if (this.cgenConfiguration.getArtifactsGenerationMode().equals(ArtifactsGenerationMode.ALL.getLabel()) && queries != null) {
            DataMapArtifact artifact = new DataMapArtifact(this.cgenConfiguration.getDataMap(), queries);
            if (!this.cgenConfiguration.getArtifacts().contains(artifact)) {
                this.cgenConfiguration.addArtifact(artifact);
            }
        }
    }

    public void prepareArtifacts() {
        this.cgenConfiguration.getArtifacts().clear();
        this.addEntities(this.cgenConfiguration.getEntities().stream().map(entity -> this.cgenConfiguration.getDataMap().getObjEntity(entity)).collect(Collectors.toList()));
        this.addEmbeddables(this.cgenConfiguration.getEmbeddables().stream().map(embeddable -> this.cgenConfiguration.getDataMap().getEmbeddable(embeddable)).collect(Collectors.toList()));
        this.addQueries(this.cgenConfiguration.getDataMap().getQueryDescriptors());
    }

    public void execute() throws Exception {
        this.validateAttributes();
        try {
            for (Artifact artifact : this.cgenConfiguration.getArtifacts()) {
                this.execute(artifact);
            }
        }
        finally {
            this.templateCache.clear();
        }
    }

    protected void execute(Artifact artifact) throws Exception {
        TemplateType[] templateTypes;
        this.resetContextForArtifact(artifact);
        ArtifactGenerationMode artifactMode = this.cgenConfiguration.isMakePairs() ? ArtifactGenerationMode.GENERATION_GAP : ArtifactGenerationMode.SINGLE_CLASS;
        for (TemplateType type : templateTypes = artifact.getTemplateTypes(artifactMode)) {
            try (Writer out = this.openWriter(type);){
                if (out == null) continue;
                this.resetContextForArtifactTemplate(artifact);
                this.getTemplate(type).merge(this.context, out);
            }
        }
    }

    Template getTemplate(TemplateType type) {
        Template template;
        String templateName = this.customTemplateName(type);
        if (templateName == null) {
            templateName = this.defaultTemplateName(type);
        }
        if ((template = this.templateCache.get(templateName)) == null) {
            Properties props = new Properties();
            props.put("resource.loaders", "cayenne");
            props.put("resource.loader.cayenne.class", ClassGeneratorResourceLoader.class.getName());
            props.put("resource.loader.cayenne.cache", "false");
            if (this.cgenConfiguration.getRootPath() != null) {
                props.put("resource.loader.cayenne.root", this.cgenConfiguration.getRootPath().toString());
            }
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(props);
            template = velocityEngine.getTemplate(templateName);
            this.templateCache.put(templateName, template);
        }
        return template;
    }

    private void validateAttributes() {
        Path dir = this.cgenConfiguration.buildPath();
        if (dir == null) {
            throw new CayenneRuntimeException("'rootPath' attribute is missing.", new Object[0]);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("can't create directory", new Object[0]);
            }
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new CayenneRuntimeException("'destDir' is not a directory.", new Object[0]);
        }
        if (!Files.isWritable(dir)) {
            throw new CayenneRuntimeException("Do not have write permissions for %s", new Object[]{dir});
        }
    }

    protected Writer openWriter(TemplateType templateType) throws Exception {
        File outFile;
        File file = outFile = templateType.isSuperclass() ? this.fileForSuperclass() : this.fileForClass();
        if (outFile == null) {
            return null;
        }
        if (this.logger != null) {
            String label = templateType.isSuperclass() ? "superclass" : "class";
            this.logger.info("Generating " + label + " file: " + outFile.getCanonicalPath());
        }
        FileOutputStream out = new FileOutputStream(outFile);
        return this.cgenConfiguration.getEncoding() != null ? new OutputStreamWriter((OutputStream)out, this.cgenConfiguration.getEncoding()) : new OutputStreamWriter(out);
    }

    private File fileForSuperclass() throws Exception {
        String packageName = (String)this.context.get("superPackageName");
        String className = (String)this.context.get("superClassName");
        String filename = StringUtils.getInstance().replaceWildcardInStringWithString(WILDCARD, this.cgenConfiguration.getOutputPattern(), className);
        File dest = new File(this.mkpath(new File(this.cgenConfiguration.buildPath().toString()), packageName), filename);
        if (dest.exists() && !this.fileNeedUpdate(dest, this.cgenConfiguration.getSuperTemplate())) {
            return null;
        }
        return dest;
    }

    private File fileForClass() throws Exception {
        String packageName = (String)this.context.get("subPackageName");
        String className = (String)this.context.get("subClassName");
        String filename = StringUtils.getInstance().replaceWildcardInStringWithString(WILDCARD, this.cgenConfiguration.getOutputPattern(), className);
        File dest = new File(this.mkpath(new File(Objects.requireNonNull(this.cgenConfiguration.buildPath()).toString()), packageName), filename);
        if (dest.exists()) {
            if (this.cgenConfiguration.isMakePairs()) {
                return null;
            }
            if (!this.cgenConfiguration.isOverwrite()) {
                return null;
            }
            if (!this.fileNeedUpdate(dest, this.cgenConfiguration.getTemplate())) {
                return null;
            }
        }
        return dest;
    }

    protected boolean fileNeedUpdate(File dest, String templateFileName) {
        if (this.cgenConfiguration.isForce()) {
            return true;
        }
        if (this.isOld(dest)) {
            if (templateFileName == null) {
                return false;
            }
            File templateFile = new File(templateFileName);
            return templateFile.lastModified() >= dest.lastModified();
        }
        return true;
    }

    protected boolean isOld(File file) {
        return file.lastModified() > this.cgenConfiguration.getTimestamp();
    }

    private File mkpath(File dest, String pkgName) throws Exception {
        if (!this.cgenConfiguration.isUsePkgPath() || pkgName == null) {
            return dest;
        }
        String path = pkgName.replace('.', File.separatorChar);
        File fullPath = new File(dest, path);
        if (!fullPath.isDirectory() && !fullPath.mkdirs()) {
            throw new Exception("Error making path: " + fullPath);
        }
        return fullPath;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public CgenConfiguration getCgenConfiguration() {
        return this.cgenConfiguration;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setCgenConfiguration(CgenConfiguration cgenConfiguration) {
        this.cgenConfiguration = cgenConfiguration;
    }

    public ToolsUtilsFactory getUtilsFactory() {
        return this.utilsFactory;
    }

    public void setUtilsFactory(ToolsUtilsFactory utilsFactory) {
        this.utilsFactory = utilsFactory;
    }

    public void setMetadataUtils(MetadataUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    public MetadataUtils getMetadataUtils() {
        return this.metadataUtils;
    }
}

