/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.Property;

public interface IdProperty<E>
extends Property<E> {
    default public Expression eq(ObjectId value) {
        Object pkValue;
        if (!this.getEntityName().equals(value.getEntityName())) {
            throw new CayenneRuntimeException("Can match IdProperty only with ObjectId for same entity", new Object[0]);
        }
        Map<String, Object> idSnapshot = value.getIdSnapshot();
        if (this.getAttributeName() == null) {
            if (idSnapshot.size() > 1) {
                throw new CayenneRuntimeException("Can't match IdProperty with compound PK", new Object[0]);
            }
            pkValue = idSnapshot.values().iterator().next();
        } else {
            pkValue = idSnapshot.get(this.getAttributeName());
            if (pkValue == null && !idSnapshot.containsKey(this.getAttributeName())) {
                throw new CayenneRuntimeException("No PK attribute %s for ObjectId %s", this.getAttributeName(), value);
            }
        }
        return ExpressionFactory.matchExp(this.getExpression(), pkValue);
    }

    public String getEntityName();

    public String getAttributeName();
}

