/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import org.jclouds.compute.domain.OsFamily;

public class OperatingSystems {
    protected static final String CENTOS = "CENTOS";
    protected static final String DEBIAN = "DEBIAN";
    protected static final String RHEL = "REDHAT";
    protected static final String UBUNTU = "UBUNTU";
    protected static final String WINDOWS = "WIN_";
    protected static final String CLOUD_LINUX = "CLOUDLINUX";
    protected static final String VYATTACE = "VYATTACE";

    public static Function<String, OsFamily> osFamily() {
        return new Function<String, OsFamily>(){

            public OsFamily apply(String description) {
                if (description != null) {
                    if (description.startsWith(OperatingSystems.CENTOS)) {
                        return OsFamily.CENTOS;
                    }
                    if (description.startsWith(OperatingSystems.DEBIAN)) {
                        return OsFamily.DEBIAN;
                    }
                    if (description.startsWith(OperatingSystems.RHEL)) {
                        return OsFamily.RHEL;
                    }
                    if (description.startsWith(OperatingSystems.UBUNTU)) {
                        return OsFamily.UBUNTU;
                    }
                    if (description.startsWith(OperatingSystems.WINDOWS)) {
                        return OsFamily.WINDOWS;
                    }
                    if (description.startsWith(OperatingSystems.CLOUD_LINUX)) {
                        return OsFamily.CLOUD_LINUX;
                    }
                    if (description.startsWith(OperatingSystems.VYATTACE)) {
                        return OsFamily.LINUX;
                    }
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }

    public static Function<String, Integer> bits() {
        return new Function<String, Integer>(){

            public Integer apply(String operatingSystemReferenceCode) {
                if (operatingSystemReferenceCode != null) {
                    return Ints.tryParse((String)((String)Iterables.getLast((Iterable)Splitter.on((String)"_").split((CharSequence)operatingSystemReferenceCode))));
                }
                return null;
            }
        };
    }

    public static Function<String, String> version() {
        return new Function<String, String>(){

            public String apply(String version) {
                return OperatingSystems.parseVersion(version);
            }
        };
    }

    private static String parseVersion(String version) {
        if (version.contains("-")) {
            String rawVersion = version.substring(0, version.lastIndexOf("-"));
            if (Iterables.size((Iterable)Splitter.on((String)".").split((CharSequence)rawVersion)) == 3) {
                return rawVersion.substring(0, rawVersion.lastIndexOf("."));
            }
            return rawVersion;
        }
        if (version.contains(" ")) {
            return version.substring(0, version.indexOf(" "));
        }
        if (version.matches("^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$")) {
            return version;
        }
        return null;
    }
}

