/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.VMSize;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineInstance;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface VirtualMachineApi {
    @Named(value="GetVirtualMachine")
    @GET
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualMachine get(@PathParam(value="name") String var1);

    @Named(value="GetVirtualMachineInstance")
    @GET
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/instanceView")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualMachineInstance getInstanceDetails(@PathParam(value="name") String var1);

    @Named(value="CreateOrUpdateVirtualMachine")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{vmname}")
    @QueryParams(keys={"validating"}, values={"false"})
    public VirtualMachine createOrUpdate(@PathParam(value="vmname") String var1, @PayloadParam(value="location") String var2, @PayloadParam(value="properties") VirtualMachineProperties var3, @PayloadParam(value="tags") Map<String, String> var4, @Nullable @PayloadParam(value="plan") Plan var5);

    @Named(value="ListVirtualMachines")
    @GET
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualMachine> list();

    @Named(value="ListVirtualMachinesAll")
    @GET
    @Path(value="/providers/Microsoft.Compute/virtualMachines")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualMachine> listAll();

    @Named(value="ListVirtualMachinesByLocation")
    @GET
    @Path(value="/providers/Microsoft.Compute/locations/{location}/virtualMachines")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualMachine> listByLocation(@PathParam(value="location") String var1);

    @Named(value="ListAvailableSizes")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/vmSizes")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VMSize> listAvailableSizes(@PathParam(value="name") String var1);

    @Named(value="DeleteVirtualMachine")
    @DELETE
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}")
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="name") String var1);

    @Named(value="RestartVirtualMachine")
    @POST
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/restart")
    public void restart(@PathParam(value="name") String var1);

    @Named(value="StartVirtualMachine")
    @POST
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/start")
    public void start(@PathParam(value="name") String var1);

    @Named(value="StopVirtualMachine")
    @POST
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/powerOff")
    public void stop(@PathParam(value="name") String var1);

    @Named(value="DeallocateVirtualMachine")
    @POST
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/deallocate")
    public void deallocate(@PathParam(value="name") String var1);

    @Named(value="generalize")
    @POST
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/generalize")
    public void generalize(@PathParam(value="name") String var1);

    @Named(value="capture")
    @POST
    @Payload(value="%7B\"vhdPrefix\":\"{vhdPrefix}\",\"destinationContainerName\":\"{destinationContainerName}\",\"overwriteVhds\":\"true\"%7D")
    @Path(value="/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/virtualMachines/{name}/capture")
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Produces(value={"application/json"})
    public URI capture(@PathParam(value="name") String var1, @PayloadParam(value="vhdPrefix") String var2, @PayloadParam(value="destinationContainerName") String var3);
}

