/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_ContentLink;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_Dependency;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_DeploymentProperties;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_Provider;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_ProviderResourceType;
import org.jclouds.azurecompute.arm.domain.AutoValue_Deployment_TypeValue;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Deployment {
    @Nullable
    public abstract String id();

    public abstract String name();

    @Nullable
    public abstract DeploymentProperties properties();

    @SerializedNames(value={"id", "name", "properties"})
    public static Deployment create(String id, String name, DeploymentProperties properties) {
        return new AutoValue_Deployment(id, name, properties);
    }

    public static abstract class DeploymentProperties
    implements Provisionable {
        @Override
        @Nullable
        public abstract String provisioningState();

        @Nullable
        public abstract String correlationId();

        @Nullable
        public abstract String timestamp();

        @Nullable
        public abstract Map<String, JsonBall> outputs();

        @Nullable
        public abstract List<Provider> providers();

        @Nullable
        public abstract List<Dependency> dependencies();

        @Nullable
        public abstract Map<String, JsonBall> template();

        @Nullable
        public abstract ContentLink templateLink();

        @Nullable
        public abstract Map<String, JsonBall> parameters();

        @Nullable
        public abstract ContentLink parametersLink();

        public abstract String mode();

        @Nullable
        public abstract String duration();

        @Nullable
        public abstract List<Map<String, String>> outputResources();

        @SerializedNames(value={"provisioningState", "correlationId", "timestamp", "outputs", "providers", "dependencies", "template", "templateLink", "parameters", "parametersLink", "mode", "duration", "outputResources"})
        public static DeploymentProperties create(String provisioningState, String correlationId, String timestamp, @Nullable Map<String, JsonBall> outputs, List<Provider> providers, List<Dependency> dependencies, Map<String, JsonBall> template, ContentLink templateLink, Map<String, JsonBall> parameters, ContentLink parametersLink, String mode, String duration, List<Map<String, String>> outputResources) {
            return new AutoValue_Deployment_DeploymentProperties(provisioningState, correlationId, timestamp, (Map<String, JsonBall>)(outputs == null ? ImmutableMap.builder().build() : ImmutableMap.copyOf(outputs)), (List<Provider>)(providers == null ? null : ImmutableList.copyOf(providers)), (List<Dependency>)(dependencies == null ? null : ImmutableList.copyOf(dependencies)), (Map<String, JsonBall>)(template == null ? ImmutableMap.builder().build() : ImmutableMap.copyOf(template)), templateLink, (Map<String, JsonBall>)(parameters == null ? ImmutableMap.builder().build() : ImmutableMap.copyOf(parameters)), parametersLink, mode, duration, (List<Map<String, String>>)(outputResources == null ? null : ImmutableList.copyOf(outputResources)));
        }
    }

    public static abstract class ContentLink {
        public abstract String uri();

        @Nullable
        public abstract String contentVersion();

        @SerializedNames(value={"uri", "contentVersion"})
        public static ContentLink create(String uri, String contentVersion) {
            return new AutoValue_Deployment_ContentLink(uri, contentVersion);
        }
    }

    public static abstract class Dependency {
        @Nullable
        public abstract List<Dependency> dependencies();

        @Nullable
        public abstract List<Dependency> dependsOn();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String resourceType();

        @Nullable
        public abstract String resourceName();

        @SerializedNames(value={"dependencies", "dependsOn", "id", "resourceType", "resourceName"})
        public static Dependency create(List<Dependency> dependencies, List<Dependency> dependsOn, String id, String resourceType, String resourceName) {
            return new AutoValue_Deployment_Dependency((List<Dependency>)(dependencies == null ? null : ImmutableList.copyOf(dependencies)), (List<Dependency>)(dependsOn == null ? null : ImmutableList.copyOf(dependsOn)), id, resourceType, resourceName);
        }
    }

    public static abstract class Provider {
        @Nullable
        public abstract String id();

        @Nullable
        public abstract String namespace();

        @Nullable
        public abstract String registrationState();

        @Nullable
        public abstract List<ProviderResourceType> resourceTypes();

        @SerializedNames(value={"id", "namespace", "registrationState", "resourceTypes"})
        public static Provider create(String id, String namespace, String registrationState, List<ProviderResourceType> resourceTypes) {
            return new AutoValue_Deployment_Provider(id, namespace, registrationState, (List<ProviderResourceType>)(resourceTypes == null ? null : ImmutableList.copyOf(resourceTypes)));
        }
    }

    public static abstract class ProviderResourceType {
        @Nullable
        public abstract String resourceType();

        @Nullable
        public abstract List<String> locations();

        @Nullable
        public abstract List<String> apiVersions();

        @Nullable
        public abstract Map<String, JsonBall> properties();

        @SerializedNames(value={"resourceType", "locations", "apiVersions", "properties"})
        public static ProviderResourceType create(String resourceType, List<String> locations, List<String> apiVersions, @Nullable Map<String, JsonBall> properties) {
            return new AutoValue_Deployment_ProviderResourceType(resourceType, (List<String>)(locations == null ? null : ImmutableList.copyOf(locations)), (List<String>)(apiVersions == null ? null : ImmutableList.copyOf(apiVersions)), (Map<String, JsonBall>)(properties == null ? ImmutableMap.builder().build() : ImmutableMap.copyOf(properties)));
        }
    }

    public static abstract class TypeValue {
        public abstract String type();

        public abstract String value();

        @SerializedNames(value={"type", "value"})
        public static TypeValue create(String type, String value) {
            return new AutoValue_Deployment_TypeValue(type, value);
        }
    }

    public static enum DeploymentMode {
        INCREMENTAL,
        COMPLETE,
        UNRECOGNIZED;


        public static DeploymentMode fromValue(String text) {
            return (DeploymentMode)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }

    public static enum ProvisioningState {
        ACCEPTED,
        READY,
        CANCELED,
        FAILED,
        DELETED,
        SUCCEEDED,
        RUNNING,
        UNRECOGNIZED;


        public static ProvisioningState fromValue(String text) {
            return (ProvisioningState)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }
}

