/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.azurecompute.arm.domain.ServicePrincipal;

final class AutoValue_ServicePrincipal
extends ServicePrincipal {
    private final String appId;
    private final Date deletionTimestamp;
    private final String displayName;
    private final String objectId;
    private final String objectType;
    private final List<String> servicePrincipalNames;

    private AutoValue_ServicePrincipal(@Nullable String appId, @Nullable Date deletionTimestamp, @Nullable String displayName, String objectId, String objectType, List<String> servicePrincipalNames) {
        this.appId = appId;
        this.deletionTimestamp = deletionTimestamp;
        this.displayName = displayName;
        this.objectId = objectId;
        this.objectType = objectType;
        this.servicePrincipalNames = servicePrincipalNames;
    }

    @Override
    @Nullable
    public String appId() {
        return this.appId;
    }

    @Override
    @Nullable
    public Date deletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    @Nullable
    public String displayName() {
        return this.displayName;
    }

    @Override
    public String objectId() {
        return this.objectId;
    }

    @Override
    public String objectType() {
        return this.objectType;
    }

    @Override
    public List<String> servicePrincipalNames() {
        return this.servicePrincipalNames;
    }

    public String toString() {
        return "ServicePrincipal{appId=" + this.appId + ", deletionTimestamp=" + this.deletionTimestamp + ", displayName=" + this.displayName + ", objectId=" + this.objectId + ", objectType=" + this.objectType + ", servicePrincipalNames=" + this.servicePrincipalNames + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServicePrincipal) {
            ServicePrincipal that = (ServicePrincipal)o;
            return (this.appId == null ? that.appId() == null : this.appId.equals(that.appId())) && (this.deletionTimestamp == null ? that.deletionTimestamp() == null : this.deletionTimestamp.equals(that.deletionTimestamp())) && (this.displayName == null ? that.displayName() == null : this.displayName.equals(that.displayName())) && this.objectId.equals(that.objectId()) && this.objectType.equals(that.objectType()) && this.servicePrincipalNames.equals(that.servicePrincipalNames());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.appId == null ? 0 : this.appId.hashCode();
        h *= 1000003;
        h ^= this.deletionTimestamp == null ? 0 : this.deletionTimestamp.hashCode();
        h *= 1000003;
        h ^= this.displayName == null ? 0 : this.displayName.hashCode();
        h *= 1000003;
        h ^= this.objectId.hashCode();
        h *= 1000003;
        h ^= this.objectType.hashCode();
        h *= 1000003;
        return h ^= this.servicePrincipalNames.hashCode();
    }

    @Override
    public ServicePrincipal.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ServicePrincipal.Builder {
        private String appId;
        private Date deletionTimestamp;
        private String displayName;
        private String objectId;
        private String objectType;
        private List<String> servicePrincipalNames;

        Builder() {
        }

        private Builder(ServicePrincipal source) {
            this.appId = source.appId();
            this.deletionTimestamp = source.deletionTimestamp();
            this.displayName = source.displayName();
            this.objectId = source.objectId();
            this.objectType = source.objectType();
            this.servicePrincipalNames = source.servicePrincipalNames();
        }

        @Override
        public ServicePrincipal.Builder appId(@Nullable String appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public ServicePrincipal.Builder deletionTimestamp(@Nullable Date deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
            return this;
        }

        @Override
        public ServicePrincipal.Builder displayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public ServicePrincipal.Builder objectId(String objectId) {
            if (objectId == null) {
                throw new NullPointerException("Null objectId");
            }
            this.objectId = objectId;
            return this;
        }

        @Override
        public ServicePrincipal.Builder objectType(String objectType) {
            if (objectType == null) {
                throw new NullPointerException("Null objectType");
            }
            this.objectType = objectType;
            return this;
        }

        @Override
        public ServicePrincipal.Builder servicePrincipalNames(List<String> servicePrincipalNames) {
            if (servicePrincipalNames == null) {
                throw new NullPointerException("Null servicePrincipalNames");
            }
            this.servicePrincipalNames = servicePrincipalNames;
            return this;
        }

        @Override
        public ServicePrincipal build() {
            String missing = "";
            if (this.objectId == null) {
                missing = missing + " objectId";
            }
            if (this.objectType == null) {
                missing = missing + " objectType";
            }
            if (this.servicePrincipalNames == null) {
                missing = missing + " servicePrincipalNames";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ServicePrincipal(this.appId, this.deletionTimestamp, this.displayName, this.objectId, this.objectType, this.servicePrincipalNames);
        }
    }
}

