/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.karaf.commands;

import java.util.Collections;
import java.util.Optional;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.karaf.commands.completers.EntityIdCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="brooklyn", name="entity-info", description="Display entity info")
@Service
public class EntityInfo
implements Action {
    @Reference
    private ManagementContext managementContext;
    @Option(name="-a", aliases={"--all"}, description="Display all information")
    private Boolean displayAll = false;
    @Option(name="-c", aliases={"--children"}, description="Display child information")
    private Boolean displayChildren = false;
    @Option(name="-s", aliases={"--sensors"}, description="Display sensor information")
    private Boolean displaySensors = false;
    @Option(name="--cfg", aliases={"--config"}, description="Display config information")
    private Boolean displayConfig = false;
    @Option(name="--blueprint", description="Display blueprint")
    private Boolean displayBlueprint = false;
    @Argument(index=0, name="id", description="The entity id", required=true)
    @Completion(value=EntityIdCompleter.class)
    private String id = null;

    public Object execute() throws Exception {
        Optional<String> bluePrint;
        Optional<Entity> entity = Optional.ofNullable(this.managementContext.getEntityManager().getEntity(this.id));
        if (!entity.isPresent()) {
            System.err.println(String.format("Entity [%s] not found", this.id));
            return null;
        }
        this.printHeader("Basic Information");
        ShellTable infoTable = new ShellTable();
        infoTable.column("").bold();
        infoTable.column("");
        infoTable.noHeaders();
        infoTable.addRow().addContent(new Object[]{"Application Id", entity.get().getApplicationId()});
        infoTable.addRow().addContent(new Object[]{"Application Name", entity.get().getApplication().getDisplayName()});
        infoTable.addRow().addContent(new Object[]{"Name", entity.get().getDisplayName()});
        infoTable.addRow().addContent(new Object[]{"Id", this.id});
        infoTable.addRow().addContent(new Object[]{"UP", entity.get().sensors().get(Attributes.SERVICE_UP)});
        infoTable.addRow().addContent(new Object[]{"State", entity.get().sensors().get(Attributes.SERVICE_STATE_ACTUAL)});
        infoTable.addRow().addContent(new Object[]{"Expected State", entity.get().sensors().get(Attributes.SERVICE_STATE_EXPECTED)});
        infoTable.print(System.out, true);
        if (this.displayChildren.booleanValue() || this.displayAll.booleanValue()) {
            this.printHeader("Child Information");
            ShellTable childrenTable = new ShellTable();
            childrenTable.column("id");
            childrenTable.column("name");
            entity.get().getChildren().forEach(child -> childrenTable.addRow().addContent(new Object[]{child.getId(), child.getDisplayName()}));
            childrenTable.print(System.out, true);
        }
        if (this.displaySensors.booleanValue() || this.displayAll.booleanValue()) {
            this.printHeader("Sensor Information");
            ShellTable sensorTable = new ShellTable();
            sensorTable.column("name");
            sensorTable.column("value");
            sensorTable.column("description");
            entity.get().getEntityType().getSensors().stream().filter(AttributeSensor.class::isInstance).map(AttributeSensor.class::cast).forEach(sensor -> sensorTable.addRow().addContent(new Object[]{sensor.getName(), ((Entity)entity.get()).getAttribute(sensor), sensor.getDescription()}));
            sensorTable.print(System.out, true);
        }
        if (this.displayConfig.booleanValue() || this.displayAll.booleanValue()) {
            this.printHeader("Config Information");
            ShellTable configTable = new ShellTable();
            configTable.column("name");
            configTable.column("value");
            configTable.column("description");
            entity.get().getEntityType().getConfigKeys().stream().forEach(configKey -> configTable.addRow().addContent(new Object[]{configKey.getName(), ((Entity)entity.get()).getConfig(configKey), configKey.getDescription()}));
            configTable.print(System.out, true);
        }
        if ((this.displayBlueprint.booleanValue() || this.displayAll.booleanValue()) && (bluePrint = Optional.ofNullable(BrooklynTags.findFirstNamedStringTag((String)"yaml_spec", (Iterable)entity.get().tags().getTags())).map(BrooklynTags.NamedStringTag::getContents)).isPresent()) {
            this.printHeader("Blueprint Information");
            System.out.println("---");
            System.out.print(bluePrint.get());
            System.out.println("...");
        }
        System.out.println();
        return null;
    }

    private void printHeader(String header) {
        System.out.println("\n" + SimpleAnsi.COLOR_CYAN + SimpleAnsi.INTENSITY_BOLD + header + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT);
        System.out.println(SimpleAnsi.INTENSITY_BOLD + String.join((CharSequence)"", Collections.nCopies(header.length(), "-")) + SimpleAnsi.INTENSITY_NORMAL);
    }
}

