/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.aws.ec2.domain.AutoValue_RouteTable;
import org.jclouds.aws.ec2.domain.Route;
import org.jclouds.aws.ec2.domain.RouteTableAssociation;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class RouteTable {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String vpcId();

    @Nullable
    public abstract List<Route> routeSet();

    @Nullable
    public abstract List<RouteTableAssociation> associationSet();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"routeTableId", "vpcId", "routeSet", "associationSet", "tagSet"})
    public static RouteTable create(String id, String vpcId, List<Route> routeSet, List<RouteTableAssociation> associationSet, Map<String, String> tags) {
        return RouteTable.builder().id(id).vpcId(vpcId).routeSet(routeSet).associationSet(associationSet).tags(tags).build();
    }

    RouteTable() {
    }

    public static Builder builder() {
        return new AutoValue_RouteTable.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder vpcId(String var1);

        public abstract Builder routeSet(List<Route> var1);

        public abstract Builder associationSet(List<RouteTableAssociation> var1);

        public abstract Builder tags(Map<String, String> var1);

        @Nullable
        abstract List<Route> routeSet();

        @Nullable
        abstract List<RouteTableAssociation> associationSet();

        @Nullable
        abstract Map<String, String> tags();

        abstract RouteTable autoBuild();

        public RouteTable build() {
            this.routeSet((List<Route>)(this.routeSet() != null ? ImmutableList.copyOf(this.routeSet()) : ImmutableList.of()));
            this.associationSet((List<RouteTableAssociation>)(this.associationSet() != null ? ImmutableList.copyOf(this.associationSet()) : ImmutableList.of()));
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : ImmutableMap.of()));
            return this.autoBuild();
        }
    }
}

