/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.PatchOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PatchOptionsFluent<A extends PatchOptionsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private String fieldManager;
    private String fieldValidation;
    private Boolean force;
    private String kind;
    private Map<String, Object> additionalProperties;

    public PatchOptionsFluent() {
    }

    public PatchOptionsFluent(PatchOptions instance) {
        PatchOptions patchOptions = instance = instance != null ? instance : new PatchOptions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDryRun(instance.getDryRun());
            this.withFieldManager(instance.getFieldManager());
            this.withFieldValidation(instance.getFieldValidation());
            this.withForce(instance.getForce());
            this.withKind(instance.getKind());
            this.withApiVersion(instance.getApiVersion());
            this.withDryRun(instance.getDryRun());
            this.withFieldManager(instance.getFieldManager());
            this.withFieldValidation(instance.getFieldValidation());
            this.withForce(instance.getForce());
            this.withKind(instance.getKind());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    public A removeFromDryRun(String ... items) {
        if (this.dryRun == null) {
            return (A)this;
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            return (A)this;
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    public List<String> getDryRun() {
        return this.dryRun;
    }

    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
            this._visitables.remove("dryRun");
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    public boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    public String getFieldManager() {
        return this.fieldManager;
    }

    public A withFieldManager(String fieldManager) {
        this.fieldManager = fieldManager;
        return (A)this;
    }

    public boolean hasFieldManager() {
        return this.fieldManager != null;
    }

    public String getFieldValidation() {
        return this.fieldValidation;
    }

    public A withFieldValidation(String fieldValidation) {
        this.fieldValidation = fieldValidation;
        return (A)this;
    }

    public boolean hasFieldValidation() {
        return this.fieldValidation != null;
    }

    public Boolean getForce() {
        return this.force;
    }

    public A withForce(Boolean force) {
        this.force = force;
        return (A)this;
    }

    public boolean hasForce() {
        return this.force != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatchOptionsFluent that = (PatchOptionsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.dryRun, that.dryRun)) {
            return false;
        }
        if (!Objects.equals(this.fieldManager, that.fieldManager)) {
            return false;
        }
        if (!Objects.equals(this.fieldValidation, that.fieldValidation)) {
            return false;
        }
        if (!Objects.equals(this.force, that.force)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.fieldManager, this.fieldValidation, this.force, this.kind, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun + ",");
        }
        if (this.fieldManager != null) {
            sb.append("fieldManager:");
            sb.append(this.fieldManager + ",");
        }
        if (this.fieldValidation != null) {
            sb.append("fieldValidation:");
            sb.append(this.fieldValidation + ",");
        }
        if (this.force != null) {
            sb.append("force:");
            sb.append(this.force + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withForce() {
        return this.withForce(true);
    }
}

