/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.guava.Maybe;

public class ThreadLocalStack<T>
implements Iterable<T> {
    private final boolean allowDuplicates;
    final ThreadLocal<Collection<T>> set = new ThreadLocal();

    public ThreadLocalStack(boolean allowsDuplicates) {
        this.allowDuplicates = allowsDuplicates;
    }

    public Collection<T> getAll(boolean forceInitialized) {
        Collection<T> result = this.set.get();
        if (forceInitialized && result == null) {
            result = this.allowDuplicates ? MutableList.of() : MutableSet.of();
            this.set.set(result);
        }
        return result;
    }

    public T pop() {
        Collection<T> resultS = this.getAll(true);
        Object last = Iterables.getLast(resultS);
        resultS.remove(last);
        if (resultS.isEmpty()) {
            this.set.remove();
        }
        return (T)last;
    }

    public boolean push(T object) {
        return this.getAll(true).add(object);
    }

    @Override
    public Iterator<T> iterator() {
        return null;
    }

    public Maybe<T> peek() {
        Collection<T> resultS = this.getAll(false);
        if (resultS == null || resultS.isEmpty()) {
            return Maybe.absent("Nothing in local stack");
        }
        return Maybe.of(Iterables.getLast(resultS));
    }

    public Maybe<T> peekPenultimate() {
        Collection<T> resultS = this.getAll(false);
        if (resultS == null) {
            return Maybe.absent();
        }
        int size = resultS.size();
        if (size <= 1) {
            return Maybe.absent();
        }
        return Maybe.of(Iterables.get(resultS, (int)(size - 2)));
    }

    public void pop(T entry) {
        Maybe<T> popped = this.peek();
        if (popped.isAbsent()) {
            throw new IllegalStateException("Nothing to pop; cannot pop " + entry);
        }
        if (!Objects.equals(entry, popped.get())) {
            throw new IllegalStateException("Stack mismatch, expected to pop " + entry + " but instead would have popped " + popped.get());
        }
        this.pop();
    }

    public int size() {
        Collection<T> v = this.getAll(false);
        if (v == null) {
            return 0;
        }
        return v.size();
    }
}

