/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.Zone;

public class ZonePredicates {
    public static Predicate<Zone> supportsAdvancedNetworks() {
        return new Predicate<Zone>(){

            public boolean apply(Zone zone) {
                return NetworkType.ADVANCED.equals((Object)((Zone)Preconditions.checkNotNull((Object)zone, (Object)"zone")).getNetworkType());
            }

            public String toString() {
                return "supportsAdvancedNetworks()";
            }
        };
    }

    public static Predicate<Zone> supportsSecurityGroups() {
        return new Predicate<Zone>(){

            public boolean apply(Zone input) {
                return input.isSecurityGroupsEnabled();
            }

            public String toString() {
                return "supportsSecurityGroups()";
            }
        };
    }

    public static Predicate<Zone> any() {
        return Predicates.alwaysTrue();
    }
}

