/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.cloudstack.domain.ZoneSecurityGroupNamePortsCidrs;
import org.jclouds.logging.Logger;

public class FindSecurityGroupOrCreate
extends CacheLoader<ZoneAndName, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CloudStackApi client;
    protected final Function<ZoneSecurityGroupNamePortsCidrs, SecurityGroup> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(CloudStackApi client, Function<ZoneSecurityGroupNamePortsCidrs, SecurityGroup> groupCreator) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.groupCreator = (Function)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
    }

    public SecurityGroup load(ZoneAndName in) {
        SecurityGroup group = this.client.getSecurityGroupApi().getSecurityGroupByName(in.getName());
        if (group != null) {
            return group;
        }
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroup createNewSecurityGroup(ZoneAndName in) {
        Preconditions.checkState((boolean)(Preconditions.checkNotNull((Object)in, (Object)"ZoneSecurityGrioupNamePortsCidrs") instanceof ZoneSecurityGroupNamePortsCidrs), (String)"programming error: when issuing get to this cacheloader, you need to pass an instance of ZoneSecurityGroupNamePortsCidrs, not %s", (Object)in);
        ZoneSecurityGroupNamePortsCidrs zoneSecurityGroupNamePortsCidrs = (ZoneSecurityGroupNamePortsCidrs)ZoneSecurityGroupNamePortsCidrs.class.cast(in);
        return (SecurityGroup)this.groupCreator.apply((Object)zoneSecurityGroupNamePortsCidrs);
    }

    public String toString() {
        return "returnExistingSecurityGroupInZoneOrCreateAsNeeded()";
    }
}

