/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.rest.domain.RelationSummary;
import org.apache.brooklyn.rest.domain.RelationType;

public class EntityRelationUtils {
    public static List<RelationSummary> getRelations(Entity entity) {
        ArrayList entityRelations = Lists.newArrayList();
        for (RelationshipType relationship : entity.relations().getRelationshipTypes()) {
            Set relations = entity.relations().getRelations(relationship);
            LinkedHashSet relationIds = Sets.newLinkedHashSet();
            for (Object r : relations) {
                relationIds.add(((BrooklynObject)r).getId());
            }
            RelationType relationType = new RelationType(relationship.getRelationshipTypeName(), relationship.getTargetName(), relationship.getSourceName());
            RelationSummary relationSummary = new RelationSummary(relationType, (Set)relationIds);
            entityRelations.add(relationSummary);
        }
        return entityRelations;
    }
}

