/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.EntityConfigMap;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.EntityConfigApi;
import org.apache.brooklyn.rest.domain.ConfigSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.ConfigTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EntityConfigResource
extends AbstractBrooklynRestResource
implements EntityConfigApi {
    private static final Logger LOG = LoggerFactory.getLogger(EntityConfigResource.class);

    public List<ConfigSummary> list(String application, String entityToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        ArrayList result = Lists.newArrayList();
        for (ConfigKey key : entity.getEntityType().getConfigKeys()) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CONFIG, (Object)new Entitlements.EntityAndItem(entity, (Object)key.getName()))) {
                LOG.trace("User {} not authorized to see config {} of entity {}; excluding from ConfigKey list results", new Object[]{Entitlements.getEntitlementContext().user(), key.getName(), entity});
                continue;
            }
            result.add(ConfigTransformer.of(key).on(entity).includeLinks(this.ui.getBaseUriBuilder(), true, true).transform());
        }
        return result;
    }

    public Map<String, Object> batchConfigRead(String application, String entityToken, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, Boolean raw) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        return (Map)((Task)Entities.submit((Entity)entity, (TaskAdaptable)Tasks.builder().displayName("REST API batch config read").tag((Object)"TRANSIENT").body((Callable)new BatchConfigRead(this.mgmt(), this, entity, useDisplayHints, skipResolution, suppressSecrets, raw)).build())).getUnchecked();
    }

    public Object get(String application, String entityToken, String configKeyName, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, @Deprecated Boolean raw) {
        return this.get(true, application, entityToken, configKeyName, useDisplayHints, skipResolution, suppressSecrets, raw);
    }

    public String getPlain(String application, String entityToken, String configKeyName, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, @Deprecated Boolean raw) {
        return (String)this.get(false, application, entityToken, configKeyName, useDisplayHints, skipResolution, suppressSecrets, raw, true);
    }

    public Object get(boolean preferJson, String application, String entityToken, String configKeyName, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, @Deprecated Boolean raw) {
        return this.get(preferJson, application, entityToken, configKeyName, useDisplayHints, skipResolution, suppressSecrets, raw, false);
    }

    public Object get(boolean preferJson, String application, String entityToken, String configKeyName, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, @Deprecated Boolean raw, boolean plain) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        ConfigKey<?> ck = this.findConfig(entity, configKeyName);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CONFIG, (Object)new Entitlements.EntityAndItem(entity, (Object)ck.getName()))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see entity '%s' config '%s'", Entitlements.getEntitlementContext().user(), entity, ck.getName());
        }
        Object value = ((EntityInternal)entity).config().getRaw(ck).orNull();
        return this.resolving(value).preferJson(preferJson).asJerseyOutermostReturnValue(true).useDisplayHints(useDisplayHints).skipResolution(skipResolution).suppressIfSecret(ck.getName(), suppressSecrets).raw(raw).context(entity).immediately(true).renderAs(ck).resolve();
    }

    private ConfigKey<?> findConfig(Entity entity, String configKeyName) {
        ConfigKey ck = entity.getEntityType().getConfigKey(configKeyName);
        if (ck == null) {
            ck = new BasicConfigKey(Object.class, configKeyName);
        }
        return ck;
    }

    public void setFromMap(String application, String entityToken, Boolean recurse, Map newValues) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("REST user " + Entitlements.getEntitlementContext() + " setting configs " + newValues);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            String configName = Strings.toString(entry.getKey());
            Object newValue = entry.getValue();
            ConfigKey<?> ck = this.findConfig(entity, configName);
            ((EntityInternal)entity).config().set(ck, TypeCoercions.coerce(newValue, (TypeToken)ck.getTypeToken()));
            if (!Boolean.TRUE.equals(recurse)) continue;
            for (Entity e2 : Entities.descendantsWithoutSelf((Entity)entity)) {
                ((EntityInternal)e2).config().set(ck, newValue);
            }
        }
    }

    public void set(String application, String entityToken, String configName, Boolean recurse, Object newValue) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)"set-config", (Object)configName)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to set config '%s' on '%s'", Entitlements.getEntitlementContext().user(), configName, entity);
        }
        ConfigKey<?> ck = this.findConfig(entity, configName);
        if (!ck.isReconfigurable() && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s', required to set non-reconfigurable config", Entitlements.getEntitlementContext().user(), entity);
        }
        LOG.debug("REST setting config " + configName + " on " + entity + " to " + newValue);
        ((EntityInternal)entity).config().set(ck, TypeCoercions.coerce((Object)newValue, (TypeToken)ck.getTypeToken()));
        if (Boolean.TRUE.equals(recurse)) {
            for (Entity e2 : Entities.descendantsWithoutSelf((Entity)entity)) {
                this.set(application, e2.getId(), configName, false, newValue);
            }
        }
    }

    private static class BatchConfigRead
    implements Callable<Map<String, Object>> {
        private final ManagementContext mgmt;
        private final EntityConfigResource resource;
        private final Entity entity;
        private final Boolean useDisplayHints;
        private final Boolean skipResolution;
        private final Boolean suppressSecrets;
        private final Boolean raw;

        public BatchConfigRead(ManagementContext mgmt, EntityConfigResource resource, Entity entity, Boolean useDisplayHints, Boolean skipResolution, Boolean suppressSecrets, @Deprecated Boolean raw) {
            this.mgmt = mgmt;
            this.resource = resource;
            this.entity = entity;
            this.useDisplayHints = useDisplayHints;
            this.skipResolution = skipResolution;
            this.suppressSecrets = suppressSecrets;
            this.raw = raw;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            Map source = ((EntityConfigMap)((EntityInternal)this.entity).config().getInternalConfigMap()).getAllConfigInheritedRawValuesIgnoringErrors();
            LinkedHashMap result = Maps.newLinkedHashMap();
            for (Map.Entry ek : source.entrySet()) {
                ConfigKey key = (ConfigKey)ek.getKey();
                Object value = ek.getValue();
                if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CONFIG, (Object)new Entitlements.EntityAndItem(this.entity, (Object)((ConfigKey)ek.getKey()).getName()))) {
                    LOG.trace("User {} not authorized to see sensor {} of entity {}; excluding from current-state results", new Object[]{Entitlements.getEntitlementContext().user(), ((ConfigKey)ek.getKey()).getName(), this.entity});
                    continue;
                }
                result.put(key.getName(), this.resource.resolving(value, this.mgmt).preferJson(true).asJerseyOutermostReturnValue(false).useDisplayHints(this.useDisplayHints).skipResolution(this.skipResolution).suppressIfSecret(key.getName(), this.suppressSecrets).raw(this.raw).context(this.entity).immediately(true).timeout(Duration.millis((Number)500)).renderAs(key).resolve());
            }
            return result;
        }
    }
}

