/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.text.Strings;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CorsImplSupplierFilter
extends CrossOriginResourceSharingFilter {
    public static final ConfigKey<List<String>> ALLOW_ORIGINS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"allowOrigins", (String)"List of allowed origins. Access-Control-Allow-Origin header will be returned to client if Origin header in request is matching exactly a value among the list allowed origins. If AllowedOrigins is empty or not specified then all origins are allowed. No wildcard allowed origins are supported.", Collections.emptyList());
    public static final ConfigKey<List<String>> ALLOW_HEADERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"allowHeaders", (String)"List of allowed headers for preflight checks.", Collections.emptyList());
    public static final ConfigKey<Boolean> ALLOW_CREDENTIALS = ConfigKeys.newBooleanConfigKey((String)"allowCredentials", (String)"The value for the Access-Control-Allow-Credentials header. If false, no header is added. If true, the\n     * header is added with the value 'true'. False by default.", (Boolean)false);
    public static final ConfigKey<List<String>> EXPOSE_HEADERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"exposeHeaders", (String)"A list of non-simple headers to be exposed via Access-Control-Expose-Headers.", Collections.emptyList());
    public static final ConfigKey<Integer> MAX_AGE = ConfigKeys.newIntegerConfigKey((String)"maxAge", (String)"The value for Access-Control-Max-Age.", null);
    public static final ConfigKey<Integer> PREFLIGHT_FAIL_STATUS = ConfigKeys.newIntegerConfigKey((String)"preflightFailStatus", (String)"Preflight error response status, default is 200.", (Integer)200);
    public static final ConfigKey<Boolean> BLOCK_CORS_IF_UNAUTHORIZED = ConfigKeys.newBooleanConfigKey((String)"blockCorsIfUnauthorized", (String)"Do not apply CORS if response is going to be with UNAUTHORIZED status.", (Boolean)false);
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsImplSupplierFilter.class);
    private boolean enableCors = false;

    public CorsImplSupplierFilter() {
    }

    @VisibleForTesting
    public CorsImplSupplierFilter(@Nullable ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"ManagementContext should be suppplied to CORS filter.");
        this.setEnableCors(BrooklynFeatureEnablement.isEnabled((String)"brooklyn.experimental.feature.corsCxfFeature"));
        BrooklynProperties corsProperties = ConfigUtils.filterForPrefixAndStrip((Map)mgmt.getConfig().submap(ConfigPredicates.nameStartsWith((String)"brooklyn.experimental.feature.corsCxfFeature.")).asMapWithStringKeys(), (String)"brooklyn.experimental.feature.corsCxfFeature.");
        this.setAllowOrigins((List)corsProperties.getConfig(ALLOW_ORIGINS));
        this.setAllowHeaders((List)corsProperties.getConfig(ALLOW_HEADERS));
        this.setAllowCredentials((Boolean)corsProperties.getConfig(ALLOW_CREDENTIALS));
        this.setExposeHeaders((List)corsProperties.getConfig(EXPOSE_HEADERS));
        this.setMaxAge((Integer)corsProperties.getConfig(MAX_AGE));
        this.setPreflightErrorStatus((Integer)corsProperties.getConfig(PREFLIGHT_FAIL_STATUS));
        this.setBlockCorsIfUnauthorized((Boolean)corsProperties.getConfig(BLOCK_CORS_IF_UNAUTHORIZED));
    }

    public void setEnableCors(boolean enabled) {
        this.enableCors = Boolean.TRUE.equals(enabled);
        this.setFindResourceMethod(false);
        if (this.enableCors) {
            LOGGER.debug("CORS brooklyn feature enabled.");
        } else {
            LOGGER.trace("CORS brooklyn feature disabled.");
        }
    }

    public void setMaxAge(Integer maxAge) {
        if (Integer.valueOf(-1).equals(maxAge)) {
            super.setMaxAge(null);
        } else {
            super.setMaxAge(maxAge);
        }
    }

    public boolean isEnableCors() {
        return this.enableCors;
    }

    public void setAllowOrigins(String allowedOrigins) {
        this.setAllowOrigins(Strings.parseCsv((String)allowedOrigins));
    }

    public void setAllowHeaders(String allowHeaders) {
        this.setAllowHeaders(Strings.parseCsv((String)allowHeaders));
    }

    public void setExposeHeaders(String exposeHeaders) {
        this.setExposeHeaders(Strings.parseCsv((String)exposeHeaders));
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.enableCors) {
            super.filter(requestContext);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.enableCors) {
            super.filter(requestContext, responseContext);
        }
    }
}

