/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Zone;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/zones")
@Consumes(value={"application/json"})
public interface ZoneApi {
    @Named(value="Zones:get")
    @GET
    @Path(value="/{zone}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Zone get(@PathParam(value="zone") String var1);

    @Named(value="Zones:list")
    @GET
    public ListPage<Zone> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Zones:list")
    @GET
    @Transform(value=ZonePages.class)
    public Iterator<ListPage<Zone>> list();

    @Named(value="Zones:list")
    @GET
    @Transform(value=ZonePages.class)
    public Iterator<ListPage<Zone>> list(ListOptions var1);

    public static final class ZonePages
    extends BaseToIteratorOfListPage<Zone, ZonePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        ZonePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Zone>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Zone>>(){

                public ListPage<Zone> apply(String pageToken) {
                    return api.zones().listPage(pageToken, options);
                }
            };
        }
    }
}

