/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.AutoValue_NewInstance;
import org.jclouds.googlecomputeengine.domain.AutoValue_NewInstance_NetworkInterface;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Tags;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NewInstance {
    public abstract String name();

    public abstract URI machineType();

    @Nullable
    public abstract Boolean canIpForward();

    public abstract List<NetworkInterface> networkInterfaces();

    public abstract List<AttachDisk> disks();

    @Nullable
    public abstract String description();

    public abstract Tags tags();

    public abstract Metadata metadata();

    @Nullable
    public abstract List<Instance.ServiceAccount> serviceAccounts();

    @Nullable
    public abstract Instance.Scheduling scheduling();

    public static NewInstance create(String name, URI machineType, URI network, URI subnetwork, URI sourceImage) {
        return NewInstance.create(name, machineType, network, subnetwork, Arrays.asList(AttachDisk.newBootDisk(sourceImage)), null, null);
    }

    public static NewInstance create(String name, URI machineType, URI network, @Nullable URI subnetwork, List<AttachDisk> disks, @Nullable String description, @Nullable Tags tags) {
        Preconditions.checkArgument((boolean)disks.get(0).boot(), (String)"disk 0 must be a boot disk! %s", disks);
        boolean foundBoot = false;
        for (AttachDisk disk : disks) {
            if (!disk.boot()) continue;
            Preconditions.checkArgument((!foundBoot ? 1 : 0) != 0, (String)"There must be only one boot disk! %s", disks);
            foundBoot = true;
        }
        return NewInstance.create(name, machineType, null, (List<NetworkInterface>)ImmutableList.of((Object)NetworkInterface.create(network, subnetwork)), (List<AttachDisk>)ImmutableList.copyOf(disks), description, tags != null ? tags : Tags.create(), Metadata.create(), null, null);
    }

    @SerializedNames(value={"name", "machineType", "canIpForward", "networkInterfaces", "disks", "description", "tags", "metadata", "serviceAccounts", "scheduling"})
    static NewInstance create(String name, URI machineType, Boolean canIpForward, List<NetworkInterface> networkInterfaces, List<AttachDisk> disks, String description, Tags tags, Metadata metadata, List<Instance.ServiceAccount> serviceAccounts, Instance.Scheduling scheduling) {
        return new AutoValue_NewInstance(name, machineType, canIpForward, networkInterfaces, disks, description, tags, metadata, serviceAccounts, scheduling);
    }

    NewInstance() {
    }

    public static class Builder {
        private String name;
        private URI machineType;
        private Boolean canIpForward;
        private List<NetworkInterface> networkInterfaces;
        private List<AttachDisk> disks;
        private String description;
        private Tags tags;
        private Metadata metadata;
        private List<Instance.ServiceAccount> serviceAccounts;
        private Instance.Scheduling scheduling;

        public Builder(String name, URI machineType, URI network, URI subnetwork, List<AttachDisk> disks) {
            Preconditions.checkNotNull((Object)name, (Object)"NewInstance name cannot be null");
            this.name = name;
            this.machineType = machineType;
            this.networkInterfaces = ImmutableList.of((Object)NetworkInterface.create(network, subnetwork));
            this.disks = disks;
        }

        public Builder(String name, URI machineType, List<NetworkInterface> networks, List<AttachDisk> disks) {
            Preconditions.checkNotNull((Object)name, (Object)"NewInstance name cannot be null");
            this.name = name;
            this.machineType = machineType;
            this.networkInterfaces = ImmutableList.copyOf(networks);
            this.disks = disks;
        }

        public Builder(String name, URI machineType, URI network, URI subnetwork, URI sourceImage) {
            Preconditions.checkNotNull((Object)name, (Object)"NewInstance name cannot be null");
            this.name = name;
            this.machineType = machineType;
            this.networkInterfaces = ImmutableList.of((Object)NetworkInterface.create(network, subnetwork));
            this.disks = Arrays.asList(AttachDisk.newBootDisk(sourceImage));
        }

        public Builder canIpForward(Boolean canIpForward) {
            this.canIpForward = canIpForward;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder serviceAccounts(List<Instance.ServiceAccount> serviceAccounts) {
            this.serviceAccounts = serviceAccounts;
            return this;
        }

        public Builder scheduling(Instance.Scheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public NewInstance build() {
            return NewInstance.create(this.name, this.machineType, this.canIpForward, this.networkInterfaces, this.disks, this.description, this.tags != null ? this.tags : Tags.create(), this.metadata != null ? this.metadata : Metadata.create(), this.serviceAccounts, this.scheduling);
        }
    }

    public static abstract class NetworkInterface {
        abstract URI network();

        @Nullable
        abstract URI subnetwork();

        abstract List<Instance.NetworkInterface.AccessConfig> accessConfigs();

        public static NetworkInterface create(URI network, URI subnetwork) {
            return NetworkInterface.create(network, subnetwork, Arrays.asList(Instance.NetworkInterface.AccessConfig.create(null, Instance.NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT, null)));
        }

        @SerializedNames(value={"network", "subnetwork", "accessConfigs"})
        public static NetworkInterface create(URI network, URI subnetwork, List<Instance.NetworkInterface.AccessConfig> accessConfigs) {
            return new AutoValue_NewInstance_NetworkInterface(network, subnetwork, accessConfigs);
        }

        NetworkInterface() {
        }
    }
}

