/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Optional;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocationConfig;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KubernetesCerts {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCerts.class);
    public final Optional<String> caCertData;
    public final Optional<String> clientCertData;
    public final Optional<String> clientKeyData;
    public final Optional<String> clientKeyAlgo;
    public final Optional<String> clientKeyPassphrase;

    public KubernetesCerts(ConfigBag config) {
        this.caCertData = this.getData(KubernetesLocationConfig.CA_CERT_DATA, KubernetesLocationConfig.CA_CERT_FILE, config);
        this.clientCertData = this.getData(KubernetesLocationConfig.CLIENT_CERT_DATA, KubernetesLocationConfig.CLIENT_CERT_FILE, config);
        this.clientKeyData = this.getData(KubernetesLocationConfig.CLIENT_KEY_DATA, KubernetesLocationConfig.CLIENT_KEY_FILE, config);
        this.clientKeyAlgo = this.getNonBlankOptional(KubernetesLocationConfig.CLIENT_KEY_ALGO, config);
        this.clientKeyPassphrase = this.getNonBlankOptional(KubernetesLocationConfig.CLIENT_KEY_PASSPHRASE, config);
    }

    protected Optional<String> getData(ConfigKey<String> dataKey, ConfigKey<String> fileKey, ConfigBag config) {
        String fileData;
        String data = Strings.isNonBlank((CharSequence)((CharSequence)config.get(dataKey))) ? ((String)config.get(dataKey)).trim() : null;
        String file = (String)config.get(fileKey);
        String string = fileData = Strings.isNonBlank((CharSequence)file) ? this.getFileContents(file).trim() : null;
        if (Strings.isNonBlank((CharSequence)data) && Strings.isNonBlank((CharSequence)fileData)) {
            if (data.equals(fileData)) {
                LOG.warn("Duplicate (matching) configuration for {} and {} (continuing)", (Object)dataKey.getName(), (Object)fileKey.getName());
            } else {
                throw new IllegalStateException("Duplicate conflicting configuration for " + dataKey.getName() + " and " + fileKey.getName());
            }
        }
        String result = Strings.isNonBlank((CharSequence)data) ? data : (Strings.isNonBlank((CharSequence)fileData) ? fileData : null);
        return Optional.fromNullable((Object)result);
    }

    protected Optional<String> getNonBlankOptional(ConfigKey<? extends String> key, ConfigBag config) {
        String result = (String)config.get(key);
        return Optional.fromNullable((Object)(Strings.isNonBlank((CharSequence)result) ? result : null));
    }

    protected String getFileContents(String file) {
        return ResourceUtils.create((Object)this).getResourceAsString(file);
    }
}

