/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRefBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRefFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCRouteRuleFluent<A extends GRPCRouteRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GRPCBackendRefBuilder> backendRefs = new ArrayList();
    private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList();
    private ArrayList<GRPCRouteMatchBuilder> matches = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GRPCRouteRuleFluent() {
    }

    public GRPCRouteRuleFluent(GRPCRouteRule instance) {
        GRPCRouteRule gRPCRouteRule = instance = instance != null ? instance : new GRPCRouteRule();
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withFilters(instance.getFilters());
            this.withMatches(instance.getMatches());
            this.withBackendRefs(instance.getBackendRefs());
            this.withFilters(instance.getFilters());
            this.withMatches(instance.getMatches());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBackendRefs(int index, GRPCBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").add(index, builder);
            this.backendRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBackendRefs(int index, GRPCBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").set(index, builder);
            this.backendRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBackendRefs(GRPCBackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (GRPCBackendRef item : items) {
            GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBackendRefs(Collection<GRPCBackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (GRPCBackendRef item : items) {
            GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBackendRefs(GRPCBackendRef ... items) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        for (GRPCBackendRef item : items) {
            GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove((Object)builder);
            this.backendRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBackendRefs(Collection<GRPCBackendRef> items) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        for (GRPCBackendRef item : items) {
            GRPCBackendRefBuilder builder = new GRPCBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove((Object)builder);
            this.backendRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBackendRefs(Predicate<GRPCBackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)((Object)this);
        }
        Iterator<GRPCBackendRefBuilder> each = this.backendRefs.iterator();
        List visitables = this._visitables.get((Object)"backendRefs");
        while (each.hasNext()) {
            GRPCBackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GRPCBackendRef> buildBackendRefs() {
        return this.backendRefs != null ? GRPCRouteRuleFluent.build(this.backendRefs) : null;
    }

    public GRPCBackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    public GRPCBackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    public GRPCBackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    public GRPCBackendRef buildMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
        for (GRPCBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
        for (GRPCBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBackendRefs(List<GRPCBackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get((Object)"backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (GRPCBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)((Object)this);
    }

    public A withBackendRefs(GRPCBackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove((Object)"backendRefs");
        }
        if (backendRefs != null) {
            for (GRPCBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    public BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNested(-1, null);
    }

    public BackendRefsNested<A> addNewBackendRefLike(GRPCBackendRef item) {
        return new BackendRefsNested(-1, item);
    }

    public BackendRefsNested<A> setNewBackendRefLike(int index, GRPCBackendRef item) {
        return new BackendRefsNested(index, item);
    }

    public BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    public BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editMatchingBackendRef(Predicate<GRPCBackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching backendRefs. No match found.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public A addToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        Iterator<GRPCRouteFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            GRPCRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GRPCRouteFilter> buildFilters() {
        return this.filters != null ? GRPCRouteRuleFluent.build(this.filters) : null;
    }

    public GRPCRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public GRPCRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public GRPCRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<GRPCRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(GRPCRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, GRPCRouteFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public A addToMatches(int index, GRPCRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get((Object)"matches").add(index, builder);
            this.matches.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatches(int index, GRPCRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get((Object)"matches").set(index, builder);
            this.matches.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatches(GRPCRouteMatch ... items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (GRPCRouteMatch item : items) {
            GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatches(Collection<GRPCRouteMatch> items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (GRPCRouteMatch item : items) {
            GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatches(GRPCRouteMatch ... items) {
        if (this.matches == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteMatch item : items) {
            GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").remove((Object)builder);
            this.matches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatches(Collection<GRPCRouteMatch> items) {
        if (this.matches == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteMatch item : items) {
            GRPCRouteMatchBuilder builder = new GRPCRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").remove((Object)builder);
            this.matches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatches(Predicate<GRPCRouteMatchBuilder> predicate) {
        if (this.matches == null) {
            return (A)((Object)this);
        }
        Iterator<GRPCRouteMatchBuilder> each = this.matches.iterator();
        List visitables = this._visitables.get((Object)"matches");
        while (each.hasNext()) {
            GRPCRouteMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GRPCRouteMatch> buildMatches() {
        return this.matches != null ? GRPCRouteRuleFluent.build(this.matches) : null;
    }

    public GRPCRouteMatch buildMatch(int index) {
        return this.matches.get(index).build();
    }

    public GRPCRouteMatch buildFirstMatch() {
        return this.matches.get(0).build();
    }

    public GRPCRouteMatch buildLastMatch() {
        return this.matches.get(this.matches.size() - 1).build();
    }

    public GRPCRouteMatch buildMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
        for (GRPCRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
        for (GRPCRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatches(List<GRPCRouteMatch> matches) {
        if (this.matches != null) {
            this._visitables.get((Object)"matches").clear();
        }
        if (matches != null) {
            this.matches = new ArrayList();
            for (GRPCRouteMatch item : matches) {
                this.addToMatches(item);
            }
        } else {
            this.matches = null;
        }
        return (A)((Object)this);
    }

    public A withMatches(GRPCRouteMatch ... matches) {
        if (this.matches != null) {
            this.matches.clear();
            this._visitables.remove((Object)"matches");
        }
        if (matches != null) {
            for (GRPCRouteMatch item : matches) {
                this.addToMatches(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatches() {
        return this.matches != null && !this.matches.isEmpty();
    }

    public MatchesNested<A> addNewMatch() {
        return new MatchesNested(-1, null);
    }

    public MatchesNested<A> addNewMatchLike(GRPCRouteMatch item) {
        return new MatchesNested(-1, item);
    }

    public MatchesNested<A> setNewMatchLike(int index, GRPCRouteMatch item) {
        return new MatchesNested(index, item);
    }

    public MatchesNested<A> editMatch(int index) {
        if (this.matches.size() <= index) {
            throw new RuntimeException("Can't edit matches. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchesNested<A> editFirstMatch() {
        if (this.matches.size() == 0) {
            throw new RuntimeException("Can't edit first matches. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchesNested<A> editLastMatch() {
        int index = this.matches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matches. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchesNested<A> editMatchingMatch(Predicate<GRPCRouteMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matches.size(); ++i) {
            if (!predicate.test(this.matches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matches. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCRouteRuleFluent that = (GRPCRouteRuleFluent)((Object)o);
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.matches, that.matches)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.backendRefs, this.filters, this.matches, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null && !this.backendRefs.isEmpty()) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.matches != null && !this.matches.isEmpty()) {
            sb.append("matches:");
            sb.append(this.matches + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchesNested<N>
    extends GRPCRouteMatchFluent<MatchesNested<N>>
    implements Nested<N> {
        GRPCRouteMatchBuilder builder;
        int index;

        MatchesNested(int index, GRPCRouteMatch item) {
            this.index = index;
            this.builder = new GRPCRouteMatchBuilder(this, item);
        }

        public N and() {
            return (N)GRPCRouteRuleFluent.this.setToMatches(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }

    public class FiltersNested<N>
    extends GRPCRouteFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        GRPCRouteFilterBuilder builder;
        int index;

        FiltersNested(int index, GRPCRouteFilter item) {
            this.index = index;
            this.builder = new GRPCRouteFilterBuilder(this, item);
        }

        public N and() {
            return (N)GRPCRouteRuleFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }

    public class BackendRefsNested<N>
    extends GRPCBackendRefFluent<BackendRefsNested<N>>
    implements Nested<N> {
        GRPCBackendRefBuilder builder;
        int index;

        BackendRefsNested(int index, GRPCBackendRef item) {
            this.index = index;
            this.builder = new GRPCBackendRefBuilder(this, item);
        }

        public N and() {
            return (N)GRPCRouteRuleFluent.this.setToBackendRefs(this.index, this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

