/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.ntlm;

import io.cloudsoft.winrm4j.client.encryption.AsyncHttpEncryptionAwareConduit;
import io.cloudsoft.winrm4j.client.encryption.WinrmEncryptionUtils;
import io.cloudsoft.winrm4j.client.ntlm.NtlmKeys;
import io.cloudsoft.winrm4j.client.ntlm.forks.httpclient.NTLMEngineImpl;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.auth.NTCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTCredentialsWithEncryption
extends NTCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(NTCredentialsWithEncryption.class);
    boolean isAuthenticated = false;
    long negotiateFlags;
    byte[] clientSigningKey;
    byte[] serverSigningKey;
    byte[] clientSealingKey;
    byte[] serverSealingKey;
    AtomicLong sequenceNumberIncoming = new AtomicLong(-1L);
    AtomicLong sequenceNumberOutgoing = new AtomicLong(-1L);
    Cipher encryptor = null;
    Cipher decryptor = null;

    public NTCredentialsWithEncryption(String userName, String password, String workstation, String domain) {
        super(userName, password, workstation, domain);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public void setClientSigningKey(byte[] clientSigningKey) {
        this.clientSigningKey = clientSigningKey;
    }

    public void setServerSigningKey(byte[] serverSigningKey) {
        this.serverSigningKey = serverSigningKey;
    }

    public byte[] getClientSigningKey() {
        return this.clientSigningKey;
    }

    public byte[] getServerSigningKey() {
        return this.serverSigningKey;
    }

    public void setClientSealingKey(byte[] clientSealingKey) {
        this.clientSealingKey = clientSealingKey;
    }

    public void setServerSealingKey(byte[] serverSealingKey) {
        this.serverSealingKey = serverSealingKey;
    }

    public byte[] getClientSealingKey() {
        return this.clientSealingKey;
    }

    public byte[] getServerSealingKey() {
        return this.serverSealingKey;
    }

    public long getNegotiateFlags() {
        return this.negotiateFlags;
    }

    public boolean hasNegotiateFlag(long flag) {
        return (this.getNegotiateFlags() & flag) == flag;
    }

    public void setNegotiateFlags(long negotiateFlags) {
        this.negotiateFlags = negotiateFlags;
    }

    public AtomicLong getSequenceNumberIncoming() {
        return this.sequenceNumberIncoming;
    }

    public AtomicLong getSequenceNumberOutgoing() {
        return this.sequenceNumberOutgoing;
    }

    public Cipher getStatefulEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = WinrmEncryptionUtils.arc4(this.getClientSealingKey());
        }
        return this.encryptor;
    }

    public Cipher getStatefulDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = WinrmEncryptionUtils.arc4(this.getServerSealingKey());
        }
        return this.decryptor;
    }

    public void resetEncryption(String response, HttpRequest request) {
        if (this.isAuthenticated()) {
            LOG.debug("Resetting encryption for {}", (Object)request);
        } else {
            LOG.trace("Resetting encryption for {}", (Object)request);
        }
        this.setIsAuthenticated(false);
        this.clientSealingKey = null;
        this.clientSigningKey = null;
        this.serverSealingKey = null;
        this.serverSigningKey = null;
        this.encryptor = null;
        this.decryptor = null;
        this.sequenceNumberIncoming.set(-1L);
        this.sequenceNumberOutgoing.set(-1L);
        if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() instanceof AsyncHttpEncryptionAwareConduit.EncryptionAwareHttpEntity) {
            ((AsyncHttpEncryptionAwareConduit.EncryptionAwareHttpEntity)((HttpEntityEnclosingRequest)request).getEntity()).refreshHeaders((HttpEntityEnclosingRequest)request);
        }
    }

    public void initEncryption(NTLMEngineImpl.Type3Message signAndSealData, HttpRequest request) {
        LOG.debug("Initializing encryption for {}", (Object)request);
        this.setIsAuthenticated(true);
        if (signAndSealData != null && signAndSealData.getExportedSessionKey() != null) {
            new NtlmKeys(signAndSealData).apply(this);
        }
        if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() instanceof AsyncHttpEncryptionAwareConduit.EncryptionAwareHttpEntity) {
            ((AsyncHttpEncryptionAwareConduit.EncryptionAwareHttpEntity)((HttpEntityEnclosingRequest)request).getEntity()).refreshHeaders((HttpEntityEnclosingRequest)request);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + super.toString() + "{auth=" + this.isAuthenticated() + "}";
    }
}

