/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.WinRmClientBuilder;
import io.cloudsoft.winrm4j.client.WinRmService;
import io.cloudsoft.winrm4j.client.encryption.AsyncHttpEncryptionAwareConduitFactory;
import io.cloudsoft.winrm4j.client.encryption.DecryptAndVerifyInInterceptor;
import io.cloudsoft.winrm4j.client.encryption.SignAndEncryptOutInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.xml.ws.Service;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)WinRmClient.class.getName());

    public static WinRm newInstance(Bus bus) {
        return WinRmFactory.newInstance(bus, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WinRm newInstance(Bus bus, WinRmClientBuilder builder) {
        Bus prevBus = BusFactory.getAndSetThreadDefaultBus((Bus)bus);
        try {
            WinRm winRm = WinRmFactory.createService(bus, builder);
            return winRm;
        }
        finally {
            if (BusFactory.getThreadDefaultBus((boolean)false) != prevBus) {
                BusFactory.setThreadDefaultBus((Bus)prevBus);
            }
        }
    }

    private static WinRm createService(Bus bus, WinRmClientBuilder builder) {
        RuntimeException lastException = null;
        try {
            return WinRmFactory.doCreateServiceWithBean(bus, builder);
        }
        catch (RuntimeException e) {
            LOG.warn("Error creating WinRm service with mbean strategy (trying other strategies): " + e, (Throwable)e);
            lastException = e;
            if (builder.payloadEncryptionMode().isRequired()) {
                throw new IllegalStateException("MBean strategy must work to enable encryption, and failed with: " + e, e);
            }
            try {
                return WinRmFactory.doCreateServiceWithReflectivelySetDelegate();
            }
            catch (RuntimeException e2) {
                LOG.warn("Error creating WinRm service with reflective delegate (trying other strategies): " + e2, (Throwable)e2);
                lastException = e2;
                try {
                    return WinRmFactory.doCreateServiceNormal();
                }
                catch (RuntimeException e3) {
                    LOG.warn("Error creating WinRm service with many strategies (giving up): " + e3, (Throwable)e3);
                    lastException = e3;
                    throw lastException;
                }
            }
        }
    }

    private static WinRm doCreateServiceNormal() {
        WinRmService service = WinRmFactory.doCreateService_1_CreateMinimalServiceInstance();
        return WinRmFactory.doCreateService_2_GetClient(service);
    }

    private static WinRm doCreateServiceWithReflectivelySetDelegate() {
        WinRmService service = WinRmFactory.doCreateService_1_CreateMinimalServiceInstance();
        try {
            Field delegateField = Service.class.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            ServiceDelegate previousDelegate = (ServiceDelegate)delegateField.get((Object)service);
            if (!previousDelegate.getClass().getName().contains("cxf")) {
                ServiceDelegate serviceDelegate = ((Provider)Class.forName("org.apache.cxf.jaxws.spi.ProviderImpl").newInstance()).createServiceDelegate(WinRmService.WSDL_LOCATION, WinRmService.SERVICE, ((Object)((Object)service)).getClass());
                delegateField.set((Object)service, serviceDelegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reflectively setting CXF WS service delegate", e);
        }
        return WinRmFactory.doCreateService_2_GetClient(service);
    }

    private static WinRm doCreateServiceWithBean(Bus bus, WinRmClientBuilder builder) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getClientFactoryBean().getServiceFactory().setWsdlURL(WinRmService.WSDL_LOCATION);
        factory.setServiceName(WinRmService.SERVICE);
        factory.setEndpointName(WinRmService.WinRmPort);
        factory.setBus(bus);
        if (builder != null) {
            LinkedHashMap properties = new LinkedHashMap();
            ArrayList<SignAndEncryptOutInterceptor> outInterceptors = new ArrayList<SignAndEncryptOutInterceptor>();
            ArrayList<DecryptAndVerifyInInterceptor> inInterceptors = new ArrayList<DecryptAndVerifyInInterceptor>();
            if (builder.payloadEncryptionMode().isPermitted()) {
                outInterceptors.add(new SignAndEncryptOutInterceptor(builder.payloadEncryptionMode()));
                inInterceptors.add(new DecryptAndVerifyInInterceptor(builder.payloadEncryptionMode()));
                builder.endpointConduitFactory = new AsyncHttpEncryptionAwareConduitFactory(builder.payloadEncryptionMode(), builder.targetAuthSchemes(), null);
            }
            factory.setInInterceptors(inInterceptors);
            factory.setOutInterceptors(outInterceptors);
            factory.setProperties(properties);
        }
        return (WinRm)factory.create(WinRm.class);
    }

    private static WinRmService doCreateService_1_CreateMinimalServiceInstance() {
        return new WinRmService();
    }

    private static WinRm doCreateService_2_GetClient(WinRmService service) {
        return service.getWinRmPort();
    }
}

