/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.test.framework.BaseTest;
import org.apache.brooklyn.test.framework.RelativeEntityTestCase;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativeEntityTestCaseImpl
extends TargetableTestComponentImpl
implements RelativeEntityTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(RelativeEntityTestCaseImpl.class);

    @Override
    public Entity resolveTarget() {
        Entity anchor = (Entity)this.config().get((ConfigKey.HasConfigKey)ANCHOR);
        if (anchor == null) {
            Maybe<Entity> resolvedTarget = this.tryResolveTarget();
            if (resolvedTarget.isPresent()) {
                anchor = (Entity)resolvedTarget.get();
            } else {
                throw new IllegalArgumentException("No anchor entity found for " + this);
            }
        }
        this.sensors().set((AttributeSensor)ANCHOR, (Object)anchor);
        Maybe component = this.config().getRaw(COMPONENT);
        if (component.isAbsentOrNull()) {
            throw new IllegalArgumentException("No component found for " + this);
        }
        if (!(component.get() instanceof DslComponent)) {
            throw new IllegalArgumentException("Expected DslComponent value for component, found " + component.get());
        }
        DslComponent finder = (DslComponent)DslComponent.class.cast(component.get());
        Task task = (Task)Entities.submit((Entity)anchor, (TaskFactory)finder);
        return (Entity)task.getUnchecked();
    }

    public void start(Collection<? extends Location> locations) {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STARTING);
        Entity target = this.resolveTarget();
        if (target == null) {
            LOG.debug("Tasks NOT successfully run. RelativeEntityTestCaseImpl target unset");
            this.setServiceState(false, Lifecycle.ON_FIRE);
            return;
        }
        this.config().set((ConfigKey.HasConfigKey)BaseTest.TARGET_ENTITY, (Object)target);
        boolean success = true;
        try {
            for (Entity child : this.getChildren()) {
                if (child instanceof Startable) {
                    Startable test = (Startable)Startable.class.cast(child);
                    test.start(locations);
                    if (Lifecycle.RUNNING.equals(child.sensors().get(Attributes.SERVICE_STATE_ACTUAL))) {
                        LOG.debug("Task of {} successfully run, targeting {}", (Object)this, (Object)target);
                    } else {
                        LOG.warn("Problem in child test-case of {}, targeting {}", (Object)this, (Object)target);
                        success = false;
                    }
                } else {
                    LOG.info("Ignored child of {} that is not Startable: {}", (Object)this, (Object)child);
                }
                if (success) continue;
                break;
            }
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            LOG.warn("Problem in child test-case of " + this + ", targeting " + target, t);
            success = false;
        }
        if (success) {
            LOG.debug("Tasks successfully run. Update state of {} to RUNNING.", (Object)this);
            this.setServiceState(true, Lifecycle.RUNNING);
        } else {
            LOG.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setServiceState(false, Lifecycle.ON_FIRE);
        }
    }

    public void stop() {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STOPPING);
        try {
            for (Entity child : this.getChildren()) {
                if (!(child instanceof Startable)) continue;
                ((Startable)child).stop();
            }
            LOG.debug("Tasks successfully run. Update state of {} to STOPPED.", (Object)this);
            this.setServiceState(false, Lifecycle.STOPPED);
        }
        catch (Throwable t) {
            LOG.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setServiceState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    private void setServiceState(boolean serviceUpState, Lifecycle serviceStateActual) {
        this.sensors().set(SERVICE_UP, (Object)serviceUpState);
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)serviceStateActual);
    }
}

