/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.entity.nosql.cassandra.TokenGenerator;
import org.apache.brooklyn.util.collections.MutableList;

@Deprecated
public class TokenGenerators {

    public static class NonNeg127TokenGenerator
    extends AbstractTokenGenerator {
        private static final long serialVersionUID = 1357426905711548198L;
        public static final BigInteger MIN_TOKEN = BigInteger.ZERO;
        public static final BigInteger MAX_TOKEN = TWO.pow(127).subtract(BigInteger.ONE);
        public static final BigInteger RANGE = TWO.pow(127);

        public NonNeg127TokenGenerator() {
            this.checkRangeValid();
        }

        @Override
        public BigInteger max() {
            return MAX_TOKEN;
        }

        @Override
        public BigInteger min() {
            return MIN_TOKEN;
        }

        @Override
        public BigInteger range() {
            return RANGE;
        }
    }

    public static class PosNeg63TokenGenerator
    extends AbstractTokenGenerator {
        private static final long serialVersionUID = 7327403957176106754L;
        public static final BigInteger MIN_TOKEN = TWO.pow(63).negate();
        public static final BigInteger MAX_TOKEN = TWO.pow(63).subtract(BigInteger.ONE);
        public static final BigInteger RANGE = TWO.pow(64);

        public PosNeg63TokenGenerator() {
            this.checkRangeValid();
        }

        @Override
        public BigInteger max() {
            return MAX_TOKEN;
        }

        @Override
        public BigInteger min() {
            return MIN_TOKEN;
        }

        @Override
        public BigInteger range() {
            return RANGE;
        }
    }

    public static abstract class AbstractTokenGenerator
    implements TokenGenerator,
    Serializable {
        private static final long serialVersionUID = -1884526356161711176L;
        public static final BigInteger TWO = BigInteger.valueOf(2L);
        private final Set<BigInteger> currentTokens = Sets.newTreeSet();
        private final List<BigInteger> nextTokens = Lists.newArrayList();
        private BigInteger origin = BigInteger.ZERO;

        @Override
        public abstract BigInteger max();

        @Override
        public abstract BigInteger min();

        @Override
        public abstract BigInteger range();

        protected void checkRangeValid() {
            Preconditions.checkState((boolean)this.range().equals(this.max().subtract(this.min()).add(BigInteger.ONE)), (String)"min=%s; max=%s; range=%s", (Object)this.min(), (Object)this.max(), (Object)this.range());
        }

        @Override
        public void setOrigin(BigInteger shift) {
            this.origin = (BigInteger)Preconditions.checkNotNull((Object)shift, (Object)"shift");
        }

        @Override
        public synchronized BigInteger newToken() {
            BigInteger result;
            BigInteger bigInteger = result = this.nextTokens.isEmpty() ? null : this.nextTokens.remove(0);
            if (result != null) {
                this.currentTokens.add(result);
            }
            return result;
        }

        @Override
        public synchronized BigInteger getTokenForReplacementNode(BigInteger oldToken) {
            Preconditions.checkNotNull((Object)oldToken, (Object)"oldToken");
            return this.normalize(oldToken.subtract(BigInteger.ONE));
        }

        @Override
        public synchronized Set<BigInteger> getTokensForReplacementNode(Set<BigInteger> oldTokens) {
            Preconditions.checkNotNull(oldTokens, (Object)"oldToken");
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (BigInteger oldToken : oldTokens) {
                result.add(this.getTokenForReplacementNode(oldToken));
            }
            return result;
        }

        @Override
        public synchronized void growingCluster(int numNewNodes) {
            if (this.currentTokens.isEmpty() && this.nextTokens.isEmpty()) {
                this.nextTokens.addAll(this.generateEquidistantTokens(numNewNodes));
            } else {
                for (int i = 0; i < numNewNodes; ++i) {
                    this.nextTokens.add(this.generateBestNextToken());
                }
            }
        }

        @Override
        public synchronized void shrinkingCluster(Set<BigInteger> nodesToRemove) {
            this.currentTokens.remove(nodesToRemove);
        }

        @Override
        public synchronized void refresh(Set<BigInteger> currentNodes) {
            this.currentTokens.clear();
            this.currentTokens.addAll(currentNodes);
        }

        private List<BigInteger> generateEquidistantTokens(int numTokens) {
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < numTokens; ++i) {
                BigInteger token = this.range().multiply(BigInteger.valueOf(i)).divide(BigInteger.valueOf(numTokens)).add(this.min());
                token = this.normalize(token.add(this.origin));
                result.add(token);
            }
            return result;
        }

        private BigInteger normalize(BigInteger input) {
            while (input.compareTo(this.min()) < 0) {
                input = input.add(this.range());
            }
            while (input.compareTo(this.max()) > 0) {
                input = input.subtract(this.range());
            }
            return input;
        }

        private BigInteger generateBestNextToken() {
            MutableList allTokens = MutableList.of().appendAll(this.currentTokens).appendAll(this.nextTokens);
            Collections.sort(allTokens);
            Iterator ti = allTokens.iterator();
            BigInteger thisValue = (BigInteger)ti.next();
            BigInteger prevValue = ((BigInteger)allTokens.get(allTokens.size() - 1)).subtract(this.range());
            BigInteger bestNewTokenSoFar = this.normalize(prevValue.add(thisValue).divide(TWO));
            BigInteger biggestRangeSizeSoFar = thisValue.subtract(prevValue);
            while (ti.hasNext()) {
                prevValue = thisValue;
                thisValue = (BigInteger)ti.next();
                BigInteger rangeHere = thisValue.subtract(prevValue);
                if (rangeHere.compareTo(biggestRangeSizeSoFar) <= 0) continue;
                bestNewTokenSoFar = prevValue.add(thisValue).divide(TWO);
                biggestRangeSizeSoFar = rangeHere;
            }
            return bestNewTokenSoFar;
        }
    }
}

