/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.system;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskWrapper;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.internal.AbstractSshExecTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.internal.AbstractProcessTaskFactory;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessTaskWrapper<RET>
extends ProcessTaskStub
implements TaskWrapper<RET> {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskWrapper.class);
    private final Task<RET> task;
    protected Integer exitCode = null;
    private AbstractSshExecTaskFactory.Std2x2StreamProvider streamProvider;

    protected ProcessTaskWrapper(AbstractProcessTaskFactory<?, RET> constructor) {
        super(constructor);
        TaskBuilder<Object> tb = constructor.constructCustomizedTaskBuilder();
        this.initStreams(tb);
        this.task = tb.body(new ProcessTaskInternalJob()).build();
    }

    protected void initStreams(TaskBuilder<Object> tb) {
        this.streamProvider = AbstractSshExecTaskFactory.Std2x2StreamProvider.newDefault(tb);
    }

    protected void initStreams(AbstractSshExecTaskFactory.Std2x2StreamProvider r) {
        this.streamProvider = r;
    }

    protected ByteArrayOutputStream stdoutForReading() {
        return this.streamProvider.stdoutForReading;
    }

    protected OutputStream stdoutForWriting() {
        return this.streamProvider.stdoutForWriting;
    }

    protected ByteArrayOutputStream stderrForReading() {
        return this.streamProvider.stderrForReading;
    }

    protected OutputStream stderrForWriting() {
        return this.streamProvider.stderrForWriting;
    }

    public Task<RET> asTask() {
        return this.getTask();
    }

    public Task<RET> getTask() {
        return this.task;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public byte[] getStdoutBytes() {
        if (this.stdoutForReading() == null) {
            return null;
        }
        return this.stdoutForReading().toByteArray();
    }

    public byte[] getStderrBytes() {
        if (this.stderrForReading() == null) {
            return null;
        }
        return this.stderrForReading().toByteArray();
    }

    public String getStdout() {
        if (this.stdoutForReading() == null) {
            return null;
        }
        return this.stdoutForReading().toString();
    }

    public String getStderr() {
        if (this.stderrForReading() == null) {
            return null;
        }
        return this.stderrForReading().toString();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.task + "]";
    }

    public RET get() {
        return (RET)this.getTask().getUnchecked();
    }

    public ProcessTaskWrapper<RET> block() {
        this.getTask().blockUntilEnded();
        return this;
    }

    public boolean isDone() {
        return this.getTask().isDone();
    }

    protected ConfigBag getConfigForRunning() {
        ConfigBag config = ConfigBag.newInstanceCopying(this.config);
        if (this.stdoutForWriting() != null) {
            config.put(ShellTool.PROP_OUT_STREAM, this.stdoutForWriting());
        }
        if (this.stderrForWriting() != null) {
            config.put(ShellTool.PROP_ERR_STREAM, this.stderrForWriting());
        }
        if (!config.containsKey(ShellTool.PROP_NO_EXTRA_OUTPUT)) {
            config.put(ShellTool.PROP_NO_EXTRA_OUTPUT, true);
        }
        if (this.runAsRoot) {
            config.put(ShellTool.PROP_RUN_AS_ROOT, true);
        }
        return config;
    }

    protected abstract void run(ConfigBag var1);

    protected abstract String taskTypeShortName();

    protected class ProcessTaskInternalJob
    implements Callable<Object> {
        protected ProcessTaskInternalJob() {
        }

        @Override
        public Object call() throws Exception {
            ProcessTaskWrapper.this.run(ProcessTaskWrapper.this.getConfigForRunning());
            for (Function listener : ProcessTaskWrapper.this.completionListeners) {
                try {
                    listener.apply(ProcessTaskWrapper.this);
                }
                catch (Exception e) {
                    this.logWithDetailsAndThrow("Error in " + ProcessTaskWrapper.this.taskTypeShortName() + " task " + ProcessTaskWrapper.this.getSummary() + ": " + e, e);
                }
            }
            if (ProcessTaskWrapper.this.exitCode != 0 && !Boolean.FALSE.equals(ProcessTaskWrapper.this.requireExitCodeZero)) {
                if (Boolean.TRUE.equals(ProcessTaskWrapper.this.requireExitCodeZero)) {
                    this.logWithDetailsAndThrow(ProcessTaskWrapper.this.taskTypeShortName() + " task ended with exit code " + ProcessTaskWrapper.this.exitCode + " when 0 was required, in " + Tasks.current() + ": " + ProcessTaskWrapper.this.getSummary(), null);
                } else {
                    log.warn(ProcessTaskWrapper.this.taskTypeShortName() + " task ended with exit code " + ProcessTaskWrapper.this.exitCode + " when non-zero was not explicitly allowed (error may be thrown in future), in " + Tasks.current() + ": " + ProcessTaskWrapper.this.getSummary());
                }
            }
            switch (ProcessTaskWrapper.this.returnType) {
                case CUSTOM: {
                    return ProcessTaskWrapper.this.returnResultTransformation.apply(ProcessTaskWrapper.this);
                }
                case STDOUT_STRING: {
                    return ProcessTaskWrapper.this.getStdout();
                }
                case STDOUT_BYTES: {
                    return ProcessTaskWrapper.this.getStdoutBytes();
                }
                case STDERR_STRING: {
                    return ProcessTaskWrapper.this.getStderr();
                }
                case STDERR_BYTES: {
                    return ProcessTaskWrapper.this.getStderrBytes();
                }
                case EXIT_CODE: {
                    return ProcessTaskWrapper.this.exitCode;
                }
            }
            throw new IllegalStateException("Unknown return type for " + ProcessTaskWrapper.this.taskTypeShortName() + " job " + ProcessTaskWrapper.this.getSummary() + ": " + (Object)((Object)ProcessTaskWrapper.this.returnType));
        }

        protected void logWithDetailsAndThrow(String message, Throwable optionalCause) {
            message = (ProcessTaskWrapper.this.extraErrorMessage != null ? ProcessTaskWrapper.this.extraErrorMessage + ": " : "") + message;
            log.warn(message + " (throwing)");
            this.logProblemDetails("STDERR", ProcessTaskWrapper.this.stderrForReading(), 1024);
            this.logProblemDetails("STDOUT", ProcessTaskWrapper.this.stdoutForReading(), 1024);
            this.logProblemDetails("STDIN", Streams.byteArrayOfString((String)Strings.join(ProcessTaskWrapper.this.getCommands(true), (String)"\n")), 4096);
            if (optionalCause != null) {
                throw new IllegalStateException(message, optionalCause);
            }
            throw new IllegalStateException(message);
        }

        protected void logProblemDetails(String streamName, ByteArrayOutputStream stream, int max) {
            Streams.logStreamTail((Logger)log, (String)(streamName + " for problem in " + Tasks.current()), (ByteArrayOutputStream)stream, (int)max);
        }
    }
}

