/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.logbook;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.logbook.BrooklynLogEntry;
import org.apache.brooklyn.util.core.logbook.LogBookQueryParams;
import org.apache.brooklyn.util.core.logbook.LogStore;
import org.apache.brooklyn.util.core.logbook.LogbookConfig;
import org.apache.brooklyn.util.core.logbook.file.FileLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingLogStore
implements LogStore {
    private static final Logger log = LoggerFactory.getLogger(DelegatingLogStore.class);
    private final ManagementContext mgmt;
    private LogStore delegate;

    public DelegatingLogStore(ManagementContext mgmt) {
        this.mgmt = mgmt;
        mgmt.addPropertiesReloadListener((ManagementContext.PropertiesReloadListener)new PropertiesListener());
    }

    public synchronized LogStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.loadDelegate();
        }
        return this.delegate;
    }

    private LogStore loadDelegate() {
        StringConfigMap brooklynProperties = this.mgmt.getConfig();
        LogStore presetDelegate = (LogStore)brooklynProperties.getConfig(LogbookConfig.LOGBOOK_LOG_STORE_INSTANCE);
        if (presetDelegate != null) {
            log.trace("Brooklyn logbook: using pre-set log store {}", (Object)presetDelegate);
            return presetDelegate;
        }
        String className = (String)brooklynProperties.getConfig(LogbookConfig.LOGBOOK_LOG_STORE_CLASSNAME);
        try {
            ClassLoaderUtils clu = new ClassLoaderUtils((Object)this, this.mgmt);
            Class<?> clazz = clu.loadClass(className);
            this.delegate = this.createLogStoreProviderInstance(this.mgmt, clazz);
            log.info("Brooklyn Logbook: using log store " + className);
        }
        catch (Exception e) {
            log.warn("Brooklyn Logbook: unable to instantiate Log Store '" + className + "'. Fall back on FileLogStore", (Object)e.getMessage());
            log.debug("Exception thrown trying to instantiate {} as LogStore:", (Object)className, (Object)e);
            this.delegate = new FileLogStore(this.mgmt);
        }
        ((BrooklynProperties)this.mgmt.getConfig()).put(LogbookConfig.LOGBOOK_LOG_STORE_INSTANCE, this.delegate);
        this.mgmt.getScratchpad().put(LogbookConfig.LOGBOOK_LOG_STORE_INSTANCE, (Object)this.delegate);
        return this.delegate;
    }

    public LogStore createLogStoreProviderInstance(ManagementContext mgmt, Class<? extends LogStore> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        LogStore delegateO;
        Constructor<? extends LogStore> constructor = null;
        try {
            constructor = clazz.getConstructor(ManagementContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor != null) {
            delegateO = constructor.newInstance(mgmt);
        } else {
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                delegateO = constructor.newInstance(new Object[0]);
            } else {
                throw new NoSuchMethodException("Log store " + clazz + " does not have required no-arg or 1-arg (mgmt) constructor");
            }
        }
        if (!(delegateO instanceof LogStore)) {
            throw new ClassCastException("Delegate is either not a Log Store implementation or has an incompatible classloader: " + delegateO);
        }
        return delegateO;
    }

    @Override
    public List<BrooklynLogEntry> query(LogBookQueryParams params) throws IOException {
        return this.getDelegate().query(params);
    }

    @Override
    public Set<String> enumerateTaskIds(Set<?> parents, int maxTasks) {
        return this.getDelegate().enumerateTaskIds(parents, maxTasks);
    }

    private class PropertiesListener
    implements ManagementContext.PropertiesReloadListener {
        private static final long serialVersionUID = -8334871795049809213L;

        private PropertiesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloaded() {
            log.debug("{} reloading Logbook log store configuration", (Object)DelegatingLogStore.this);
            DelegatingLogStore delegatingLogStore = DelegatingLogStore.this;
            synchronized (delegatingLogStore) {
                DelegatingLogStore.this.loadDelegate();
            }
        }
    }
}

