/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh.process;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.ShellAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.StreamGobbler;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTool
extends ShellAbstractTool
implements ShellTool {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessTool.class);
    public static final ConfigKey<Boolean> PROP_LOGIN_SHELL = ConfigKeys.newConfigKey("loginShell", "Causes the commands to be invoked with bash arguments to forcea  login shell", Boolean.FALSE);
    public static final ConfigKey<String> PROP_DIRECTORY = ConfigKeys.newStringConfigKey("directory", "the working directory, for executing commands", null);

    public ProcessTool() {
        this((Map<String, ?>)null);
    }

    public ProcessTool(Map<String, ?> flags) {
        super((String)ProcessTool.getOptionalVal(flags, PROP_LOCAL_TEMP_DIR));
        if (flags != null) {
            MutableMap flags2 = MutableMap.copyOf(flags);
            flags2.remove((Object)PROP_LOCAL_TEMP_DIR.getName());
            if (!flags2.isEmpty()) {
                LOG.warn("" + this + " ignoring unsupported constructor flags: " + flags);
            }
        }
    }

    @Override
    public int execScript(Map<String, ?> props, final List<String> commands, final Map<String, ?> env) {
        return new ShellAbstractTool.ToolAbstractExecScript(props){

            @Override
            public int run() {
                try {
                    String directory = ShellAbstractTool.getOptionalVal(this.props, PROP_DIRECTORY);
                    File directoryDir = directory != null ? new File(Os.tidyPath((String)directory)) : null;
                    String scriptContents = ProcessTool.this.toScript(this.props, commands, env);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Running shell process (process) as script:\n{}", (Object)scriptContents);
                    }
                    File to = new File(this.scriptPath);
                    Files.createParentDirs((File)to);
                    ByteSource.wrap((byte[])scriptContents.getBytes()).copyTo(Files.asByteSink((File)to, (FileWriteMode[])new FileWriteMode[0]));
                    List<String> cmds = this.buildRunScriptCommand();
                    cmds.add(0, "chmod +x " + this.scriptPath);
                    return ProcessTool.asInt(ProcessTool.execProcesses(cmds, null, directoryDir, this.out, this.err, this.separator, ShellAbstractTool.getOptionalVal(this.props, PROP_LOGIN_SHELL), this), -1);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }.run();
    }

    @Override
    public int execCommands(Map<String, ?> props, List<String> commands, Map<String, ?> env) {
        if (Boolean.FALSE.equals(props.get("blocks"))) {
            throw new IllegalArgumentException("Cannot exec non-blocking: command=" + commands);
        }
        OutputStream out = (OutputStream)ProcessTool.getOptionalVal(props, PROP_OUT_STREAM);
        OutputStream err = (OutputStream)ProcessTool.getOptionalVal(props, PROP_ERR_STREAM);
        String separator = (String)ProcessTool.getOptionalVal(props, PROP_SEPARATOR);
        String directory = ProcessTool.getOptionalVal(props, PROP_DIRECTORY);
        File directoryDir = directory != null ? new File(Os.tidyPath((String)directory)) : null;
        List<String> allcmds = this.toCommandSequence(commands, null);
        String singlecmd = Joiner.on((String)separator).join(allcmds);
        if (Boolean.TRUE.equals(ProcessTool.getOptionalVal(props, PROP_RUN_AS_ROOT))) {
            LOG.warn("Cannot run as root when executing as command; run as a script instead (will run as normal user): " + singlecmd);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running shell command (process): {}", (Object)singlecmd);
        }
        return ProcessTool.asInt(ProcessTool.execProcesses(allcmds, env, directoryDir, out, err, separator, ProcessTool.getOptionalVal(props, PROP_LOGIN_SHELL), this), -1);
    }

    public static int execProcesses(List<String> cmds, Map<String, ?> env, File directory, OutputStream out, OutputStream err, String separator, boolean asLoginShell, Object contextForLogging) {
        MutableList commands = new MutableList().append((Object)"bash");
        if (asLoginShell) {
            commands.append((Object)"-l");
        }
        commands.append((Object)"-c", (Object)Strings.join(cmds, (String)((String)Preconditions.checkNotNull((Object)separator, (Object)"separator"))), (Object[])new String[0]);
        return ProcessTool.execSingleProcess((List<String>)commands, env, directory, out, err, contextForLogging);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int execSingleProcess(List<String> cmdWords, Map<String, ?> env, File directory, OutputStream out, OutputStream err, Object contextForLogging) {
        int n;
        StreamGobbler errgobbler = null;
        StreamGobbler outgobbler = null;
        ProcessBuilder pb = new ProcessBuilder(cmdWords);
        if (env != null) {
            for (Map.Entry<String, ?> kv : env.entrySet()) {
                pb.environment().put(kv.getKey(), String.valueOf(kv.getValue()));
            }
        }
        if (directory != null) {
            pb.directory(directory);
        }
        try {
            Process p = pb.start();
            if (out != null) {
                InputStream outstream = p.getInputStream();
                outgobbler = new StreamGobbler(outstream, out, (Logger)null);
                outgobbler.start();
            }
            if (err != null) {
                InputStream errstream = p.getErrorStream();
                errgobbler = new StreamGobbler(errstream, err, (Logger)null);
                errgobbler.start();
            }
            int result = p.waitFor();
            if (outgobbler != null) {
                outgobbler.blockUntilFinished();
            }
            if (errgobbler != null) {
                errgobbler.blockUntilFinished();
            }
            if (result == 255) {
                throw new SshException("exit code 255 from CLI ssh; probably failed to connect");
            }
            n = result;
        }
        catch (InterruptedException e) {
            try {
                throw Exceptions.propagate((Throwable)e);
                catch (IOException e2) {
                    throw Exceptions.propagate((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                ProcessTool.closeWhispering(outgobbler, contextForLogging, "execProcess");
                ProcessTool.closeWhispering(errgobbler, contextForLogging, "execProcess");
                throw throwable;
            }
        }
        ProcessTool.closeWhispering((Closeable)outgobbler, contextForLogging, "execProcess");
        ProcessTool.closeWhispering((Closeable)errgobbler, contextForLogging, "execProcess");
        return n;
    }
}

