/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsChangePolicy
extends AbstractMembershipTrackingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsChangePolicy.class);
    private static final String TYPE = "type";
    private static final String BROOKLYN_CONFIG = "brooklyn.config";
    public static final ConfigKey<List<Map<String, Object>>> LOCATIONS = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<List<Map<String, Object>>>(){}).name("member.locations")).description("Locations to add to any joining member when it joins")).defaultValue((ImmutableList)ImmutableList.of())).build();
    public static final ConfigKey<List<Map<String, Object>>> POLICIES = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<List<Map<String, Object>>>(){}).name("member.policies")).description("Policies to add to any joining member when it joins, of the form [{type: policyType, brooklyn.config: {configKey: configValue}}]")).defaultValue((ImmutableList)ImmutableList.of())).build();
    public static final ConfigKey<List<Map<String, Object>>> INITIALIZERS = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<List<Map<String, Object>>>(){}).name("member.initializers")).description("Initializers to run on any joining member when it joins")).defaultValue((ImmutableList)ImmutableList.of())).build();
    public static final ConfigKey<List<Map<String, Object>>> ENRICHERS = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<List<Map<String, Object>>>(){}).name("member.enrichers")).description("Enrichers to add to any joining member when it joins")).defaultValue((ImmutableList)ImmutableList.of())).build();
    public static final ConfigKey<List<String>> INVOKE = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<List<String>>(){}).name("member.invoke")).description("Effectors to invoke on any joining member when it joins (run in parallel asynchronously, after initializers so they can add new effectors)")).defaultValue((ImmutableList)ImmutableList.of())).build();

    @Override
    protected void onEntityAdded(Entity member) {
        super.onEntityAdded(member);
        ManagementContext mgmt = this.getManagementContext();
        this.getMaps(LOCATIONS).forEach(stringObjectMap -> {
            try {
                String type = (String)stringObjectMap.get(TYPE);
                Maybe<RegisteredType> item = RegisteredTypes.tryValidate(mgmt.getTypeRegistry().get(type), RegisteredTypeLoadingContexts.spec(BrooklynObjectType.LOCATION.getInterfaceType()));
                LocationSpec locationSpec = !item.isNull() ? (LocationSpec)mgmt.getTypeRegistry().createSpec((RegisteredType)item.get(), null, BrooklynObjectType.LOCATION.getSpecType()) : LocationSpec.create((Map)ImmutableMap.of(), (Class)((Class)RegisteredTypes.getClassLoadingContext(member).tryLoadClass(type).get()));
                ExecutionContext memberExecutionContext = ((EntityInternal)member).getExecutionContext();
                Map brooklynConfig = (Map)stringObjectMap.get(BROOKLYN_CONFIG);
                ConfigBag configBag = ConfigBag.newInstance(brooklynConfig);
                brooklynConfig.forEach((key, value) -> {
                    Object resolvedValueFromMember = EntityInitializers.resolve(configBag, ConfigKeys.newConfigKey(Object.class, key), memberExecutionContext);
                    locationSpec.configure((CharSequence)key, resolvedValueFromMember);
                });
                AbstractTypePlanTransformer.checkSecuritySensitiveFields(locationSpec);
                Location location = ((EntityInternal)member).getManagementContext().getLocationManager().createLocation(locationSpec);
                LOG.info("Applying location '{}' to member '{}'", (Object)location, (Object)member);
                ((EntityInternal)member).addLocations((Collection<? extends Location>)ImmutableList.of((Object)location));
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
        this.getMaps(INITIALIZERS).forEach(stringObjectMap -> {
            try {
                String type = (String)stringObjectMap.get(TYPE);
                BrooklynClassLoadingContext loader = member != null ? RegisteredTypes.getClassLoadingContext(member) : null;
                TypeToken typeToken = GroupsChangePolicy.getType(loader, type);
                Maybe entityInitializerMaybe = BeanWithTypeUtils.tryConvertOrAbsentUsingContext((Maybe<Object>)Maybe.of((Object)stringObjectMap), typeToken);
                if (entityInitializerMaybe.isPresent()) {
                    EntityInitializer initializer = (EntityInitializer)entityInitializerMaybe.get();
                    LOG.info("Applying initializer '{}' to member '{}'", (Object)initializer, (Object)member);
                    initializer.apply((EntityLocal)((EntityInternal)member));
                } else {
                    LOG.debug("Unable to initialize {} due to {}", new Object[]{type, Maybe.getException(entityInitializerMaybe), Maybe.getException(entityInitializerMaybe)});
                }
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
        this.getMaps(POLICIES).forEach(stringObjectMap -> {
            String type = (String)stringObjectMap.get(TYPE);
            Maybe<RegisteredType> item = RegisteredTypes.tryValidate(mgmt.getTypeRegistry().get(type), RegisteredTypeLoadingContexts.spec(BrooklynObjectType.POLICY.getInterfaceType()));
            PolicySpec policySpec = !item.isNull() ? (PolicySpec)mgmt.getTypeRegistry().createSpec((RegisteredType)item.get(), null, BrooklynObjectType.POLICY.getSpecType()) : PolicySpec.create((Map)ImmutableMap.of(), (Class)((Class)RegisteredTypes.getClassLoadingContext((Entity)this.entity).tryLoadClass(type).get()));
            policySpec.configure((Map)stringObjectMap.get(BROOKLYN_CONFIG));
            AbstractTypePlanTransformer.checkSecuritySensitiveFields(policySpec);
            LOG.info("Adding policy '{}' to member '{}'", (Object)policySpec, (Object)member);
            member.policies().add(policySpec);
        });
        this.getMaps(ENRICHERS).forEach(stringObjectMap -> {
            String type = (String)stringObjectMap.get(TYPE);
            Maybe<RegisteredType> item = RegisteredTypes.tryValidate(mgmt.getTypeRegistry().get(type), RegisteredTypeLoadingContexts.spec(BrooklynObjectType.ENRICHER.getInterfaceType()));
            EnricherSpec enricherSpec = !item.isNull() ? (EnricherSpec)mgmt.getTypeRegistry().createSpec((RegisteredType)item.get(), null, BrooklynObjectType.ENRICHER.getSpecType()) : EnricherSpec.create((Map)ImmutableMap.of(), (Class)((Class)RegisteredTypes.getClassLoadingContext((Entity)this.entity).tryLoadClass(type).get()));
            enricherSpec.configure((Map)stringObjectMap.get(BROOKLYN_CONFIG));
            AbstractTypePlanTransformer.checkSecuritySensitiveFields(enricherSpec);
            LOG.info("Adding enricher '{}' to member '{}'", (Object)enricherSpec, (Object)member);
            member.enrichers().add(enricherSpec);
        });
        ((List)this.config().get(INVOKE)).forEach(effName -> {
            LOG.info("Invoking effector '{}' on member '{}'", effName, (Object)member);
            member.invoke(((EntityInternal)member).getEffector((String)effName), (Map)MutableMap.of());
        });
    }

    private static <T> TypeToken<T> getType(BrooklynClassLoadingContext loader, String className) {
        return new BrooklynTypeNameResolution.BrooklynTypeNameResolver("", loader, true, true).getTypeToken(className);
    }

    private List<Map<String, Object>> getMaps(ConfigKey<List<Map<String, Object>>> key) {
        Maybe<Object> rawInitializers = this.config().getRaw(key);
        return rawInitializers.isPresent() ? (List)rawInitializers.get() : ImmutableList.of();
    }

    @Override
    protected Group getGroup() {
        Group result = super.getGroup();
        if (result != null) {
            return result;
        }
        if (this.entity instanceof Group) {
            return (Group)this.entity;
        }
        return null;
    }
}

