/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletePolicyWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(DeletePolicyWorkflowStep.class);
    public static final String SHORTHAND = "[ ${policy} [ \" at \" ${entity} ] ]";
    public static final ConfigKey<Object> POLICY = ConfigKeys.newConfigKey(Object.class, "policy");
    public static final ConfigKey<Object> ENTITY = ConfigKeys.newConfigKey(Object.class, "entity");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (!this.getInput().containsKey(POLICY.getName())) {
            throw new IllegalArgumentException("Missing required argument: " + POLICY.getName());
        }
    }

    protected Pair<String, String> getStepState(WorkflowStepInstanceExecutionContext context) {
        return (Pair)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, Pair<String, String> foundEntityAndPolicyId) {
        context.setStepState(foundEntityAndPolicyId, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Pair<String, String> found = this.getStepState(context);
        Entity entity = null;
        EntityAdjunct policy = null;
        if (found == null) {
            Object entityToFind = context.getInput(ENTITY);
            entity = entityToFind != null ? (Entity)WorkflowStepResolution.findEntity(context, entityToFind).get() : context.getEntity();
            policy = (EntityAdjunct)EntityAdjuncts.tryFindOnEntity(entity, context.getInput(POLICY)).get();
            this.setStepState(context, (Pair<String, String>)Pair.of((Object)entity.getId(), (Object)policy.getUniqueTag()));
        } else {
            entity = context.getManagementContext().getEntityManager().getEntity((String)found.getLeft());
            policy = (EntityAdjunct)EntityAdjuncts.tryFindOnEntity(entity, found.getRight()).orNull();
            if (policy == null) {
                return context.getPreviousStepOutput();
            }
        }
        EntityAdjuncts.removeAdjunct(entity, policy);
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

