/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractMemento;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BasicCatalogItemMemento
extends AbstractMemento
implements CatalogItemMemento,
Serializable {
    private static final long serialVersionUID = -2040630288193425950L;
    private String description;
    private String symbolicName;
    private String containingBundle;
    private String iconUrl;
    private String javaType;
    private String version;
    private String planYaml;
    private List<SpecParameter<?>> parameters;
    private Collection<CatalogItem.CatalogBundle> libraries;
    private CatalogItem.CatalogItemType catalogItemType;
    private Class<?> catalogItemJavaType;
    private Class<?> specType;
    private boolean deprecated;
    private boolean disabled;

    public static Builder builder() {
        return new Builder();
    }

    private BasicCatalogItemMemento() {
    }

    protected BasicCatalogItemMemento(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.symbolicName = builder.symbolicName;
        this.containingBundle = builder.containingBundle;
        this.iconUrl = builder.iconUrl;
        this.version = builder.version;
        this.planYaml = builder.planYaml;
        this.parameters = builder.parameters;
        this.libraries = builder.libraries;
        this.catalogItemJavaType = builder.catalogItemJavaType;
        this.catalogItemType = builder.catalogItemType;
        this.specType = builder.specType;
        this.javaType = builder.javaType;
        this.deprecated = builder.deprecated;
        this.disabled = builder.disabled;
    }

    @Override
    public String getId() {
        return CatalogUtils.getVersionedId(this.getSymbolicName(), this.getVersion());
    }

    public String getDescription() {
        return this.description;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getContainingBundle() {
        return this.containingBundle;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "0.0.0-SNAPSHOT";
    }

    public String getPlanYaml() {
        return this.planYaml;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public List<SpecParameter<?>> getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        return ImmutableList.of();
    }

    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        return this.libraries;
    }

    public CatalogItem.CatalogItemType getCatalogItemType() {
        return this.catalogItemType;
    }

    public Class<?> getCatalogItemJavaType() {
        return this.catalogItemJavaType;
    }

    public Class<?> getSpecType() {
        return this.specType;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    protected void setCustomFields(Map<String, Object> fields) {
        if (!fields.isEmpty()) {
            throw new UnsupportedOperationException("Cannot set custom fields on " + this + ". Fields=" + Joiner.on((String)", ").join(fields.keySet()));
        }
    }

    @Override
    public Map<String, ? extends Object> getCustomFields() {
        return Collections.emptyMap();
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("description", (Object)this.getDescription()).add("symbolicName", (Object)this.getSymbolicName()).add("iconUrl", (Object)this.getIconUrl()).add("version", (Object)this.getVersion()).add("planYaml", (Object)this.getPlanYaml()).add("parameters", this.getParameters()).add("libraries", this.getLibraries()).add("catalogItemJavaType", this.getCatalogItemJavaType()).add("catalogItemType", (Object)this.getCatalogItemType()).add("javaType", (Object)this.getJavaType()).add("specType", this.getSpecType()).add("deprecated", this.isDeprecated()).add("disabled", this.isDisabled());
    }

    public static class Builder
    extends AbstractMemento.Builder<Builder> {
        protected String description;
        protected String symbolicName;
        protected String containingBundle;
        protected String iconUrl;
        protected String javaType;
        protected String version;
        protected String planYaml;
        protected List<SpecParameter<?>> parameters;
        protected Collection<CatalogItem.CatalogBundle> libraries;
        protected CatalogItem.CatalogItemType catalogItemType;
        protected Class<?> catalogItemJavaType;
        protected Class<?> specType;
        protected boolean deprecated;
        protected boolean disabled;

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        public Builder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return (Builder)this.self();
        }

        public Builder containingBundle(String containingBundle) {
            this.containingBundle = containingBundle;
            return (Builder)this.self();
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return (Builder)this.self();
        }

        public Builder javaType(String javaType) {
            this.javaType = javaType;
            return (Builder)this.self();
        }

        public Builder version(String version) {
            this.version = version;
            return (Builder)this.self();
        }

        public Builder planYaml(String planYaml) {
            this.planYaml = planYaml;
            return (Builder)this.self();
        }

        public Builder parameters(List<SpecParameter<?>> params) {
            this.parameters = params;
            return (Builder)this.self();
        }

        public Builder libraries(Collection<CatalogItem.CatalogBundle> libraries) {
            this.libraries = libraries;
            return (Builder)this.self();
        }

        public Builder catalogItemType(CatalogItem.CatalogItemType catalogItemType) {
            this.catalogItemType = catalogItemType;
            return (Builder)this.self();
        }

        public Builder catalogItemJavaType(Class<?> catalogItemJavaType) {
            this.catalogItemJavaType = catalogItemJavaType;
            return (Builder)this.self();
        }

        public Builder specType(Class<?> specType) {
            this.specType = specType;
            return (Builder)this.self();
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return (Builder)this.self();
        }

        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return (Builder)this.self();
        }

        public Builder from(CatalogItemMemento other) {
            super.from((Memento)other);
            this.description = other.getDescription();
            this.symbolicName = other.getSymbolicName();
            this.containingBundle = other.getContainingBundle();
            this.iconUrl = other.getIconUrl();
            this.javaType = other.getJavaType();
            this.version = other.getVersion();
            this.planYaml = other.getPlanYaml();
            this.parameters = other.getParameters();
            this.libraries = other.getLibraries();
            this.catalogItemType = other.getCatalogItemType();
            this.catalogItemJavaType = other.getCatalogItemJavaType();
            this.specType = other.getSpecType();
            this.deprecated = other.isDeprecated();
            this.disabled = other.isDisabled();
            return (Builder)this.self();
        }

        public BasicCatalogItemMemento build() {
            return new BasicCatalogItemMemento(this);
        }
    }
}

