/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.internal.storage.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.core.internal.storage.impl.ConcurrentMapAcceptingNullVals;

class InmemoryDatagrid {
    private final Map<String, Map<?, ?>> maps = Maps.newLinkedHashMap();
    private final AtomicInteger creationCounter = new AtomicInteger();

    InmemoryDatagrid() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> ConcurrentMap<K, V> getMap(String id) {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            ConcurrentMap<K, V> result = (ConcurrentMap<K, V>)this.maps.get(id);
            if (result == null) {
                result = this.newMap();
                this.maps.put(id, result);
                this.creationCounter.incrementAndGet();
            }
            return result;
        }
    }

    private <K, V> ConcurrentMap<K, V> newMap() {
        return new ConcurrentMapAcceptingNullVals(Maps.newConcurrentMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            this.maps.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            this.maps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDatagridMetrics() {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            return ImmutableMap.of((Object)"size", (Object)this.maps.size(), (Object)"createCount", (Object)this.creationCounter.get());
        }
    }

    public Set<String> getKeys() {
        return this.maps.keySet();
    }
}

