/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.CatalogPredicates;
import org.apache.brooklyn.core.catalog.internal.CatalogBundleDto;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDo;
import org.apache.brooklyn.core.catalog.internal.CatalogDo;
import org.apache.brooklyn.core.catalog.internal.CatalogDto;
import org.apache.brooklyn.core.catalog.internal.CatalogItemBuilder;
import org.apache.brooklyn.core.catalog.internal.CatalogItemComparator;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDo;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.classloading.OsgiBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.CampYamlParser;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.plan.PlanToSpecFactory;
import org.apache.brooklyn.core.plan.PlanToSpecTransformer;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.core.typereg.BasicRegisteredType;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.LoadedClassLoader;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.InputStreamSource;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.brooklyn.util.yaml.Yamls;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BasicBrooklynCatalog
implements BrooklynCatalog {
    public static final String POLICIES_KEY = "brooklyn.policies";
    public static final String ENRICHERS_KEY = "brooklyn.enrichers";
    public static final String LOCATIONS_KEY = "brooklyn.locations";
    public static final String NO_VERSION = "0.0.0-SNAPSHOT";
    public static final String CATALOG_BOM = "catalog.bom";
    public static final String OSGI_MANIFEST_VERSION_VALUE = "1.0";
    public static final String BROOKLYN_WRAPPED_BOM_BUNDLE = "Brooklyn-Wrapped-BOM";
    @VisibleForTesting
    public static final boolean AUTO_WRAP_CATALOG_YAML_AS_BUNDLE = true;
    public static final String CATALOG_OSGI_WRAP_HEADERS = "catalog.osgi.wrap.headers";
    private static final Logger log = LoggerFactory.getLogger(BasicBrooklynCatalog.class);
    private static boolean ATTEMPT_INSTANTIATION_WITH_LEGACY_PLAN_TO_SPEC_CONVERTERS = true;
    private final ManagementContext mgmt;
    private CatalogDo catalog;
    private volatile CatalogDo manualAdditionsCatalog;
    private volatile LoadedClassLoader manualAdditionsClasses;
    private final AggregateClassLoader rootClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
    private static boolean WARNED_RE_DSL_PARSER = false;
    private final SpecCache specCache;
    private static ThreadLocal<Boolean> deletingCatalogItem = new ThreadLocal();
    public static ThreadLocal<String> currentlyResolvingType = new ThreadLocal();
    public static ThreadLocal<RegisteredType> currentlyValidatingType = new ThreadLocal();
    private Object uninstallingEmptyLock = new Object();

    public BasicBrooklynCatalog(ManagementContext mgmt) {
        this(mgmt, CatalogDto.newNamedInstance("empty catalog", "empty catalog", "empty catalog, expected to be reset later"));
    }

    public BasicBrooklynCatalog(ManagementContext mgmt, CatalogDto dto) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"managementContext");
        this.catalog = new CatalogDo(mgmt, dto);
        this.specCache = new SpecCache();
    }

    public boolean blockIfNotLoaded(Duration timeout) {
        try {
            return this.getCatalog().blockIfNotLoaded(timeout);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void reset(CatalogDto dto) {
        this.reset(dto, true);
    }

    public void reset(CatalogDto dto, boolean failOnLoadError) {
        this.specCache.invalidate();
        for (CatalogItem toRemove : this.getCatalogItemsLegacy()) {
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence removal: {}", (Object)toRemove.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onUnmanaged(toRemove);
        }
        CatalogDo catalog = new CatalogDo(this.mgmt, dto);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Resetting " + this + " catalog to " + dto, new Object[0]);
        catalog.load(this.mgmt, null, failOnLoadError);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Reloaded catalog for " + this + ", now switching", new Object[0]);
        this.catalog = catalog;
        this.resetRootClassLoader();
        this.manualAdditionsCatalog = null;
        for (CatalogItem entry : this.getCatalogItemsLegacy()) {
            CatalogItemDo cid;
            boolean setManagementContext = false;
            if (entry instanceof CatalogItemDo && (cid = (CatalogItemDo)CatalogItemDo.class.cast(entry)).getDto() instanceof CatalogItemDtoAbstract) {
                CatalogItemDtoAbstract cdto = (CatalogItemDtoAbstract)CatalogItemDtoAbstract.class.cast(cid.getDto());
                if (cdto.getManagementContext() == null) {
                    cdto.setManagementContext((ManagementContextInternal)this.mgmt);
                }
                setManagementContext = true;
                this.onAdditionUpdateOtherRegistries(cdto);
            }
            if (!setManagementContext) {
                log.warn("Can't set management context on entry with unexpected type in catalog. type={}, expected={}", entry, CatalogItemDo.class);
            }
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence addition: {}", (Object)entry.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onManaged(entry);
        }
    }

    public void reset(Collection<CatalogItem<?, ?>> entries) {
        CatalogDto newDto = CatalogDto.newDtoFromCatalogItems(entries, "explicit-catalog-reset");
        this.reset(newDto);
    }

    public CatalogDo getCatalog() {
        return this.catalog;
    }

    protected CatalogItemDo<?, ?> getCatalogItemDo(String symbolicName, String version) {
        String fixedVersionId = this.getFixedVersionId(symbolicName, version);
        if (fixedVersionId == null) {
            return null;
        }
        return this.catalog.getIdCache().get(CatalogUtils.getVersionedId(symbolicName, fixedVersionId));
    }

    private String getFixedVersionId(String symbolicName, String version) {
        if (version != null && !"0.0.0_DEFAULT_VERSION".equals(version)) {
            return version;
        }
        return this.getBestVersion(symbolicName);
    }

    private String getBestVersion(String symbolicName) {
        Iterable versions = this.getCatalogItems(Predicates.and(CatalogPredicates.disabled(false), CatalogPredicates.symbolicName((Predicate<? super String>)Predicates.equalTo((Object)symbolicName))));
        Collection orderedVersions = this.sortVersionsDesc(versions);
        if (!orderedVersions.isEmpty()) {
            return orderedVersions.iterator().next().getVersion();
        }
        return null;
    }

    private <T, SpecT> Collection<CatalogItem<T, SpecT>> sortVersionsDesc(Iterable<CatalogItem<T, SpecT>> versions) {
        return ImmutableSortedSet.orderedBy(CatalogItemComparator.getInstance()).addAll(versions).build();
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItem(String symbolicName, String version) {
        CatalogItem<?, ?> legacy = this.getCatalogItemLegacy(symbolicName, version);
        if (legacy != null) {
            return legacy;
        }
        RegisteredType rt = this.mgmt.getTypeRegistry().get(symbolicName, version);
        if (rt != null) {
            return RegisteredTypes.toPartialCatalogItem(rt);
        }
        return null;
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItemLegacy(String symbolicName, String version) {
        if (symbolicName == null) {
            return null;
        }
        CatalogItemDo<?, ?> itemDo = this.getCatalogItemDo(symbolicName, version);
        if (itemDo == null) {
            return null;
        }
        return itemDo.getDto();
    }

    @Deprecated
    public void deleteCatalogItem(String symbolicName, String version) {
        this.deleteCatalogItem(symbolicName, version, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void deleteCatalogItem(String symbolicName, String version, boolean alsoCheckTypeRegistry, boolean failIfNotFound) {
        if (alsoCheckTypeRegistry && !Boolean.TRUE.equals(deletingCatalogItem.get())) {
            deletingCatalogItem.set(true);
            try {
                RegisteredType item = this.mgmt.getTypeRegistry().get(symbolicName, version);
                if (item == null) {
                    log.debug("Request to delete " + symbolicName + ":" + version + " but nothing matching found; ignoring");
                } else {
                    ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).delete(item);
                }
                return;
            }
            finally {
                deletingCatalogItem.remove();
            }
        }
        log.debug("Deleting manual catalog item from " + this.mgmt + ": " + symbolicName + ":" + version);
        Preconditions.checkNotNull((Object)symbolicName, (Object)"id");
        Preconditions.checkNotNull((Object)version, (Object)"version");
        if ("0.0.0_DEFAULT_VERSION".equals(version)) {
            throw new IllegalStateException("Deleting items with unspecified version (argument DEFAULT_VERSION) not supported.");
        }
        CatalogItem<?, ?> item = this.getCatalogItemLegacy(symbolicName, version);
        CatalogItemDtoAbstract<?, ?> itemDto = this.getAbstractCatalogItem(item);
        if (itemDto == null) {
            if (failIfNotFound) {
                throw new NoSuchElementException("No catalog item found with id " + symbolicName);
            }
            return;
        }
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.deleteEntry(itemDto);
        this.specCache.invalidate();
        this.getCatalog().deleteEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence removal: {}", (Object)itemDto.getId());
        }
        this.mgmt.getRebindManager().getChangeListener().onUnmanaged(itemDto);
    }

    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItem(Class<T> type, String id, String version) {
        CatalogItem<T, SpecT> item = this.getCatalogItemLegacy(type, id, version);
        if (item != null) {
            return item;
        }
        RegisteredType rt = this.mgmt.getTypeRegistry().get(id, version);
        if (rt != null && (rt.getSuperTypes().contains(type) || rt.getSuperTypes().contains(type.getName()))) {
            return RegisteredTypes.toPartialCatalogItem(rt);
        }
        return null;
    }

    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItemLegacy(Class<T> type, String id, String version) {
        if (id == null || version == null) {
            return null;
        }
        CatalogItem<?, ?> result = this.getCatalogItem(id, version);
        if (result == null) {
            return null;
        }
        if (type == null || type.isAssignableFrom(result.getCatalogItemJavaType())) {
            return result;
        }
        return null;
    }

    public void persist(CatalogItem<?, ?> catalogItem) {
        Preconditions.checkArgument((this.getCatalogItem(catalogItem.getSymbolicName(), catalogItem.getVersion()) != null ? 1 : 0) != 0, (String)"Unknown catalog item %s", catalogItem);
        this.mgmt.getRebindManager().getChangeListener().onChanged(catalogItem);
    }

    public ClassLoader getRootClassLoader() {
        if (this.rootClassLoader.isEmpty() && this.catalog != null) {
            this.resetRootClassLoader();
        }
        return this.rootClassLoader;
    }

    private void resetRootClassLoader() {
        this.specCache.invalidate();
        this.rootClassLoader.reset((Collection)ImmutableList.of((Object)this.catalog.getRootClassLoader()));
    }

    public void load() {
        log.debug("Loading catalog for " + this.mgmt);
        this.getCatalog().load(this.mgmt, null);
        if (log.isDebugEnabled()) {
            log.debug("Loaded catalog for " + this.mgmt + ": " + this.catalog + "; search classpath is " + this.catalog.getRootClassLoader());
        }
    }

    public AbstractBrooklynObjectSpec<?, ?> peekSpec(CatalogItem<?, ?> item) {
        if (item == null) {
            return null;
        }
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            throw new RuntimeException(item + " not in catalog; cannot create spec");
        }
        if (loadedItem.getSpecType() == null) {
            return null;
        }
        String itemId = item.getCatalogItemId();
        Optional<AbstractBrooklynObjectSpec<?, ?>> cachedSpec = this.specCache.getSpec(itemId);
        if (cachedSpec.isPresent()) {
            return (AbstractBrooklynObjectSpec)cachedSpec.get();
        }
        Object spec = BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, loadedItem, (Set<String>)MutableSet.of(), true);
        if (spec != null) {
            this.specCache.addSpec(itemId, (AbstractBrooklynObjectSpec<?, ?>)spec);
            return spec;
        }
        throw new IllegalStateException("No known mechanism to create instance of " + item);
    }

    @Deprecated
    public <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT createSpec(CatalogItem<T, SpecT> item) {
        if (item == null) {
            return null;
        }
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            RegisteredType registeredType = this.mgmt.getTypeRegistry().get(item.getSymbolicName(), item.getVersion());
            if (registeredType == null) {
                throw new RuntimeException(item + " not in catalog; cannot create spec");
            }
            AbstractBrooklynObjectSpec spec = this.mgmt.getTypeRegistry().createSpec(registeredType, null, null);
            if (spec == null) {
                throw new RuntimeException("Problem loading spec for type " + registeredType);
            }
            return (SpecT)spec;
        }
        if (loadedItem.getSpecType() == null) {
            return null;
        }
        Object spec = BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, loadedItem, (Set<String>)MutableSet.of(), true);
        if (spec != null) {
            return (SpecT)spec;
        }
        throw new IllegalStateException("No known mechanism to create instance of " + item);
    }

    @Deprecated
    public static <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT internalCreateSpecLegacy(ManagementContext mgmt, final CatalogItem<T, SpecT> item, final Set<String> encounteredTypes, boolean includeDeprecatedTransformers) {
        if (encounteredTypes.contains(item.getSymbolicName())) {
            throw new IllegalStateException("Type being resolved '" + item.getSymbolicName() + "' has already been encountered in " + encounteredTypes + "; recursive cycle detected");
        }
        Maybe specMaybe = PlanToSpecFactory.attemptWithLoaders(mgmt, includeDeprecatedTransformers, new Function<PlanToSpecTransformer, SpecT>(){

            public SpecT apply(PlanToSpecTransformer input) {
                return input.createCatalogSpec(item, encounteredTypes);
            }
        });
        return (SpecT)((AbstractBrooklynObjectSpec)specMaybe.get());
    }

    @Deprecated
    private <T, SpecT> CatalogItemDtoAbstract<T, SpecT> getAbstractCatalogItem(CatalogItem<T, SpecT> item) {
        while (item instanceof CatalogItemDo) {
            item = ((CatalogItemDo)item).itemDto;
        }
        if (item == null) {
            return null;
        }
        if (item instanceof CatalogItemDtoAbstract) {
            return (CatalogItemDtoAbstract)item;
        }
        CatalogItem<?, ?> item2 = this.getCatalogItemLegacy(item.getSymbolicName(), item.getVersion());
        if (item2 instanceof CatalogItemDtoAbstract) {
            return (CatalogItemDtoAbstract)item2;
        }
        throw new IllegalStateException("Cannot unwrap catalog item '" + item + "' (type " + item.getClass() + ") to restore DTO");
    }

    private static <T> Maybe<T> getFirstAs(Map<?, ?> map, Class<T> type, String firstKey, String ... otherKeys) {
        return ConfigUtils.getFirstAs(map, type, firstKey, otherKeys);
    }

    private static Maybe<Map<?, ?>> getFirstAsMap(Map<?, ?> map, String firstKey, String ... otherKeys) {
        return BasicBrooklynCatalog.getFirstAs(map, Map.class, firstKey, otherKeys);
    }

    public static Map<?, ?> getCatalogMetadata(String yaml) {
        Map itemDef = (Map)Yamls.getAs((Object)Yamls.parseAll((String)yaml), Map.class);
        return (Map)BasicBrooklynCatalog.getFirstAsMap(itemDef, "brooklyn.catalog", new String[0]).orNull();
    }

    public static VersionedName getVersionedName(Map<?, ?> catalogMetadata, boolean required) {
        VersionedName idV = null;
        String idS = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "id", new String[0]).orNull();
        if (Strings.isNonBlank((CharSequence)idS)) {
            idV = VersionedName.fromString((String)idS);
        }
        String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
        String bundle = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "bundle", new String[0]).orNull();
        if (bundle == null && idV != null) {
            bundle = idV.getSymbolicName();
            if (Strings.isNonBlank((CharSequence)idV.getVersionString())) {
                if (version != null) {
                    if (!Objects.equal((Object)version, (Object)idV.getVersionString()) && !Objects.equal((Object)version, (Object)idV.getOsgiVersionString())) {
                        throw new IllegalStateException("Catalog BOM using ID '" + idV + "' to define bundle does not match declared version '" + version + "'");
                    }
                } else {
                    version = idV.getVersionString();
                }
            } else if (required) {
                throw new IllegalStateException("Catalog BOM must define bundle name and version or include version as part of the id '" + bundle + "' (eg '" + bundle + ":1.0')");
            }
        }
        if (Strings.isBlank((CharSequence)bundle) && Strings.isBlank((CharSequence)version)) {
            if (!required) {
                return null;
            }
            throw new IllegalStateException("Catalog BOM must define bundle name and version");
        }
        if (Strings.isBlank((CharSequence)bundle)) {
            if (!required) {
                return null;
            }
            throw new IllegalStateException("Catalog BOM must define bundle (or id)");
        }
        if (Strings.isBlank((CharSequence)version) && required) {
            throw new IllegalStateException("Catalog BOM must define version where bundle name '" + bundle + "' is defined");
        }
        return new VersionedName(bundle, version);
    }

    private void collectCatalogItemsFromCatalogBomRoot(String contextForError, String yaml, ManagedBundle containingBundle, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<?, ?> parentMeta, int depth, boolean force, Boolean throwOnError) {
        Map itemDef;
        try {
            itemDef = (Map)Yamls.getAs((Object)Yamls.parseAll((String)yaml), Map.class);
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)("Error parsing YAML in " + contextForError), (Throwable)e);
        }
        Map catalogMetadata = (Map)BasicBrooklynCatalog.getFirstAsMap(itemDef, "brooklyn.catalog", new String[0]).orNull();
        if (catalogMetadata == null) {
            log.warn("No `brooklyn.catalog` supplied in catalog request; using legacy mode for " + Sanitizer.sanitize(itemDef));
        }
        catalogMetadata = MutableMap.copyOf((Map)catalogMetadata);
        this.collectCatalogItemsFromItemMetadataBlock(Yamls.getTextOfYamlAtPath((String)yaml, (Object[])new Object[]{"brooklyn.catalog"}).getMatchedYamlTextOrWarn(), containingBundle, catalogMetadata, resultLegacyFormat, resultNewFormat, requireValidation, parentMeta, 0, force, throwOnError);
        itemDef.remove("brooklyn.catalog");
        catalogMetadata.remove("item");
        catalogMetadata.remove("items");
        catalogMetadata.remove("tags");
        if (!itemDef.isEmpty()) {
            log.warn("Deprecated read of catalog item from sibling keys of `brooklyn.catalog` section, instead of the more common appraoch of putting inside an `item` within it. Rewrite to use nested/reference syntax instead or contact the community for assistance or feedback.");
            MutableMap rootItem = MutableMap.of((Object)"item", (Object)itemDef);
            String rootItemYaml = yaml;
            Yamls.YamlExtract yamlExtract = Yamls.getTextOfYamlAtPath((String)rootItemYaml, (Object[])new Object[]{"brooklyn.catalog"});
            String match = yamlExtract.withOriginalIndentation(true).withKeyIncluded(true).getMatchedYamlTextOrWarn();
            if (match != null) {
                rootItemYaml = rootItemYaml.startsWith(match) ? Strings.removeFromStart((String)rootItemYaml, (String)match) : Strings.replaceAllNonRegex((String)rootItemYaml, (String)("\n" + match), (String)"");
            }
            this.collectCatalogItemsFromItemMetadataBlock("item:\n" + this.makeAsIndentedObject(rootItemYaml), containingBundle, (Map<?, ?>)rootItem, resultLegacyFormat, resultNewFormat, requireValidation, catalogMetadata, 1, force, throwOnError);
        }
    }

    private void collectCatalogItemsFromItemMetadataBlock(String sourceYaml, ManagedBundle containingBundle, Map<?, ?> itemMetadata, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<?, ?> parentMetadata, int depth, boolean force, Boolean throwOnError) {
        String itemAsString;
        if (throwOnError == null) {
            throwOnError = resultLegacyFormat != null;
        }
        if (sourceYaml == null) {
            sourceYaml = new Yaml().dump(itemMetadata);
        }
        Object itemMetadataWithoutItemDef = MutableMap.builder().putAll(itemMetadata).remove((Object)"item").remove((Object)"items").build();
        CampYamlParser parser = (CampYamlParser)this.mgmt.getScratchpad().get(CampYamlParser.YAML_PARSER_KEY);
        if (parser != null) {
            itemMetadataWithoutItemDef = parser.parse((Map<String, Object>)itemMetadataWithoutItemDef);
            try {
                itemMetadataWithoutItemDef = (Map)Tasks.resolveDeepValueWithoutCoercion(itemMetadataWithoutItemDef, this.mgmt.getServerExecutionContext());
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else if (!WARNED_RE_DSL_PARSER) {
            log.warn("No Camp-YAML parser registered for parsing catalog item DSL; skipping DSL-parsing (no further warnings)");
            WARNED_RE_DSL_PARSER = true;
        }
        MutableMap catalogMetadata = MutableMap.builder().putAll(parentMetadata).putAll((Map)itemMetadataWithoutItemDef).putIfNotNull((Object)"item", itemMetadata.get("item")).putIfNotNull((Object)"items", itemMetadata.get("items")).build();
        catalogMetadata.put("tags", MutableSet.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(parentMetadata, Collection.class, "tags", new String[0]).orNull())).putAll((Iterable)BasicBrooklynCatalog.getFirstAs(itemMetadataWithoutItemDef, Collection.class, "tags", new String[0]).orNull()));
        MutableList librariesAddedHereNames = MutableList.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(itemMetadataWithoutItemDef, List.class, "brooklyn.libraries", new String[]{"libraries"}).orNull()));
        Collection<CatalogItem.CatalogBundle> librariesAddedHereBundles = CatalogItemDtoAbstract.parseLibraries(librariesAddedHereNames);
        MutableSet librariesCombinedNames = MutableSet.of();
        if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, containingBundle)) {
            librariesCombinedNames.add((Object)containingBundle.getVersionedName().toOsgiString());
        }
        librariesCombinedNames.putAll((Iterable)librariesAddedHereNames);
        librariesCombinedNames.putAll((Iterable)BasicBrooklynCatalog.getFirstAs(parentMetadata, Collection.class, "brooklyn.libraries", "libraries").orNull());
        if (!librariesCombinedNames.isEmpty()) {
            catalogMetadata.put("brooklyn.libraries", librariesCombinedNames);
        }
        Collection<CatalogItem.CatalogBundle> libraryBundles = CatalogItemDtoAbstract.parseLibraries(librariesCombinedNames);
        CatalogUtils.installLibraries(this.mgmt, librariesAddedHereBundles);
        librariesAddedHereBundles = BasicBrooklynCatalog.resolveWherePossible(this.mgmt, librariesAddedHereBundles);
        libraryBundles = BasicBrooklynCatalog.resolveWherePossible(this.mgmt, libraryBundles);
        Boolean scanJavaAnnotations = (Boolean)BasicBrooklynCatalog.getFirstAs(itemMetadataWithoutItemDef, Boolean.class, "scanJavaAnnotations", new String[]{"scan_java_annotations"}).orNull();
        if (scanJavaAnnotations != null && scanJavaAnnotations.booleanValue()) {
            this.addLegacyScannedAnnotations(containingBundle, resultLegacyFormat, resultNewFormat, depth, (Map<Object, Object>)catalogMetadata, librariesAddedHereBundles, libraryBundles);
        }
        Object items = catalogMetadata.remove("items");
        Object item = catalogMetadata.remove("item");
        Object url = catalogMetadata.remove("include");
        if (items != null) {
            int count = 0;
            for (Object ii : this.checkType(items, "items", List.class)) {
                if (ii instanceof String) {
                    this.collectUrlReferencedCatalogItems((String)ii, containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, (Map<Object, Object>)catalogMetadata, depth + 1, force, throwOnError);
                } else {
                    Map i = this.checkType(ii, "entry in items list", Map.class);
                    this.collectCatalogItemsFromItemMetadataBlock(Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"items", count}).getMatchedYamlTextOrWarn(), containingBundle, i, resultLegacyFormat, resultNewFormat, requireValidation, (Map<?, ?>)catalogMetadata, depth + 1, force, throwOnError);
                }
                ++count;
            }
        }
        if (url != null) {
            this.collectUrlReferencedCatalogItems(this.checkType(url, "include in catalog meta", String.class), containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, (Map<Object, Object>)catalogMetadata, depth + 1, force, throwOnError);
        }
        if (item == null) {
            return;
        }
        String itemYaml = Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"item"}).getMatchedYamlTextOrWarn();
        sourceYaml = itemYaml != null ? itemYaml : new Yaml().dump(item);
        CatalogItem.CatalogItemType itemType = TypeCoercions.coerce(BasicBrooklynCatalog.getFirstAs(catalogMetadata, Object.class, "itemType", new String[]{"item_type"}).orNull(), CatalogItem.CatalogItemType.class);
        String id = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "id", new String[0]).orNull();
        String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
        if (log.isTraceEnabled()) {
            log.trace("Installing " + id + ":" + version);
        }
        if (parentMetadata.containsKey("version") && !Objects.equal(parentMetadata.get("version"), (Object)version)) {
            log.warn("Bundle " + containingBundle + " declares version " + version + " for items overriding broader version " + parentMetadata.get("version"));
        } else if (!parentMetadata.containsKey("version") && containingBundle != null && version != null && !Objects.equal((Object)new VersionedName("x", version).getOsgiVersionString(), (Object)containingBundle.getVersionedName().getOsgiVersionString())) {
            log.warn("Bundle " + containingBundle + " declares items at different version " + version);
        }
        String symbolicName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "symbolicName", new String[0]).orNull();
        String displayName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "displayName", new String[0]).orNull();
        String name = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "name", new String[0]).orNull();
        String format = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "format", new String[0]).orNull();
        if ("auto".equalsIgnoreCase(format)) {
            format = null;
        }
        if ((Strings.isNonBlank((CharSequence)id) || Strings.isNonBlank((CharSequence)symbolicName)) && Strings.isNonBlank((CharSequence)displayName) && Strings.isNonBlank((CharSequence)name) && !name.equals(displayName)) {
            log.warn("Name property will be ignored due to the existence of displayName and at least one of id, symbolicName");
        }
        CharSequence loggedId = Strings.firstNonBlank((CharSequence[])new String[]{id, symbolicName, displayName, "<unidentified>"});
        log.debug("Analyzing item " + loggedId + " for addition to catalog");
        RuntimeException resolutionError = null;
        String string = itemAsString = item instanceof String ? (String)item : null;
        if (itemAsString != null && itemAsString.matches("[A-Za-z0-9]+:[^\\s]+")) {
            BrooklynClassLoadingContext loader = this.getClassLoadingContext("catalog item url loader", parentMetadata, libraryBundles);
            log.debug("Catalog load, loading referenced item at " + item + " for " + loggedId + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + " (" + (resultNewFormat != null ? Integer.valueOf(resultNewFormat.size()) : (resultLegacyFormat != null ? Integer.valueOf(resultLegacyFormat.size()) : "(unknown)")) + " items before load)");
            if (itemAsString.startsWith("http")) {
                log.info("Loading external referenced item at " + item + " for " + loggedId + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()));
            }
            try {
                sourceYaml = ResourceUtils.create(loader).getResourceAsString(itemAsString.trim());
                item = Yamls.parseAll((String)sourceYaml).iterator().next();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                resolutionError = new IllegalStateException("Unable to load '" + itemAsString + "' as URL", e);
            }
        }
        PlanInterpreterInferringType planInterpreter = new PlanInterpreterInferringType(id, item, sourceYaml, itemType, format, (OsgiBundleWithUrl)containingBundle, libraryBundles, null, resultLegacyFormat);
        Map<?, ?> itemAsMap = planInterpreter.getItem();
        if (Strings.isBlank((CharSequence)symbolicName)) {
            if (Strings.isNonBlank((CharSequence)id)) {
                if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(id)) {
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                } else if (RegisteredTypeNaming.isValidOsgiTypeColonVersion(id)) {
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                    log.warn("Discouraged version syntax in id '" + id + "'; version should comply with brooklyn recommendation (#.#.#-qualifier or portion) or specify symbolic name and version explicitly, not OSGi version syntax");
                } else if (CatalogUtils.looksLikeVersionedId(id)) {
                    log.warn("Discouraged version syntax in id '" + id + "'; version should comply with brooklyn recommendation (#.#.#-qualifier or portion) or specify symbolic name and version explicitly");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                } else if (RegisteredTypeNaming.isUsableTypeColonVersion(id)) {
                    log.warn("Deprecated type naming syntax in id '" + id + "'; colons not allowed in type name as it is used to indicate version");
                    symbolicName = id;
                } else {
                    symbolicName = id;
                }
            } else if (Strings.isNonBlank((CharSequence)name)) {
                if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(name) || RegisteredTypeNaming.isValidOsgiTypeColonVersion(name)) {
                    log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(name);
                } else if (CatalogUtils.looksLikeVersionedId(name)) {
                    log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(name);
                } else if (RegisteredTypeNaming.isUsableTypeColonVersion(name)) {
                    log.warn("Deprecated type naming syntax in id '" + id + "'; colons not allowed in type name as it is used to indicate version");
                    symbolicName = name;
                } else {
                    symbolicName = name;
                }
            } else {
                symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "id");
                symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "name");
                if (Strings.isBlank((CharSequence)(symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "template_name")))) {
                    log.error("Can't infer catalog item symbolicName from the following plan:\n" + Sanitizer.sanitizeJsonTypes(sourceYaml));
                    throw new IllegalStateException("Can't infer catalog item symbolicName from catalog item metadata");
                }
            }
        }
        String versionFromId = null;
        if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(id)) {
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
        } else if (RegisteredTypeNaming.isValidOsgiTypeColonVersion(id)) {
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
            log.warn("Discouraged version syntax in id '" + id + "'; version should comply with Brooklyn recommended version syntax (#.#.#-qualifier or portion) or specify symbolic name and version explicitly, not OSGi");
        } else if (CatalogUtils.looksLikeVersionedId(id)) {
            log.warn("Discouraged version syntax in id '" + id + "'; version should comply with Brooklyn recommended version syntax (#.#.#-qualifier or portion) or specify symbolic name and version explicitly");
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
        } else if (RegisteredTypeNaming.isUsableTypeColonVersion(id)) {
            // empty if block
        }
        if (versionFromId != null) {
            if (Strings.isNonBlank((CharSequence)version) && !versionFromId.equals(version)) {
                throw new IllegalArgumentException("Discrepancy between version set in id " + versionFromId + " and version property " + version);
            }
            version = versionFromId;
        }
        if (Strings.isBlank((CharSequence)version)) {
            if (CatalogUtils.looksLikeVersionedId(name)) {
                log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                version = CatalogUtils.getVersionFromVersionedId(name);
            }
            if (Strings.isBlank((CharSequence)version)) {
                version = this.setFromItemIfUnset(version, itemAsMap, "version");
                if (Strings.isBlank((CharSequence)(version = this.setFromItemIfUnset(version, itemAsMap, "template_version")))) {
                    if (log.isTraceEnabled()) {
                        log.trace("No version specified for catalog item " + symbolicName + " or BOM ancestors. Using default/bundle value.");
                    }
                    version = null;
                }
            }
        }
        if (Strings.isBlank((CharSequence)id)) {
            if (Strings.isNonBlank((CharSequence)symbolicName) && Strings.isNonBlank((CharSequence)version)) {
                id = symbolicName + ":" + version;
            }
            if (Strings.isBlank((CharSequence)(id = this.setFromItemIfUnset(id, itemAsMap, "id")))) {
                if (Strings.isNonBlank((CharSequence)symbolicName)) {
                    id = symbolicName;
                } else {
                    log.error("Can't infer catalog item id from the following plan:\n" + Sanitizer.sanitizeJsonTypes(sourceYaml));
                    throw new IllegalStateException("Can't infer catalog item id from catalog item metadata");
                }
            }
        }
        if (Strings.isBlank((CharSequence)displayName)) {
            if (Strings.isNonBlank((CharSequence)name)) {
                displayName = name;
            }
            displayName = this.setFromItemIfUnset(displayName, itemAsMap, "name");
        }
        String description = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "description", new String[0]).orNull();
        description = this.setFromItemIfUnset(description, itemAsMap, "description");
        String catalogIconUrl = null;
        catalogIconUrl = this.setFromItemIfUnset(catalogIconUrl, itemMetadata, "iconUrl", "icon_url", "icon.url");
        catalogIconUrl = this.setFromItemIfUnset(catalogIconUrl, itemAsMap, "iconUrl", "icon_url", "icon.url");
        catalogIconUrl = this.setFromItemIfUnset(catalogIconUrl, (Map<?, ?>)catalogMetadata, "iconUrl", "icon_url", "icon.url");
        String deprecated = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "deprecated", new String[0]).orNull();
        Boolean catalogDeprecated = Boolean.valueOf(this.setFromItemIfUnset(deprecated, itemAsMap, "deprecated"));
        planInterpreter.resolve();
        if (!planInterpreter.isResolved()) {
            resolutionError = Exceptions.create((String)("Could not resolve definition of item" + (Strings.isNonBlank((CharSequence)id) ? " '" + id + "'" : (Strings.isNonBlank((CharSequence)symbolicName) ? " '" + symbolicName + "'" : (Strings.isNonBlank((CharSequence)name) ? " '" + name + "'" : "")))), (Iterable)MutableList.of().appendIfNotNull((Object)resolutionError).appendAll(planInterpreter.getErrors()));
        }
        itemType = planInterpreter.getCatalogItemType();
        if (!Objects.equal((Object)id, (Object)planInterpreter.itemId)) {
            planInterpreter.setId(id).resolve();
            if (resolutionError == null && !planInterpreter.isResolved()) {
                resolutionError = new IllegalStateException("Plan resolution for " + id + " breaks after id and itemType are set; is there a recursive reference or other type inconsistency?\n" + sourceYaml);
            }
        }
        if (throwOnError.booleanValue() && resolutionError != null) {
            throw Exceptions.propagate((Throwable)resolutionError);
        }
        String sourcePlanYaml = planInterpreter.getPlanYaml();
        if (resultLegacyFormat == null) {
            MutableSet tags = MutableSet.of().putAll((Iterable)BasicBrooklynCatalog.getFirstAs(catalogMetadata, Collection.class, "tags", new String[0]).orNull());
            MutableList aliases = MutableList.of();
            Boolean catalogDisabled = null;
            MutableList superTypes = MutableList.of();
            if (itemType == CatalogItem.CatalogItemType.TEMPLATE) {
                tags.add(BrooklynTags.CATALOG_TEMPLATE);
                itemType = CatalogItem.CatalogItemType.APPLICATION;
            }
            if (itemType == CatalogItem.CatalogItemType.APPLICATION) {
                itemType = CatalogItem.CatalogItemType.ENTITY;
                superTypes.add(Application.class);
            }
            if (resolutionError != null && !tags.contains(BrooklynTags.CATALOG_TEMPLATE)) {
                if (requireValidation) {
                    throw Exceptions.propagate((Throwable)resolutionError);
                }
                planInterpreter.checkResolution(true);
            }
            if (itemType != null) {
                superTypes.appendIfNotNull((Object)BrooklynObjectType.of((CatalogItem.CatalogItemType)itemType).getInterfaceType());
            }
            if (version == null) {
                if (containingBundle != null) {
                    version = containingBundle.getVersionedName().getVersionString();
                }
                if (version == null) {
                    log.debug("No version specified for catalog item " + symbolicName + " or BOM ancestors and not available from bundle. Using default value " + NO_VERSION + ".");
                    version = NO_VERSION;
                }
            }
            if (sourcePlanYaml == null) {
                sourcePlanYaml = planInterpreter.itemYaml;
            }
            MutableSet searchBundles = MutableSet.of().putIfNotNull((Object)containingBundle).putAll(libraryBundles);
            BasicRegisteredType type = this.createYetUnsavedRegisteredTypeInstance(BrooklynObjectType.of((CatalogItem.CatalogItemType)planInterpreter.catalogItemType).getSpecType() != null ? BrooklynTypeRegistry.RegisteredTypeKind.SPEC : (planInterpreter.catalogItemType == CatalogItem.CatalogItemType.BEAN ? BrooklynTypeRegistry.RegisteredTypeKind.BEAN : BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED), symbolicName, version, containingBundle, (Collection<OsgiBundleWithUrl>)searchBundles, displayName, description, catalogIconUrl, catalogDeprecated, sourcePlanYaml, (Set<Object>)tags, (List<String>)aliases, catalogDisabled, (MutableList<Object>)superTypes, format);
            RegisteredTypes.notePlanEquivalentToThis(type, new BasicTypeImplementationPlan(format, sourceYaml));
            RegisteredType replacedInstance = this.mgmt.getTypeRegistry().get(type.getSymbolicName(), type.getVersion());
            log.debug("Analyzed " + loggedId + " as " + type + " (" + Strings.firstNonNull((Object[])new Object[]{planInterpreter.catalogItemType, "unresolved"}) + "), adding to type registry " + (planInterpreter.catalogItemType == null ? "(despite errors at this stage, " + planInterpreter.getErrors().stream().findFirst().orElse(null) + "; may be resolved later once other items are added, or may fail later)" : "(will re-resolve as registered type later)"));
            ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).addToLocalUnpersistedTypeRegistry(type, force);
            this.updateResultNewFormat(resultNewFormat, replacedInstance, type);
        } else {
            Object dto = BasicBrooklynCatalog.createItemBuilder(itemType, symbolicName, version).libraries(libraryBundles).displayName(displayName).description(description).deprecated(catalogDeprecated).iconUrl(catalogIconUrl).plan(sourcePlanYaml).build();
            ((AbstractBrooklynObject)dto).setManagementContext((ManagementContextInternal)this.mgmt);
            log.debug("Analyzed " + loggedId + " as " + dto + " (" + planInterpreter.catalogItemType + "), adding to legacy catalog");
            resultLegacyFormat.add((CatalogItemDtoAbstract<?, ?>)dto);
        }
    }

    private BasicRegisteredType createYetUnsavedRegisteredTypeInstance(BrooklynTypeRegistry.RegisteredTypeKind kind, String symbolicName, String version, ManagedBundle containingBundle, Collection<OsgiBundleWithUrl> libraryBundles, String displayName, String description, String catalogIconUrl, Boolean catalogDeprecated, String sourcePlanYaml, Set<Object> tags, List<String> aliases, Boolean catalogDisabled, MutableList<Object> superTypes, String format) {
        BasicTypeImplementationPlan plan = new BasicTypeImplementationPlan(format, sourcePlanYaml);
        BasicRegisteredType type = (BasicRegisteredType)RegisteredTypes.newInstance(kind, symbolicName, version, plan, superTypes, aliases, tags, containingBundle == null ? null : containingBundle.getVersionedName().toString(), (Iterable<OsgiBundleWithUrl>)MutableList.copyOf(libraryBundles), displayName, description, catalogIconUrl, catalogDeprecated, catalogDisabled);
        RegisteredTypes.notePlanEquivalentToThis(type, plan);
        return type;
    }

    private void addLegacyScannedAnnotations(ManagedBundle containingBundle, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, int depth, Map<Object, Object> catalogMetadata, Collection<CatalogItem.CatalogBundle> librariesAddedHereBundles, Collection<CatalogItem.CatalogBundle> libraryBundles) {
        log.warn("Deprecated use of scanJavaAnnotations" + (containingBundle != null ? " in bundle " + containingBundle.getVersionedName() : ""));
        if (BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, containingBundle)) {
            Collection<CatalogItemDtoAbstract<?, ?>> scanResult;
            if (BasicBrooklynCatalog.isLibrariesMoreThanJustContainingBundle(librariesAddedHereBundles, containingBundle)) {
                log.warn("Deprecated use of scanJavaAnnotations to scan other libraries (" + librariesAddedHereBundles + "); libraries should declare they scan themselves");
                scanResult = this.scanAnnotationsLegacyInListOfLibraries(this.mgmt, librariesAddedHereBundles, catalogMetadata, containingBundle);
            } else if (!BasicBrooklynCatalog.isLibrariesMoreThanJustContainingBundle(libraryBundles, containingBundle)) {
                if (containingBundle != null && !containingBundle.getSymbolicName().contains("brooklyn-default-catalog")) {
                    log.warn("Deprecated use of scanJavaAnnotations in non-Java BOM outwith the default catalog setup");
                } else if (depth > 0) {
                    log.warn("Deprecated use of scanJavaAnnotations declared in item; should be declared at the top level of the BOM");
                }
                scanResult = this.scanAnnotationsFromLocalNonBundleClasspath(this.mgmt, catalogMetadata, containingBundle);
            } else {
                throw new IllegalStateException("Cannot scan for Java catalog items when libraries declared on an ancestor; scanJavaAnnotations should be specified alongside brooklyn.libraries (or ideally those libraries should specify to scan)");
            }
            if (scanResult != null && !scanResult.isEmpty()) {
                if (resultLegacyFormat != null) {
                    resultLegacyFormat.addAll(scanResult);
                } else {
                    for (CatalogItem catalogItem : scanResult) {
                        RegisteredType replacedInstance = this.mgmt.getTypeRegistry().get(catalogItem.getSymbolicName(), catalogItem.getVersion());
                        this.mgmt.getCatalog().addItem(catalogItem);
                        RegisteredType newInstance = this.mgmt.getTypeRegistry().get(catalogItem.getSymbolicName(), catalogItem.getVersion());
                        this.updateResultNewFormat(resultNewFormat, replacedInstance, newInstance);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Scanning for Java annotations is not supported in BOMs in bundles; entries should be listed explicitly in the catalog.bom");
        }
    }

    private void updateResultNewFormat(Map<RegisteredType, RegisteredType> resultNewFormat, RegisteredType replacedInstance, RegisteredType newInstance) {
        if (resultNewFormat != null) {
            if (resultNewFormat.containsKey(newInstance)) {
                log.debug("Multiple definitions for " + newInstance + " in BOM; only recording one");
            } else {
                if (resultNewFormat.containsKey(replacedInstance)) {
                    throw new IllegalArgumentException("Cannot define two different items with the same name in a bundle: " + replacedInstance + " and " + newInstance);
                }
                resultNewFormat.put(newInstance, replacedInstance);
            }
        }
    }

    protected static Collection<CatalogItem.CatalogBundle> resolveWherePossible(ManagementContext mgmt, Collection<CatalogItem.CatalogBundle> libraryBundles) {
        MutableSet libraryBundlesResolved = MutableSet.of();
        for (CatalogItem.CatalogBundle b : libraryBundles) {
            libraryBundlesResolved.add(CatalogBundleDto.resolve(mgmt, b).or((Object)b));
        }
        return libraryBundlesResolved;
    }

    private static boolean isLibrariesMoreThanJustContainingBundle(Collection<CatalogItem.CatalogBundle> library, ManagedBundle containingBundle) {
        if (library == null || library.isEmpty()) {
            return false;
        }
        if (containingBundle == null) {
            return !library.isEmpty();
        }
        if (library.size() > 1) {
            return true;
        }
        CatalogItem.CatalogBundle li = (CatalogItem.CatalogBundle)Iterables.getOnlyElement(library);
        return !containingBundle.getVersionedName().equalsOsgi((Object)li.getVersionedName());
    }

    @Beta
    public static boolean isNoBundleOrSimpleWrappingBundle(ManagementContext mgmt, ManagedBundle b) {
        if (b == null) {
            return true;
        }
        Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
        if (osgi.isAbsent()) {
            throw new IllegalStateException("OSGi not being used but installing a bundle");
        }
        Maybe<Bundle> bb = ((OsgiManager)osgi.get()).findBundle((OsgiBundleWithUrl)b);
        if (bb.isAbsent()) {
            throw new IllegalStateException("Loading from a bundle which is not installed");
        }
        return BasicBrooklynCatalog.isWrapperBundle((Bundle)bb.get());
    }

    @Beta
    public static boolean isWrapperBundle(Bundle b) {
        String wrapped = (String)b.getHeaders().get(BROOKLYN_WRAPPED_BOM_BUNDLE);
        return wrapped != null && wrapped.equalsIgnoreCase("true");
    }

    private void collectUrlReferencedCatalogItems(String url, ManagedBundle containingBundle, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<Object, Object> parentMeta, int depth, boolean force, Boolean throwOnError) {
        String yaml;
        log.debug("Catalog load, loading referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + " (" + (resultNewFormat != null ? Integer.valueOf(resultNewFormat.size()) : (resultLegacyFormat != null ? Integer.valueOf(resultLegacyFormat.size()) : "(unknown)")) + " items before load)");
        BrooklynClassLoadingContext loader = this.getClassLoadingContext("catalog url reference loader", parentMeta, null);
        if (url.startsWith("http")) {
            log.info("Loading external referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()));
        }
        try {
            yaml = ResourceUtils.create(loader).getResourceAsString(url);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Remote catalog url " + url + " in " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + " can't be fetched.", e);
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("Loaded yaml for " + containingBundle + " from " + url + ":\n" + yaml);
            }
            this.collectCatalogItemsFromCatalogBomRoot("BOM expected at " + url, yaml, containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, parentMeta, depth, force, throwOnError);
        }
        catch (Exception e) {
            Exceptions.propagateAnnotated((String)("Error loading " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName())), (Throwable)e);
        }
        log.debug("Catalog load, loaded referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + ", now have " + (resultNewFormat != null ? Integer.valueOf(resultNewFormat.size()) : (resultLegacyFormat != null ? Integer.valueOf(resultLegacyFormat.size()) : "(unknown)")) + " items");
    }

    private BrooklynClassLoadingContext getClassLoadingContext(String summary, Map<?, ?> parentMeta, Collection<CatalogItem.CatalogBundle> libraries) {
        MutableSet parentLibraries = MutableSet.of();
        if (parentMeta != null) {
            MutableList parentLibrariesRaw = MutableList.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(parentMeta, Iterable.class, "brooklyn.libraries", "libraries").orNull()));
            parentLibraries.addAll(CatalogItemDtoAbstract.parseLibraries(parentLibrariesRaw));
        }
        if (libraries != null) {
            parentLibraries.addAll(libraries);
        }
        return CatalogUtils.newClassLoadingContext(this.mgmt, "<" + summary + ">:0.0.0", (Collection<? extends OsgiBundleWithUrl>)parentLibraries);
    }

    private <T> T checkType(Object x, String description, Class<T> type) {
        if (type.isInstance(x)) {
            return (T)x;
        }
        throw new UserFacingException("Expected " + JavaClassNames.superSimpleClassName(type) + " for " + description + ", not " + JavaClassNames.superSimpleClassName((Object)x));
    }

    private String setFromItemIfUnset(String oldValue, Map<?, ?> item, String ... fieldAttrs) {
        if (Strings.isNonBlank((CharSequence)oldValue)) {
            return oldValue;
        }
        if (item != null) {
            for (String fieldAttr : fieldAttrs) {
                Object newValue = item.get(fieldAttr);
                if (newValue instanceof String && Strings.isNonBlank((CharSequence)((String)newValue))) {
                    return (String)newValue;
                }
                if (!(newValue instanceof Number) && !(newValue instanceof Boolean)) continue;
                return newValue.toString();
            }
        }
        return oldValue;
    }

    @Deprecated
    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsFromLocalNonBundleClasspath(ManagementContext mgmt, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Local Scanned Catalog", "All annotated Brooklyn entities detected in the classpath", "scanning-local-classpath");
        return this.scanAnnotationsInternal(mgmt, new CatalogDo(dto), catalogMetadata, containingBundle);
    }

    @Deprecated
    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsLegacyInListOfLibraries(ManagementContext mgmt, Collection<? extends OsgiBundleWithUrl> libraries, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Bundles Scanned Catalog", "All annotated Brooklyn entities detected in bundles", "scanning-bundles-classpath-" + libraries.hashCode());
        MutableList urls = MutableList.of();
        for (OsgiBundleWithUrl osgiBundleWithUrl : libraries) {
            if (Strings.isNonBlank((CharSequence)osgiBundleWithUrl.getUrl())) {
                urls.add(osgiBundleWithUrl.getUrl());
                continue;
            }
            log.warn("scanJavaAnnotations does not apply to pre-installed bundles; skipping " + osgiBundleWithUrl);
        }
        if (urls.isEmpty()) {
            log.warn("No bundles to scan: scanJavaAnnotations currently only applies to OSGi bundles provided by URL");
            return MutableList.of();
        }
        CatalogDo subCatalog = new CatalogDo(dto);
        subCatalog.addToClasspath(urls.toArray(new String[0]));
        return this.scanAnnotationsInternal(mgmt, subCatalog, catalogMetadata, containingBundle);
    }

    @Deprecated
    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsInBundle(ManagementContext mgmt, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Bundle " + containingBundle.getVersionedName().toOsgiString() + " Scanned Catalog", "All annotated Brooklyn entities detected in bundles", "scanning-bundle-" + containingBundle.getVersionedName().toOsgiString());
        CatalogDo subCatalog = new CatalogDo(dto);
        String url = null;
        File f = ((OsgiManager)((ManagementContextInternal)mgmt).getOsgiManager().get()).getBundleFile(containingBundle);
        if (f != null) {
            url = "file//:" + f.getAbsolutePath();
        }
        if (url == null) {
            url = containingBundle.getUrl();
        }
        if (url == null) {
            throw new IllegalArgumentException("Error preparing to scan " + containingBundle.getVersionedName() + ": no URL available");
        }
        File fJar = Os.newTempFile((String)containingBundle.getVersionedName().toOsgiString(), (String)".jar");
        try {
            Collection<CatalogItemDtoAbstract<?, ?>> result;
            Streams.copy((InputStream)ResourceUtils.create(mgmt).getResourceFromUrl(url), (OutputStream)new FileOutputStream(fJar));
            subCatalog.addToClasspath("file:" + fJar.getAbsolutePath());
            Collection<CatalogItemDtoAbstract<?, ?>> collection = result = this.scanAnnotationsInternal(mgmt, subCatalog, (Map<?, ?>)MutableMap.of((Object)"version", (Object)containingBundle.getSuppliedVersionString()), containingBundle);
            return collection;
        }
        catch (FileNotFoundException e) {
            throw Exceptions.propagateAnnotated((String)("Error extracting " + url + " to scan " + containingBundle.getVersionedName()), (Throwable)e);
        }
        finally {
            fJar.delete();
        }
    }

    @Deprecated
    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsInternal(ManagementContext mgmt, CatalogDo subCatalog, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        subCatalog.mgmt = mgmt;
        subCatalog.setClasspathScanForEntities(CatalogClasspathDo.CatalogScanningModes.ANNOTATIONS);
        subCatalog.load();
        Collection result = Collections2.transform(subCatalog.getIdCache().values(), BasicBrooklynCatalog.itemDoToDtoAddingSelectedMetadataDuringScan(mgmt, catalogMetadata, containingBundle));
        return result;
    }

    private static boolean isDubiousBeanType(Object t) {
        return t instanceof Map || t instanceof Collection || t instanceof BrooklynObject && !(t instanceof Feed) || t instanceof AbstractBrooklynObjectSpec;
    }

    private String makeAsIndentedList(String yaml) {
        Object[] lines = yaml.split("\n");
        lines[0] = "- " + lines[0];
        for (int i = 1; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    private String makeAsIndentedObject(String yaml) {
        Object[] lines = yaml.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    static CatalogItemBuilder<?> createItemBuilder(CatalogItem.CatalogItemType itemType, String symbolicName, String version) {
        return CatalogItemBuilder.newItem(itemType, symbolicName, version);
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml) {
        return this.addItems(yaml, true, false);
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, boolean validate, boolean forceUpdate) {
        Maybe<OsgiManager> osgiManager = ((ManagementContextInternal)this.mgmt).getOsgiManager();
        if (osgiManager.isPresent()) {
            OsgiBundleInstallationResult result = this.addItemsOsgi(yaml, forceUpdate, (OsgiManager)osgiManager.get());
            return this.toLegacyCatalogItems(result.getTypesInstalled());
        }
        return this.addItems(yaml, null, forceUpdate);
    }

    public OsgiBundleInstallationResult addItemsBundleResult(String yaml, boolean forceUpdate) {
        Maybe<OsgiManager> osgiManager = ((ManagementContextInternal)this.mgmt).getOsgiManager();
        if (osgiManager.isPresent()) {
            return this.addItemsOsgi(yaml, forceUpdate, (OsgiManager)osgiManager.get());
        }
        Iterable items = this.addItems(yaml, null, forceUpdate);
        OsgiBundleInstallationResult result = new OsgiBundleInstallationResult();
        for (CatalogItem ci : items) {
            RegisteredType rt = this.mgmt.getTypeRegistry().get(ci.getId());
            result.getTypesInstalled().add(rt != null ? rt : RegisteredTypes.of(ci));
        }
        return result;
    }

    protected OsgiBundleInstallationResult addItemsOsgi(String yaml, boolean forceUpdate, OsgiManager osgiManager) {
        return (OsgiBundleInstallationResult)osgiManager.install((Supplier<InputStream>)InputStreamSource.of((String)"addItemsOsgi supplied yaml", (byte[])yaml.getBytes()), "brooklyn-bom-yaml", forceUpdate).get();
    }

    private List<CatalogItem<?, ?>> toLegacyCatalogItems(Iterable<RegisteredType> list) {
        MutableList result = MutableList.of();
        for (RegisteredType t : list) {
            String id = t.getId();
            CatalogItem<?, ?> item = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, id);
            if (item == null) {
                result.add(RegisteredTypes.toPartialCatalogItem(this.mgmt.getTypeRegistry().get(id)));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, ManagedBundle bundle, boolean forceUpdate) {
        log.debug("Adding catalog item to " + this.mgmt + ": " + Sanitizer.sanitizeJsonTypes(yaml));
        Preconditions.checkNotNull((Object)yaml, (Object)"yaml");
        MutableList result = MutableList.of();
        this.collectCatalogItemsFromCatalogBomRoot("caller-supplied YAML", yaml, bundle, (List<CatalogItemDtoAbstract<?, ?>>)result, null, true, (Map<?, ?>)ImmutableMap.of(), 0, forceUpdate, true);
        for (CatalogItemDtoAbstract item : result) {
            if (bundle != null && bundle.getVersionedName() != null) {
                item.setContainingBundle(bundle.getVersionedName());
            }
            this.addItemDto(item, forceUpdate);
        }
        MutableMap errors = MutableMap.of();
        for (CatalogItemDtoAbstract item : result) {
            Collection<Throwable> errorsInItem = this.validateType(RegisteredTypes.of(item), null, true);
            if (errorsInItem.isEmpty()) continue;
            errors.put(item.getCatalogItemId(), errorsInItem);
        }
        if (!errors.isEmpty()) {
            log.warn("Error adding YAML" + (bundle != null ? " for bundle " + bundle : "") + " (ignoring, but types will not be usable): " + errors);
        }
        return result;
    }

    @Beta
    public void addTypesFromBundleBom(String yaml, ManagedBundle bundle, boolean forceUpdate, Map<RegisteredType, RegisteredType> result) {
        log.debug("Catalog load, adding registered types to " + this.mgmt + " for bundle " + bundle + ": " + Sanitizer.sanitizeJsonTypes(yaml));
        Preconditions.checkNotNull((Object)yaml, (Object)"yaml");
        if (result == null) {
            result = MutableMap.of();
        }
        this.collectCatalogItemsFromCatalogBomRoot("bundle BOM in " + bundle, yaml, bundle, null, (Map<RegisteredType, RegisteredType>)result, false, (Map<?, ?>)MutableMap.of(), 0, forceUpdate, false);
    }

    @Beta
    public Collection<RegisteredType> addTypesAndValidateAllowInconsistent(String catalogYaml, @Nullable Map<RegisteredType, RegisteredType> result, boolean forceUpdate) {
        Preconditions.checkNotNull((Object)catalogYaml, (Object)"catalogYaml");
        Maybe<OsgiManager> osgiManager = ((ManagementContextInternal)this.mgmt).getOsgiManager();
        if (osgiManager.isPresent()) {
            return this.addItemsOsgi(catalogYaml, forceUpdate, (OsgiManager)osgiManager.get()).getTypesInstalled();
        }
        log.debug("Catalog load, adding registered types to " + this.mgmt + ": " + Sanitizer.sanitizeMultilineString(catalogYaml));
        if (result == null) {
            result = MutableMap.of();
        }
        this.collectCatalogItemsFromCatalogBomRoot("unbundled catalog definition", catalogYaml, null, null, (Map<RegisteredType, RegisteredType>)result, false, (Map<?, ?>)MutableMap.of(), 0, forceUpdate, true);
        Map<RegisteredType, Collection<Throwable>> validation = this.validateTypes(result.keySet());
        if (Iterables.concat(validation.values()).iterator().hasNext()) {
            log.debug("Detail of failed validation:\n" + validation.entrySet().stream().map(en -> "  " + en.getKey() + "\n" + ((Collection)en.getValue()).stream().map(vv -> "    " + Exceptions.collapseText((Throwable)vv)).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n")));
            throw Exceptions.propagate((String)("Could not validate one or more items: " + validation.keySet()), (Iterable)validation.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return result.keySet();
    }

    @Beta
    public Map<RegisteredType, Collection<Throwable>> validateTypes(Iterable<RegisteredType> typesToValidate) {
        return this.validateTypes(typesToValidate, false);
    }

    @Beta
    public Map<RegisteredType, Collection<Throwable>> validateTypes(Iterable<RegisteredType> typesToValidate, boolean skipIfValidated) {
        MutableList typesRemainingToValidate = MutableList.copyOf(typesToValidate);
        if (typesRemainingToValidate.isEmpty()) {
            return MutableMap.of();
        }
        log.debug("Starting validation, " + typesRemainingToValidate.size() + " to validate");
        while (true) {
            MutableMap result = MutableMap.of();
            for (RegisteredType t : typesRemainingToValidate) {
                Collection<Throwable> tr;
                if (skipIfValidated && t.getKind() != null && t.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED || (tr = this.validateType(t, null, true)).isEmpty()) continue;
                result.put(this.mgmt.getTypeRegistry().get(t.getId(), RegisteredTypeLoadingContexts.loader(CatalogUtils.newClassLoadingContext(this.mgmt, t))), tr);
            }
            String msg = typesRemainingToValidate.size() - result.size() + " validated, " + result.size() + " unvalidated";
            if (result.isEmpty() || result.size() == typesRemainingToValidate.size()) {
                log.debug("Finished validation, " + msg);
                return result;
            }
            log.debug("Finished validation cycle, " + msg + "; will re-run");
            typesRemainingToValidate = MutableList.copyOf(result.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public Collection<Throwable> validateType(RegisteredType typeToValidate, RegisteredTypeLoadingContext constraint, boolean allowUnresolved) {
        try {
            currentlyValidatingType.set(typeToValidate);
            ReferenceWithError<RegisteredType> result = this.validateResolve(typeToValidate, constraint, true);
            if (result.hasError()) {
                if (allowUnresolved && RegisteredTypes.isTemplate(typeToValidate)) {
                    Set<Throwable> set = Collections.emptySet();
                    return set;
                }
                if (result.getError() instanceof CompoundRuntimeException) {
                    List list = ((CompoundRuntimeException)result.getError()).getAllCauses();
                    return list;
                }
                Set<Throwable> set = Collections.singleton(result.getError());
                return set;
            }
            ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).addToLocalUnpersistedTypeRegistry((RegisteredType)result.get(), true);
            Set<Throwable> set = Collections.emptySet();
            return set;
        }
        finally {
            currentlyValidatingType.set(null);
        }
    }

    ReferenceWithError<RegisteredType> validateResolve(RegisteredType typeToValidate, RegisteredTypeLoadingContext constraint, boolean allowChangingKind) {
        Object resultO;
        RegisteredType resultT;
        Set supers;
        MutableList guesserErrors;
        Exception beanError;
        Exception specError;
        IllegalStateException inconsistentSuperTypesError;
        block35: {
            inconsistentSuperTypesError = null;
            specError = null;
            beanError = null;
            guesserErrors = MutableList.of();
            supers = typeToValidate.getSuperTypes();
            BrooklynObjectType boType = null;
            for (Object superI : supers) {
                BrooklynObjectType boTypeI = null;
                if (superI instanceof BrooklynObject) {
                    boTypeI = BrooklynObjectType.of((BrooklynObject)((BrooklynObject)superI));
                } else if (superI instanceof Class) {
                    boTypeI = BrooklynObjectType.of((Class)((Class)superI));
                }
                if (boTypeI == null || boTypeI == BrooklynObjectType.UNKNOWN) continue;
                if (boType == null) {
                    boType = boTypeI;
                    continue;
                }
                if (boTypeI == boType) continue;
                inconsistentSuperTypesError = new IllegalStateException("Inconsistent supertypes for " + typeToValidate + "; indicates " + boType + " and " + boTypeI);
            }
            Class superJ = null;
            for (Object superI : supers) {
                if (!(superI instanceof Class)) continue;
                if (superJ == null) {
                    superJ = (Class)superI;
                    continue;
                }
                if (!superJ.isAssignableFrom((Class)superI)) continue;
                superJ = (Class)superI;
            }
            resultT = null;
            boolean recheckNeededBecauseChangedOrUncertain = false;
            resultO = null;
            if (resultO == null && boType != null) {
                try {
                    resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, typeToValidate, allowChangingKind);
                    try {
                        resultO = this.mgmt.getTypeRegistry().createSpec(resultT, constraint, boType.getSpecType());
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        specError = e;
                        resultT = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
            if (resultO == null) {
                try {
                    resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, typeToValidate, allowChangingKind);
                    try {
                        resultO = this.mgmt.getTypeRegistry().createBean(resultT, constraint, superJ);
                        if (resultO instanceof AbstractBrooklynObjectSpec) {
                            resultO = null;
                            throw new IllegalStateException("Dubious resolution of " + typeToValidate + " as " + resultO.getClass().getName() + " (spec not bean)");
                        }
                        if (BasicBrooklynCatalog.isDubiousBeanType(resultO)) {
                            if (typeToValidate.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
                                recheckNeededBecauseChangedOrUncertain = true;
                                resultO = null;
                                throw new IllegalStateException("Dubious resolution of " + typeToValidate + " as " + resultO.getClass().getName() + " " + resultO + "; if this is intended, specify kind as bean");
                            }
                            if (allowChangingKind) {
                                recheckNeededBecauseChangedOrUncertain = true;
                                resultO = null;
                                throw new IllegalStateException("Uncertain resolution of " + typeToValidate + " as " + resultO.getClass().getName() + " " + resultO + "; will try again");
                            }
                        }
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        beanError = e;
                        resultT = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
            if (resultO == null && (constraint == null || constraint.getAlreadyEncounteredTypes().isEmpty())) {
                try {
                    String yaml = RegisteredTypes.getImplementationDataStringForSpec(typeToValidate);
                    log.trace("Validating {}: \n{}", (Object)typeToValidate, (Object)yaml);
                    CatalogItem.CatalogBundle bundle = typeToValidate.getContainingBundle() != null ? CatalogItemDtoAbstract.parseLibraries(Arrays.asList(typeToValidate.getContainingBundle())).iterator().next() : null;
                    CatalogItem.CatalogItemType itemType = null;
                    if (!allowChangingKind) {
                        CatalogItem.CatalogItemType catalogItemType = itemType = boType != null ? CatalogItem.CatalogItemType.ofTargetClass((Class)boType.getInterfaceType()) : null;
                        if (itemType == null && typeToValidate.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
                            itemType = CatalogItem.CatalogItemType.BEAN;
                        }
                    }
                    String format = typeToValidate.getPlan().getPlanFormat();
                    PlanInterpreterInferringType guesser = new PlanInterpreterInferringType(typeToValidate.getSymbolicName(), Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)yaml)), yaml, itemType, format, (OsgiBundleWithUrl)bundle, CatalogItemDtoAbstract.parseLibraries(typeToValidate.getLibraries()), constraint, null);
                    guesser.resolve();
                    guesserErrors.addAll(guesser.getErrors());
                    if (guesser.isResolved()) {
                        CatalogItem.CatalogItemType ciType = guesser.getCatalogItemType();
                        log.debug("Validated " + typeToValidate + " as " + ciType);
                        resultT = typeToValidate;
                        if (boType == null && (boType = BrooklynObjectType.of((CatalogItem.CatalogItemType)ciType)) != null && boType.getSpecType() != null) {
                            supers = MutableSet.copyOf((Iterable)supers);
                            supers.add(boType.getInterfaceType());
                            resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, resultT, allowChangingKind);
                            RegisteredTypes.addSuperTypes(resultT, supers);
                            recheckNeededBecauseChangedOrUncertain = true;
                        }
                        if (!Objects.equal((Object)guesser.getPlanYaml(), (Object)yaml)) {
                            RegisteredTypes.changePlanNotingEquivalent(resultT, new BasicTypeImplementationPlan(typeToValidate.getPlan().getPlanFormat(), guesser.getPlanYaml()));
                            recheckNeededBecauseChangedOrUncertain = true;
                        }
                        if (recheckNeededBecauseChangedOrUncertain) {
                            log.debug("Re-resolving " + resultT + " following detection of change");
                            return this.validateResolve(resultT, constraint, false);
                        }
                        if (Objects.equal((Object)boType, (Object)BrooklynObjectType.of((CatalogItem.CatalogItemType)ciType))) {
                            if (specError == null) {
                                throw new IllegalStateException("Guesser resolved but TypeRegistry couldn't create");
                            }
                            break block35;
                        }
                        throw new IllegalStateException("Guesser resolved as " + ciType + " but we expected " + boType);
                    }
                    throw new IllegalStateException("Guesser could not resolve " + typeToValidate);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    guesserErrors.add(e);
                    resultT = null;
                }
            }
        }
        if (resultO != null && resultT != null) {
            if (resultO instanceof BrooklynObject) {
                log.debug("Re-resolving " + resultT + " following detection of bean where spec was expected");
                return this.validateResolve(RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, typeToValidate), constraint, false);
            }
            Class resultS = resultT.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.SPEC ? ((AbstractBrooklynObjectSpec)resultO).getType() : resultO.getClass();
            RegisteredTypes.cacheActualJavaType(resultT, resultS);
            MutableSet newSupers = MutableSet.of();
            newSupers.add(resultS);
            newSupers.addAll(supers);
            newSupers.add(BrooklynObjectType.of(resultO.getClass()).getInterfaceType());
            this.collectSupers((Set<Object>)newSupers);
            RegisteredTypes.addSuperTypes(resultT, (Iterable<? extends Object>)newSupers);
            log.trace("Resolved {} to java {}", (Object)resultT, (Object)resultS);
            return ReferenceWithError.newInstanceWithoutError((Object)resultT);
        }
        MutableList errors = MutableList.of().appendIfNotNull(inconsistentSuperTypesError).appendAll((Iterable)guesserErrors).appendIfNotNull(beanError).appendIfNotNull((Object)specError);
        log.trace("Failure resolving {} (informing caller): {}", (Object)resultT, (Object)errors);
        return ReferenceWithError.newInstanceThrowingError(null, (Throwable)Exceptions.create((String)("Could not resolve " + typeToValidate), (Iterable)errors));
    }

    private void collectSupers(Set<Object> s) {
        LinkedList<Object> remaining = new LinkedList<Object>();
        remaining.addAll(s);
        s.clear();
        while (!remaining.isEmpty()) {
            Object next = remaining.remove();
            if (!(next instanceof Class) || s.contains(next)) continue;
            s.add(next);
            remaining.add(((Class)next).getSuperclass());
            remaining.addAll(Arrays.asList(((Class)next).getInterfaces()));
        }
    }

    private CatalogItem<?, ?> addItemDto(CatalogItemDtoAbstract<?, ?> itemDto, boolean forceUpdate) {
        CatalogItem<?, ?> existingDto = this.checkItemAllowedAndIfSoReturnAnyDuplicate(itemDto, true, forceUpdate);
        if (existingDto != null) {
            log.trace("Using existing duplicate for catalog item {}", (Object)itemDto.getId());
            return existingDto;
        }
        this.specCache.invalidate();
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(itemDto);
        this.getCatalog().addEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence addition: {}", (Object)itemDto.getId());
        }
        this.onAdditionUpdateOtherRegistries(itemDto);
        this.mgmt.getRebindManager().getChangeListener().onManaged(itemDto);
        return itemDto;
    }

    private void onAdditionUpdateOtherRegistries(CatalogItemDtoAbstract<?, ?> itemDto) {
    }

    private CatalogItem<?, ?> checkItemAllowedAndIfSoReturnAnyDuplicate(CatalogItem<?, ?> itemDto, boolean allowDuplicates, boolean forceUpdate) {
        if (forceUpdate) {
            return null;
        }
        if (itemDto.getVersion().contains("SNAPSHOT")) {
            return null;
        }
        CatalogItemDo<?, ?> existingItem = this.getCatalogItemDo(itemDto.getSymbolicName(), itemDto.getVersion());
        if (existingItem == null) {
            return null;
        }
        CatalogItem<?, ?> existingDto = existingItem.getDto();
        if (existingDto.equals(itemDto)) {
            if (allowDuplicates) {
                return existingItem;
            }
            throw new IllegalStateException("Not allowed to update existing catalog entries, even with the same content: " + itemDto.getSymbolicName() + ":" + itemDto.getVersion());
        }
        throw new IllegalStateException("Cannot add " + itemDto.getSymbolicName() + ":" + itemDto.getVersion() + " to catalog; a different definition is already present");
    }

    @Deprecated
    public void addItem(CatalogItem<?, ?> item) {
        this.specCache.invalidate();
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + item);
        Preconditions.checkNotNull(item, (Object)"item");
        CatalogUtils.installLibraries(this.mgmt, item.getLibraries(), false);
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(this.getAbstractCatalogItem(item));
    }

    @Deprecated
    public void addCatalogLegacyItemsOnRebind(Iterable<? extends CatalogItem<?, ?>> items) {
        this.addCatalogLegacyItemsOnRebind(items, true);
    }

    private void addCatalogLegacyItemsOnRebind(Iterable<? extends CatalogItem<?, ?>> items, boolean failOnLoadError) {
        this.specCache.invalidate();
        log.debug("Adding manual catalog items to " + this.mgmt + ": " + items);
        Preconditions.checkNotNull(items, (Object)"item");
        for (CatalogItem<?, ?> item : items) {
            CatalogItemDtoAbstract cdto;
            if (item instanceof CatalogItemDtoAbstract) {
                cdto = (CatalogItemDtoAbstract)item;
            } else if (item instanceof CatalogItemDo && ((CatalogItemDo)item).getDto() instanceof CatalogItemDtoAbstract) {
                cdto = (CatalogItemDtoAbstract)((CatalogItemDo)item).getDto();
            } else {
                throw new IllegalArgumentException("Expected items of type " + CatalogItemDtoAbstract.class.getSimpleName());
            }
            cdto.setManagementContext((ManagementContextInternal)this.mgmt);
            try {
                CatalogUtils.installLibraries(this.mgmt, item.getLibraries());
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (failOnLoadError) {
                    Exceptions.propagateAnnotated((String)("Loading bundles for catalog item " + item.getCatalogItemId() + " failed"), (Throwable)e);
                }
                log.error("Loading bundles for catalog item " + item + " failed: " + e.getMessage(), (Throwable)e);
            }
            this.catalog.addEntry((CatalogItemDtoAbstract)item);
        }
        this.catalog.load(this.mgmt, null, failOnLoadError);
    }

    @Deprecated
    public CatalogItem<?, ?> addItem(Class<?> type) {
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + type);
        Preconditions.checkNotNull(type, (Object)"type");
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsClasses.registerClass(type);
        CatalogItem<?, ?> result = this.manualAdditionsCatalog.classpath.addCatalogEntry(type);
        this.specCache.invalidate();
        return result;
    }

    private synchronized void loadManualAdditionsCatalog() {
        if (this.manualAdditionsCatalog != null) {
            return;
        }
        CatalogDto manualAdditionsCatalogDto = CatalogDto.newNamedInstance("Manual Catalog Additions", "User-additions to the catalog while Brooklyn is running, created " + Time.makeDateString(), "manual-additions");
        CatalogDo manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto);
        if (manualAdditionsCatalog == null) {
            log.warn("Blocking until catalog is loaded before changing it");
            boolean loaded = this.blockIfNotLoaded(Duration.TEN_SECONDS);
            if (!loaded) {
                log.warn("Catalog still not loaded after delay; subsequent operations may fail");
            }
            if ((manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto)) == null) {
                throw new UnsupportedOperationException("Catalogs cannot be added until the base catalog is loaded, and catalog is taking a while to load!");
            }
        }
        log.debug("Creating manual additions catalog for " + this.mgmt + ": " + manualAdditionsCatalog);
        this.manualAdditionsClasses = new LoadedClassLoader();
        ((AggregateClassLoader)manualAdditionsCatalog.classpath.getLocalClassLoader()).addFirst((ClassLoader)this.manualAdditionsClasses);
        this.manualAdditionsCatalog = manualAdditionsCatalog;
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems() {
        MutableMap result = MutableMap.of();
        if (!this.getCatalog().isLoaded()) {
            log.debug("Forcing catalog load on access of catalog items");
            this.load();
        }
        for (RegisteredType rt : this.mgmt.getTypeRegistry().getAll()) {
            result.put(rt.getId(), RegisteredTypes.toPartialCatalogItem(rt));
        }
        result.putAll(this.catalog.getIdCache());
        return result.values();
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItemsLegacy() {
        if (!this.getCatalog().isLoaded()) {
            log.debug("Forcing catalog load on access of catalog items");
            this.load();
        }
        return ImmutableList.copyOf(this.catalog.getIdCache().values());
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems(Predicate<? super CatalogItem<T, SpecT>> filter) {
        Iterable filtered = Iterables.filter(this.getCatalogItems(), filter);
        return Iterables.transform((Iterable)filtered, BasicBrooklynCatalog.itemDoToDto());
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItemsLegacy(Predicate<? super CatalogItem<T, SpecT>> filter) {
        Iterable filtered = Iterables.filter(this.catalog.getIdCache().values(), filter);
        return Iterables.transform((Iterable)filtered, BasicBrooklynCatalog.itemDoToDto());
    }

    private static <T, SpecT> Function<CatalogItem<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDto() {
        return new Function<CatalogItem<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItem<T, SpecT> item) {
                if (!(item instanceof CatalogItemDo)) {
                    return item;
                }
                return ((CatalogItemDo)item).getDto();
            }
        };
    }

    private static <T, SpecT> Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDtoAddingSelectedMetadataDuringScan(final ManagementContext mgmt, final Map<?, ?> catalogMetadata, final ManagedBundle containingBundle) {
        return new Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItemDo<T, SpecT> item) {
                if (item == null) {
                    return null;
                }
                CatalogItemDtoAbstract dto = (CatalogItemDtoAbstract)item.getDto();
                String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
                if (Strings.isNonBlank((CharSequence)version)) {
                    dto.setVersion(version);
                }
                MutableSet libraryBundles = MutableSet.of();
                if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(mgmt, containingBundle)) {
                    libraryBundles.add(new CatalogBundleDto(containingBundle.getSymbolicName(), containingBundle.getSuppliedVersionString(), null));
                }
                libraryBundles.addAll(dto.getLibraries());
                Object librariesInherited = catalogMetadata.get("brooklyn.libraries");
                if (librariesInherited instanceof Collection) {
                    libraryBundles.addAll(BasicBrooklynCatalog.resolveWherePossible(mgmt, CatalogItemDtoAbstract.parseLibraries((Collection)librariesInherited)));
                }
                if ((librariesInherited = catalogMetadata.get("libraries")) instanceof Collection) {
                    log.warn("Legacy 'libraries' encountered; use 'brooklyn.libraries'");
                    libraryBundles.addAll(BasicBrooklynCatalog.resolveWherePossible(mgmt, CatalogItemDtoAbstract.parseLibraries((Collection)librariesInherited)));
                }
                dto.setLibraries((Collection<CatalogItem.CatalogBundle>)libraryBundles);
                if (containingBundle != null && dto.getContainingBundle() == null) {
                    dto.setContainingBundle(containingBundle.getVersionedName());
                }
                dto.setSymbolicName(dto.getJavaType());
                switch (dto.getCatalogItemType()) {
                    case TEMPLATE: 
                    case APPLICATION: 
                    case ENTITY: {
                        dto.setPlanYaml("services: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case POLICY: {
                        dto.setPlanYaml("brooklyn.policies: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case ENRICHER: {
                        dto.setPlanYaml("brooklyn.enrichers: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case LOCATION: {
                        dto.setPlanYaml("brooklyn.locations: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not supported to create a catalog item " + dto.getCatalogItemId() + " from: " + dto.getCatalogItemType());
                    }
                }
                dto.setJavaType(null);
                return dto;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallEmptyWrapperBundles() {
        log.debug("Uninstalling empty wrapper bundles");
        Object object = this.uninstallingEmptyLock;
        synchronized (object) {
            Maybe<OsgiManager> osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager();
            if (osgi.isAbsent()) {
                return;
            }
            for (ManagedBundle b : ((OsgiManager)osgi.get()).getInstalledWrapperBundles()) {
                Iterable<RegisteredType> typesInBundle;
                if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, b) || !Iterables.isEmpty(typesInBundle = ((OsgiManager)osgi.get()).getTypesFromBundle(b.getVersionedName()))) continue;
                log.debug("Uninstalling now-empty BOM wrapper bundle " + b.getVersionedName() + " (" + b.getOsgiUniqueUrl() + ")");
                ((OsgiManager)osgi.get()).uninstallUploadedBundle(b);
            }
        }
    }

    private static class SpecCache {
        private final Map<String, AbstractBrooklynObjectSpec<?, ?>> cache = Collections.synchronizedMap(Maps.newLinkedHashMap());

        private SpecCache() {
        }

        public void invalidate() {
            this.cache.clear();
        }

        public Optional<AbstractBrooklynObjectSpec<?, ?>> getSpec(String itemId) {
            return Optional.fromNullable(this.cache.get(itemId));
        }

        public void addSpec(String itemId, AbstractBrooklynObjectSpec<?, ?> spec) {
            this.cache.put(itemId, spec);
        }
    }

    private class PlanInterpreterInferringType {
        String itemId;
        @Nonnull
        final Map<?, ?> item;
        final String itemYaml;
        final String format;
        final OsgiBundleWithUrl containingBundle;
        final Collection<CatalogItem.CatalogBundle> libraryBundles;
        final List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar;
        RegisteredTypeLoadingContext constraint;
        CatalogItem.CatalogItemType catalogItemType;
        String planYaml;
        boolean resolved = false;
        List<Exception> errors = MutableList.of();
        List<Exception> entityErrors = MutableList.of();
        List<Exception> transformerErrors = MutableList.of();
        boolean suspicionOfABean = false;

        public PlanInterpreterInferringType(String itemId, Object itemDefinitionParsedToStringOrMap, @Nullable String itemYaml, @Nullable CatalogItem.CatalogItemType optionalCiType, String format, OsgiBundleWithUrl containingBundle, Collection<CatalogItem.CatalogBundle> libraryBundles, RegisteredTypeLoadingContext constraint, List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar) {
            this.itemId = itemId;
            this.containingBundle = containingBundle;
            this.constraint = constraint;
            if (itemDefinitionParsedToStringOrMap instanceof String) {
                if (((String)itemDefinitionParsedToStringOrMap).trim().indexOf("\n") < 0) {
                    Object reparsed = null;
                    try {
                        reparsed = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)((String)itemDefinitionParsedToStringOrMap)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (reparsed instanceof Map) {
                        this.item = (Map)reparsed;
                        this.itemYaml = (String)itemDefinitionParsedToStringOrMap;
                    } else {
                        this.item = MutableMap.of((Object)"type", (Object)itemDefinitionParsedToStringOrMap);
                        this.itemYaml = "type: " + itemYaml;
                    }
                } else {
                    this.item = MutableMap.of();
                    this.itemYaml = (String)itemDefinitionParsedToStringOrMap;
                }
            } else if (itemDefinitionParsedToStringOrMap instanceof Map) {
                this.item = (Map)itemDefinitionParsedToStringOrMap;
                this.itemYaml = itemYaml;
            } else {
                throw new IllegalArgumentException("Item definition should be a string or map to use the guesser");
            }
            this.catalogItemType = optionalCiType;
            this.format = format;
            this.libraryBundles = libraryBundles;
            this.itemsDefinedSoFar = itemsDefinedSoFar;
        }

        public void resolve() {
            this.resolveWithoutChecking();
            this.checkResolution(false);
        }

        public void resolveWithoutChecking() {
            try {
                boolean onlyNewStyleTransformer;
                currentlyResolvingType.set(Strings.isBlank((CharSequence)this.itemId) ? this.itemYaml : this.itemId);
                Maybe<Object> transformedResult = this.attemptPlanTransformer();
                boolean bl = onlyNewStyleTransformer = this.format != null || this.catalogItemType == CatalogItem.CatalogItemType.BEAN;
                if (transformedResult.isPresent() || onlyNewStyleTransformer) {
                    this.planYaml = this.itemYaml;
                    boolean bl2 = this.resolved = transformedResult.isPresent() || this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE;
                    if (!this.resolved) {
                        this.errors.add(Maybe.Absent.getException(transformedResult));
                    }
                    if (this.resolved && this.catalogItemType != CatalogItem.CatalogItemType.BEAN && this.catalogItemType != CatalogItem.CatalogItemType.TEMPLATE && (this.format == null || !"brooklyn-camp".equals(this.format))) {
                        this.resolved = false;
                        this.attemptLegacySpecTransformersForVariousSpecTypes();
                    }
                    return;
                }
                this.transformerErrors.add(((Maybe.Absent)transformedResult).getException());
                if (this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE) {
                    this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.TEMPLATE);
                    if (!this.resolved) {
                        this.planYaml = this.itemYaml;
                        this.resolved = true;
                    }
                    return;
                }
                if (this.format == null) {
                    this.attemptLegacySpecTransformersForVariousSpecTypes();
                }
                return;
            }
            finally {
                currentlyResolvingType.remove();
            }
        }

        public void checkResolution(boolean failOnBasicProblems) {
            if (!failOnBasicProblems && !this.isResolved()) {
                return;
            }
            if (this.item != null && CatalogItem.CatalogItemType.ENTITY.equals((Object)this.catalogItemType) && this.item.containsKey("services") && this.item.containsKey("type")) {
                this.resolved = false;
                IllegalArgumentException error = new IllegalArgumentException("Blueprint contains both a 'services' block and a 'type' specification; not permitted");
                if (failOnBasicProblems) {
                    throw error;
                }
                this.errors.add(error);
                return;
            }
        }

        private void attemptLegacySpecTransformersForVariousSpecTypes() {
            this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.ENTITY);
            MutableList oldEntityErrors = MutableList.copyOf(this.entityErrors);
            this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.ENTITY, "services");
            this.entityErrors.removeAll((Collection<?>)oldEntityErrors);
            this.entityErrors.addAll((Collection<Exception>)oldEntityErrors);
            if (!this.item.containsKey("services")) {
                this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.POLICY, BasicBrooklynCatalog.POLICIES_KEY);
                this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.ENRICHER, BasicBrooklynCatalog.ENRICHERS_KEY);
                this.attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType.LOCATION, BasicBrooklynCatalog.LOCATIONS_KEY);
            }
        }

        private Maybe<Object> attemptPlanTransformer() {
            MutableSet exceptions = MutableSet.of();
            try {
                TypeToken clz;
                Object type;
                this.suspicionOfABean = false;
                MutableSet searchBundles = MutableSet.of().putIfNotNull((Object)this.containingBundle).putAll(this.libraryBundles);
                OsgiBrooklynClassLoadingContext loader = new OsgiBrooklynClassLoadingContext(BasicBrooklynCatalog.this.mgmt, null, (Collection<? extends OsgiBundleWithUrl>)searchBundles);
                if (this.catalogItemType == null && (type = this.item.get("type")) instanceof String && (clz = (TypeToken)new BrooklynTypeNameResolution.BrooklynTypeNameResolver((String)type, loader, false, true).findTypeToken((String)type).orNull()) != null && !BrooklynObject.class.isAssignableFrom(TypeTokens.getRawRawType((TypeToken)clz))) {
                    this.suspicionOfABean = true;
                }
                if (this.constraint == null) {
                    this.constraint = RegisteredTypeLoadingContexts.loaderAlreadyEncountered(loader, null, this.itemId);
                } else {
                    this.constraint = RegisteredTypeLoadingContexts.withLoader(this.constraint, loader);
                    this.constraint = RegisteredTypeLoadingContexts.withEncounteredItem(this.constraint, this.itemId);
                }
                Object t = null;
                boolean triedBean = false;
                if (this.catalogItemType == CatalogItem.CatalogItemType.BEAN || this.suspicionOfABean) {
                    try {
                        triedBean = true;
                        t = BasicBrooklynCatalog.this.mgmt.getTypeRegistry().createBeanFromPlan(this.format, (Object)this.itemYaml, this.constraint, null);
                        this.catalogItemType = CatalogItem.CatalogItemType.BEAN;
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        exceptions.add((Object)e);
                    }
                }
                if (this.catalogItemType != CatalogItem.CatalogItemType.BEAN && t == null) {
                    try {
                        t = BasicBrooklynCatalog.this.mgmt.getTypeRegistry().createSpecFromPlan(this.format, (Object)this.itemYaml, this.constraint, BrooklynObjectType.of((CatalogItem.CatalogItemType)this.catalogItemType).getSpecType());
                        if (this.catalogItemType == null) {
                            this.catalogItemType = CatalogItem.CatalogItemType.ofSpecClass((Class)BrooklynObjectType.of(t.getClass()).getSpecType());
                        }
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        exceptions.add((Object)e);
                    }
                }
                if (this.catalogItemType == null && t == null && !triedBean) {
                    try {
                        triedBean = true;
                        t = BasicBrooklynCatalog.this.mgmt.getTypeRegistry().createBeanFromPlan(this.format, (Object)this.itemYaml, this.constraint, null);
                        if (this.format == null && BasicBrooklynCatalog.isDubiousBeanType(t)) {
                            t = null;
                        } else {
                            this.catalogItemType = CatalogItem.CatalogItemType.BEAN;
                        }
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (!exceptions.isEmpty() && Exceptions.getFirstThrowableOfType((Throwable)((Throwable)exceptions.iterator().next()), UnsupportedTypePlanException.class) != null && Exceptions.getFirstThrowableOfType((Throwable)e, UnsupportedTypePlanException.class) == null) {
                            MutableSet e2 = MutableSet.of((Object)e).putAll((Iterable)exceptions);
                            exceptions.clear();
                            exceptions.addAll((Collection)e2);
                        }
                        exceptions.add((Object)e);
                    }
                }
                if (t != null) {
                    this.resolved = true;
                    return Maybe.of((Object)t);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exceptions.add((Object)e);
            }
            if (exceptions.isEmpty()) {
                exceptions.add((Object)new IllegalStateException("Type registry creation returned null"));
            }
            return Maybe.absent(() -> Exceptions.create((String)("Unable to transform definition of " + (this.itemId != null ? this.itemId : "plan:\n" + this.itemYaml + "\n")), (Iterable)exceptions));
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public List<Exception> getErrors() {
            MutableList l = MutableList.copyOf(this.errors);
            if (!this.suspicionOfABean || this.transformerErrors.isEmpty()) {
                l.appendAll(this.entityErrors);
            }
            l.appendAll(this.transformerErrors);
            return l;
        }

        public CatalogItem.CatalogItemType getCatalogItemType() {
            return this.catalogItemType;
        }

        public String getPlanYaml() {
            return this.planYaml;
        }

        private boolean attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType candidateCiType) {
            return this.attemptLegacySpecTransformersForType(candidateCiType, null);
        }

        private boolean attemptLegacySpecTransformersForType(CatalogItem.CatalogItemType candidateCiType, String optionalKeyForModifyingYaml) {
            boolean legacyModeForOriginalBlueprint;
            if (this.resolved) {
                return false;
            }
            if (this.catalogItemType != null && this.catalogItemType != candidateCiType) {
                return false;
            }
            String candidateYamlWithKeyAdded = null;
            if (optionalKeyForModifyingYaml != null) {
                if (this.item.containsKey(optionalKeyForModifyingYaml)) {
                    optionalKeyForModifyingYaml = null;
                    legacyModeForOriginalBlueprint = true;
                } else {
                    candidateYamlWithKeyAdded = optionalKeyForModifyingYaml + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList(this.itemYaml);
                    legacyModeForOriginalBlueprint = false;
                }
            } else {
                legacyModeForOriginalBlueprint = true;
            }
            String type = (String)this.item.get("type");
            if (this.itemsDefinedSoFar != null && type != null && optionalKeyForModifyingYaml != null) {
                for (CatalogItemDtoAbstract<?, ?> candidate : this.itemsDefinedSoFar) {
                    if (candidateCiType != candidate.getCatalogItemType() || !type.equals(candidate.getSymbolicName()) && !type.equals(candidate.getId())) continue;
                    this.catalogItemType = candidateCiType;
                    this.planYaml = candidateYamlWithKeyAdded != null ? candidateYamlWithKeyAdded : this.itemYaml;
                    this.resolved = true;
                    return true;
                }
            }
            if (legacyModeForOriginalBlueprint && this.attemptLegacyTypeInstantiation("legacy", candidateCiType, this.itemYaml, null, type)) {
                return true;
            }
            if (candidateYamlWithKeyAdded != null) {
                MutableList oldEntityErrors = MutableList.copyOf(this.entityErrors);
                this.entityErrors.clear();
                if (this.attemptLegacyTypeInstantiation("legacy with key '" + optionalKeyForModifyingYaml + "'", candidateCiType, candidateYamlWithKeyAdded, optionalKeyForModifyingYaml, type)) {
                    return true;
                }
                this.entityErrors.addAll((Collection<Exception>)oldEntityErrors);
            }
            return false;
        }

        private boolean attemptLegacyTypeInstantiation(String context, CatalogItem.CatalogItemType candidateCiType, String candidateYaml, String optionalKeyForModifyingYaml, String typeIfOptionalKeySupplied) {
            block13: {
                try {
                    Object itemSpecInstantiated = null;
                    if (ATTEMPT_INSTANTIATION_WITH_LEGACY_PLAN_TO_SPEC_CONVERTERS) {
                        Object itemToAttempt = BasicBrooklynCatalog.createItemBuilder(candidateCiType, this.getIdWithRandomDefault(), "0.0.0_DEFAULT_VERSION").plan(candidateYaml).libraries(this.libraryBundles).build();
                        itemSpecInstantiated = BasicBrooklynCatalog.internalCreateSpecLegacy(BasicBrooklynCatalog.this.mgmt, itemToAttempt, (Set<String>)MutableSet.of(), true);
                    }
                    if (itemSpecInstantiated != null) {
                        if (!candidateYaml.contains("services:")) {
                            log.debug("Instantiation of this blueprint was only possible with legacy plan-to-spec converter, may not be supported in future versions:\n" + candidateYaml);
                        }
                        this.catalogItemType = candidateCiType;
                        this.planYaml = candidateYaml;
                        this.resolved = true;
                        return true;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (log.isTraceEnabled()) {
                        log.trace("Guessing type of plan, it looks like it isn't " + candidateCiType + "/" + context + ": " + e);
                    }
                    if (this.item.containsKey("services") && (candidateCiType == CatalogItem.CatalogItemType.ENTITY || candidateCiType == CatalogItem.CatalogItemType.APPLICATION || candidateCiType == CatalogItem.CatalogItemType.TEMPLATE)) {
                        this.errors.add(e);
                    }
                    if (this.catalogItemType != null && optionalKeyForModifyingYaml != null) {
                        this.errors.add(e);
                    }
                    if (candidateCiType != CatalogItem.CatalogItemType.ENTITY) break block13;
                    this.entityErrors.add(e);
                }
            }
            if (typeIfOptionalKeySupplied != null && optionalKeyForModifyingYaml != null) {
                try {
                    Object cutdownSpecInstantiated = null;
                    if (ATTEMPT_INSTANTIATION_WITH_LEGACY_PLAN_TO_SPEC_CONVERTERS && !typeIfOptionalKeySupplied.startsWith("services:") && !typeIfOptionalKeySupplied.contains("\nservices:")) {
                        String cutDownYaml = optionalKeyForModifyingYaml + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList("type: " + typeIfOptionalKeySupplied);
                        Object itemToAttempt = BasicBrooklynCatalog.createItemBuilder(candidateCiType, this.getIdWithRandomDefault(), "0.0.0_DEFAULT_VERSION").plan(cutDownYaml).libraries(this.libraryBundles).build();
                        cutdownSpecInstantiated = BasicBrooklynCatalog.internalCreateSpecLegacy(BasicBrooklynCatalog.this.mgmt, itemToAttempt, (Set<String>)MutableSet.of(), true);
                    }
                    if (cutdownSpecInstantiated != null) {
                        log.warn("Instantiation of this blueprint was only possible using cut-down syntax `" + optionalKeyForModifyingYaml + ": { type: " + typeIfOptionalKeySupplied + " }`; assuming dependencies on other items. May resolve subsequently or may cause errors when used:\n" + candidateYaml);
                        this.catalogItemType = candidateCiType;
                        this.planYaml = candidateYaml;
                        this.resolved = true;
                        return true;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    this.errors.add(e);
                }
            }
            return false;
        }

        private String getIdWithRandomDefault() {
            return this.itemId != null ? this.itemId : Strings.makeRandomId((int)10);
        }

        public Map<?, ?> getItem() {
            return this.item;
        }

        public PlanInterpreterInferringType setId(String id) {
            this.itemId = this.itemId;
            return this;
        }
    }

    public static class BrooklynLoaderTracker {
        public static final ThreadLocal<BrooklynClassLoadingContext> loader = new ThreadLocal();

        public static void setLoader(BrooklynClassLoadingContext val) {
            loader.set(val);
        }

        public static void unsetLoader(BrooklynClassLoadingContext val) {
            loader.set(null);
        }

        public static BrooklynClassLoadingContext getLoader() {
            return loader.get();
        }
    }
}

