/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import com.google.common.base.Preconditions;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstract;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.tasks.kubectl.ContainerCommons;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskFactory;
import org.apache.brooklyn.tasks.kubectl.ContainerTaskResult;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEffector
extends AddEffectorInitializerAbstract
implements ContainerCommons {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEffector.class);

    public ContainerEffector() {
    }

    public ContainerEffector(ConfigBag configBag) {
        super(configBag);
    }

    protected Effectors.EffectorBuilder<String> newEffectorBuilder() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating container effector {}", this.initParam(EFFECTOR_NAME));
        }
        Effectors.EffectorBuilder eff = this.newAbstractEffectorBuilder(String.class);
        eff.impl((EffectorBody)new Body((Effector<String>)eff.buildAbstract(), this.initParams()));
        return eff;
    }

    protected static class Body
    extends EffectorBody<String> {
        private final Effector<String> effector;
        private final ConfigBag params;

        public Body(Effector<String> eff, ConfigBag params) {
            this.effector = eff;
            Preconditions.checkNotNull(params.getAllConfigRaw().get(ContainerCommons.CONTAINER_IMAGE.getName()), (Object)"container image must be supplied when defining this effector");
            this.params = params;
        }

        public String call(ConfigBag parameters) {
            ConfigBag configBag = ConfigBag.newInstanceCopying((ConfigBag)this.params).putAll(parameters);
            Task containerTask = ((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)((ContainerTaskFactory.ConcreteContainerTaskFactory)ContainerTaskFactory.newInstance().summary("Executing Container Image: " + (String)EntityInitializers.resolve((ConfigBag)configBag, ContainerCommons.CONTAINER_IMAGE))).jobIdentifier(this.entity().getApplicationId() + "-" + this.entity().getId() + "-" + "EFFECTOR")).configure(configBag.getAllConfig())).newTask();
            DynamicTasks.queueIfPossible(containerTask).orSubmitAsync((Entity)this.entity());
            return ((ContainerTaskResult)containerTask.getUnchecked()).getMainStdout();
        }
    }
}

