/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.mutex.MutexSupport;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessSshDriver
extends AbstractSoftwareProcessDriver
implements NaiveScriptRunner {
    public static final Logger log = LoggerFactory.getLogger(AbstractSoftwareProcessSshDriver.class);
    public static final Logger logSsh = LoggerFactory.getLogger((String)"org.apache.brooklyn.SSH");
    protected volatile DownloadResolver resolver;
    public static final String IGNORE_ENTITY_SSH_FLAGS = SshEffectorTasks.IGNORE_ENTITY_SSH_FLAGS.getName();
    private transient WithMutexes defaultMutexes = new MutexSupport();
    public static final String INSTALLING = "installing";
    public static final String CUSTOMIZING = "customizing";
    public static final String LAUNCHING = "launching";
    public static final String CHECK_RUNNING = "check-running";
    public static final String STOPPING = "stopping";
    public static final String KILLING = "killing";
    public static final String RESTARTING = "restarting";
    public static final String PID_FILENAME = "pid.txt";
    static final String INSTALL_DIR_ENV_VAR = "INSTALL_DIR";
    static final String RUN_DIR_ENV_VAR = "RUN_DIR";
    public static final String USE_PID_FILE = "usePidFile";
    public static final String PROCESS_OWNER = "processOwner";
    public static final String NON_STANDARD_LAYOUT = "nonStandardLayout";
    public static final String INSTALL_INCOMPLETE = "installIncomplete";
    public static final String DEBUG = "debug";
    public static final List<String> VALID_FLAGS = ImmutableList.of((Object)"usePidFile", (Object)"processOwner", (Object)"nonStandardLayout", (Object)"installIncomplete", (Object)"debug");

    @Override
    public void prepare() {
        String downloadUrl = (String)this.getEntity().config().get(SoftwareProcess.DOWNLOAD_URL);
        if (Strings.isNonEmpty((CharSequence)downloadUrl)) {
            this.resolver = Entities.newDownloader((EntityDriver)this);
            String formatString = this.getArchiveNameFormat();
            if (Strings.isNonEmpty((CharSequence)formatString)) {
                this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format(formatString, this.getVersion()))}));
            } else {
                this.setExpandedInstallDir(this.getInstallDir());
            }
        }
    }

    public AbstractSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, (Location)machine);
        if (this.getSshFlags() != null && !this.getSshFlags().isEmpty() && machine != null) {
            machine.configure(this.getSshFlags());
        }
        this.getInstallDir();
        this.getRunDir();
    }

    public SshMachineLocation getLocation() {
        return (SshMachineLocation)super.getLocation();
    }

    public SshMachineLocation getMachine() {
        return this.getLocation();
    }

    public String getHostname() {
        return (String)this.entity.getAttribute(Attributes.HOSTNAME);
    }

    public String getAddress() {
        return (String)this.entity.getAttribute(Attributes.ADDRESS);
    }

    public String getSubnetHostname() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_HOSTNAME);
    }

    public String getSubnetAddress() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_ADDRESS);
    }

    protected Map<String, Object> getSshFlags() {
        return SshEffectorTasks.getSshFlags((Entity)this.getEntity(), (Location)this.getMachine());
    }

    @Deprecated
    public int execute(String command, String summaryForLogging) {
        return this.execute((List<String>)ImmutableList.of((Object)command), summaryForLogging);
    }

    @Override
    @Deprecated
    public int execute(List<String> script, String summaryForLogging) {
        return this.execute(Maps.newLinkedHashMap(), script, summaryForLogging);
    }

    @Override
    @Deprecated
    public int execute(Map flags2, List<String> script, String summaryForLogging) {
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!flags2.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(flags2);
        Map<String, String> environment = (Map<String, String>)flags.get("env");
        if (environment == null) {
            environment = this.getShellEnvironment();
        }
        if (Tasks.current() != null) {
            if (environment != null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForEnvStream((String)"env", environment));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdin") == null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)Streams.byteArrayOfString((String)Strings.join(script, (String)"\n"))));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdout") == null) {
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)stdout));
                ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)stderr));
                flags.put("out", stdout);
                flags.put("err", stderr);
            }
        }
        if (!flags.containsKey("logPrefix")) {
            SshMachineLocation l = this.getLocation();
            flags.put("logPrefix", "" + this.entity.getId() + (l != null ? "@" + l.getDisplayName() : ""));
        }
        return this.getMachine().execScript((Map)flags, summaryForLogging, script, environment);
    }

    protected WithMutexes getMutexes() {
        SshMachineLocation l = this.getLocation();
        if (l != null) {
            return l.mutexes();
        }
        return this.defaultMutexes;
    }

    @Override
    public void copyPreInstallResources() {
        WithMutexes mutexSupport = this.getMutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "pre-installation lock at host for files and templates");
        try {
            super.copyPreInstallResources();
        }
        catch (Exception e) {
            log.warn("Error copying pre-install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    @Override
    public void copyInstallResources() {
        WithMutexes mutexSupport = this.getMutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "installation lock at host for files and templates");
        try {
            super.copyInstallResources();
        }
        catch (Exception e) {
            log.warn("Error copying install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    @Override
    public void copyCustomizeResources() {
        WithMutexes mutexSupport = this.getMutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "installation lock at host for files and templates");
        try {
            super.copyCustomizeResources();
        }
        catch (Exception e) {
            log.warn("Error copying customize resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    private void executeSuccessfully(ConfigKey<String> configKey, String label) {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(configKey)))) {
            log.debug("Executing {} on entity {}", (Object)label, (Object)this.entity.getDisplayName());
            int result = this.execute((List<String>)ImmutableList.of((Object)this.getEntity().getConfig(configKey)), label);
            if (0 != result) {
                log.debug("Executing {} failed with return code {}", (Object)label, (Object)result);
                throw new IllegalStateException("commands for " + configKey.getName() + " failed with return code " + result);
            }
        }
    }

    @Override
    public void runPreInstallCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_INSTALL_COMMAND, "running pre-install commands");
    }

    @Override
    public void runPostInstallCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_INSTALL_COMMAND, "running post-install commands");
    }

    @Override
    public void runPreCustomizeCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_CUSTOMIZE_COMMAND, "running pre-customize commands");
    }

    @Override
    public void runPostCustomizeCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_CUSTOMIZE_COMMAND, "running post-customize commands");
    }

    @Override
    public void runPreLaunchCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_LAUNCH_COMMAND, "running pre-launch commands");
    }

    @Override
    public void runPostLaunchCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_LAUNCH_COMMAND, "running post-launch commands");
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, String source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        if ((result = this.getMachine().installTo(this.resource, (Map)flags, source, destination)) == 0 && log.isDebugEnabled()) {
            log.debug("Copied file for {}: {} to {} - result {}", new Object[]{this.entity, source, destination, result});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyResource(Map<Object, Object> sshFlags, InputStream source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        String prevBlockingDetails = Tasks.setBlockingDetails((String)("copying resource to server at " + destination));
        try {
            result = this.getMachine().copyTo((Map)flags, source, destination);
        }
        finally {
            Tasks.setBlockingDetails((String)prevBlockingDetails);
        }
        if (result == 0) {
            log.debug("copying stream complete; {} on {}", new Object[]{destination, this.getMachine()});
        } else {
            log.warn("copying stream failed; {} on {}: {}", new Object[]{destination, this.getMachine(), result});
        }
        return result;
    }

    protected BashCommandsConfigurable bashCommands() {
        return BrooklynOsCommands.bash((Location)this.getMachine());
    }

    public void checkNoHostnameBug() {
        try {
            ProcessTaskWrapper hostnameTask = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"echo FOREMARKER; hostname; echo AFTMARKER"}))).block();
            String stdout = Strings.getFragmentBetween((String)hostnameTask.getStdout(), (String)"FOREMARKER", (String)"AFTMARKER");
            if (hostnameTask.getExitCode() == 0 && Strings.isNonBlank((CharSequence)stdout)) {
                String hostname = stdout.trim();
                if (hostname.equals("(none)")) {
                    String newHostname = "br-" + this.getEntity().getId().toLowerCase();
                    log.info("Detected no-hostname bug with hostname " + hostname + " for " + this.getEntity() + "; renaming " + this.getMachine() + "  to hostname " + newHostname);
                    ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((List)this.bashCommands().setHostname(newHostname, null)))).block();
                }
            } else {
                log.debug("Hostname could not be determined for location " + EffectorTasks.findSshMachine() + "; not doing no-hostname bug check");
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error checking/fixing no-hostname bug (continuing): " + e, (Throwable)e);
        }
    }

    protected ScriptHelper newScript(String phase) {
        return this.newScript(Maps.newLinkedHashMap(), phase);
    }

    protected ScriptHelper newScript(Map<String, ?> flags, String phase) {
        if (!Entities.isManagedActive((Entity)this.getEntity())) {
            throw new IllegalStateException(this.getEntity() + " is not currently managed here; cannot create script to run here (" + phase + ")");
        }
        if (!Iterables.all(flags.keySet(), (Predicate)StringPredicates.equalToAny(VALID_FLAGS))) {
            throw new IllegalArgumentException("Invalid flags passed: " + flags);
        }
        ScriptHelper s = new ScriptHelper(this, phase + " " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        if (!JavaGroovyEquivalents.groovyTruth(flags.get(NON_STANDARD_LAYOUT))) {
            if (JavaGroovyEquivalents.groovyTruth(flags.get(DEBUG))) {
                s.header.prepend((CharSequence)"set -x");
            }
            if (INSTALLING.equals(phase)) {
                String mutexId = "installation lock at host";
                s.useMutex(this.getMutexes(), "installation lock at host", "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
                s.header.append("export INSTALL_DIR=\"" + this.getInstallDir() + "\"", "mkdir -p $INSTALL_DIR", "cd $INSTALL_DIR", "test -f BROOKLYN && exit 0");
                if (!JavaGroovyEquivalents.groovyTruth(flags.get(INSTALL_INCOMPLETE))) {
                    s.footer.append((CharSequence)"date > $INSTALL_DIR/BROOKLYN");
                }
                s.environmentVariablesReset();
            }
            if (ImmutableSet.of((Object)CUSTOMIZING, (Object)LAUNCHING, (Object)CHECK_RUNNING, (Object)STOPPING, (Object)KILLING, (Object)RESTARTING, (Object[])new String[0]).contains((Object)phase)) {
                s.header.append("export INSTALL_DIR=\"" + this.getInstallDir() + "\"", "export RUN_DIR=\"" + this.getRunDir() + "\"", "mkdir -p $RUN_DIR", "cd $RUN_DIR");
            }
        }
        if (ImmutableSet.of((Object)LAUNCHING, (Object)RESTARTING).contains((Object)phase)) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)STOPPING, (Object)KILLING).contains((Object)phase) && !JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)INSTALLING, (Object)LAUNCHING).contains((Object)phase)) {
            s.updateTaskAndFailOnNonZeroResultCode();
        }
        if (phase.equalsIgnoreCase(CHECK_RUNNING)) {
            s.setInessential();
            s.setFlag(SshTool.PROP_CONNECT_TIMEOUT, Duration.TEN_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SESSION_TIMEOUT, Duration.THIRTY_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SSH_TRIES, 1);
        }
        if (JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            Object usePidFile = flags.get(USE_PID_FILE);
            String pidFile = (usePidFile instanceof CharSequence ? usePidFile : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), PID_FILENAME})).toString();
            String processOwner = (String)flags.get(PROCESS_OWNER);
            if (LAUNCHING.equals(phase)) {
                this.entity.sensors().set(SoftwareProcess.PID_FILE, (Object)pidFile);
                s.footer.prepend((CharSequence)("echo $! > " + pidFile));
            } else if (CHECK_RUNNING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append(this.bashCommands().sudoAsUser(processOwner, "test -f " + pidFile) + " || exit 1", "ps -p $(" + this.bashCommands().sudoAsUser(processOwner, "cat " + pidFile) + ")");
                } else {
                    s.body.append("test -f " + pidFile + " || exit 1", "ps -p `cat " + pidFile + "`");
                }
                s.requireResultCode((Predicate<? super Integer>)Predicates.or((Predicate)Predicates.equalTo((Object)0), (Predicate)Predicates.equalTo((Object)1)));
            } else if (STOPPING.equals(phase)) {
                String stopCommand = Joiner.on((char)'\n').join((Object)("PID=$(cat " + pidFile + ")"), (Object)"test -n \"$PID\" || exit 0", new Object[]{"SIGTERM_USED=\"\"", "for i in $(seq 1 16); do", "  if ps -p $PID > /dev/null ; then", "     kill $PID", "     echo Attempted to stop PID $PID by sending SIGTERM.", "  else", "     echo Process $PID stopped successfully.", "     SIGTERM_USED=\"true\"", "     break", "  fi", "  sleep 1", "done", "if test -z $SIGTERM_USED; then", "  kill -9 $PID", "  echo Sent SIGKILL to $PID", "fi", "rm -f " + pidFile});
                if (processOwner != null) {
                    s.body.append((CharSequence)this.bashCommands().sudoAsUser(processOwner, stopCommand));
                } else {
                    s.body.append((CharSequence)stopCommand);
                }
            } else if (KILLING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append("export PID=$(" + this.bashCommands().sudoAsUser(processOwner, "cat " + pidFile) + ")", "test -n \"$PID\" || exit 0", this.bashCommands().sudoAsUser(processOwner, "kill -9 $PID"), this.bashCommands().sudoAsUser(processOwner, "rm -f " + pidFile));
                } else {
                    s.body.append("export PID=$(cat " + pidFile + ")", "test -n \"$PID\" || exit 0", "kill -9 $PID", "rm -f " + pidFile);
                }
            } else if (RESTARTING.equals(phase)) {
                if (processOwner != null) {
                    s.footer.prepend(this.bashCommands().sudoAsUser(processOwner, "test -f " + pidFile) + " || exit 1", "ps -p $(" + this.bashCommands().sudoAsUser(processOwner, "cat " + pidFile) + ") || exit 1");
                } else {
                    s.footer.prepend("test -f " + pidFile + " || exit 1", "ps -p $(cat " + pidFile + ") || exit 1");
                }
            } else {
                log.warn("usePidFile: script option not valid for " + s.summary);
            }
        }
        return s;
    }

    @Override
    protected void createDirectory(String directoryName, String summaryForLogging) {
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"mkdir -p " + directoryName}).summary(summaryForLogging)).requiringExitCodeZero())).get();
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.add(22);
        return result;
    }

    @Override
    public void setup() {
    }
}

