/*
 * Decompiled with CFR 0.152.
 */
package sandesha2.samples.userguide;

import java.io.File;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import sandesha2.samples.userguide.TestCallback;

public class SyncEchoClient {
    private static final String applicationNamespaceName = "http://tempuri.org/";
    private static final String echoString = "echoString";
    private static final String Text = "Text";
    private static final String Sequence = "Sequence";
    private String toIP = "127.0.0.1";
    private String toPort = "8070";
    private String toEPR = "http://" + this.toIP + ":" + this.toPort + "/axis2/services/RMSampleService";
    private static String SANDESHA2_HOME = "<SANDESHA2_HOME>";
    private static String AXIS2_CLIENT_PATH = SANDESHA2_HOME + File.separator + "target" + File.separator + "repos" + File.separator + "client" + File.separator;

    public static void main(String[] args) throws Exception {
        String axisClientRepo = null;
        if (args != null && args.length > 0) {
            axisClientRepo = args[0];
        }
        if (axisClientRepo != null && !"".equals(axisClientRepo)) {
            AXIS2_CLIENT_PATH = axisClientRepo;
            SANDESHA2_HOME = "";
        }
        new SyncEchoClient().run();
    }

    private void run() throws Exception {
        if ("<SANDESHA2_HOME>".equals(SANDESHA2_HOME)) {
            System.out.println("ERROR: Please change <SANDESHA2_HOME> to your Sandesha2 installation directory.");
            return;
        }
        String axis2_xml = AXIS2_CLIENT_PATH + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)AXIS2_CLIENT_PATH, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setTo(new EndpointReference(this.toEPR));
        String sequenceKey = "sequence3";
        clientOptions.setProperty("Sandesha2SequenceKey", (Object)sequenceKey);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        clientOptions.setAction("urn:wsrm:EchoString");
        serviceClient.setOptions(clientOptions);
        TestCallback callback1 = new TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(SyncEchoClient.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        clientOptions.setAction("urn:wsrm:EchoString");
        TestCallback callback2 = new TestCallback("Callback 2");
        serviceClient.sendReceiveNonBlocking(SyncEchoClient.getEchoOMBlock("echo2", sequenceKey), (AxisCallback)callback2);
        clientOptions.setAction("urn:wsrm:EchoString");
        clientOptions.setProperty("Sandesha2LastMessage", (Object)"true");
        TestCallback callback3 = new TestCallback("Callback 3");
        serviceClient.sendReceiveNonBlocking(SyncEchoClient.getEchoOMBlock("echo3", sequenceKey), (AxisCallback)callback3);
        while (!callback3.isComplete()) {
            Thread.sleep(1000L);
        }
    }

    private static OMElement getEchoOMBlock(String text, String sequenceKey) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace applicationNamespace = fac.createOMNamespace(applicationNamespaceName, "ns1");
        OMElement echoStringElement = fac.createOMElement(echoString, applicationNamespace);
        OMElement textElem = fac.createOMElement(Text, applicationNamespace);
        OMElement sequenceElem = fac.createOMElement(Sequence, applicationNamespace);
        textElem.setText(text);
        sequenceElem.setText(sequenceKey);
        echoStringElement.addChild((OMNode)textElem);
        echoStringElement.addChild((OMNode)sequenceElem);
        return echoStringElement;
    }
}

