/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.Endpoint;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class CreateSeqMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(CreateSeqMsgProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processInMessage(RMMsgContext createSeqRMMsg, Transaction transaction) throws AxisFault {
        block56: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: CreateSeqMsgProcessor::processInMessage");
            }
            try {
                EndpointReference toEPR;
                CreateSequence createSeqPart = createSeqRMMsg.getCreateSequence();
                if (createSeqPart == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)SandeshaMessageHelper.getMessage("noCreateSeqParts"));
                    }
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("noCreateSeqParts"), new Exception(), null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                MessageContext createSeqMsg = createSeqRMMsg.getMessageContext();
                ConfigurationContext context = createSeqMsg.getConfigurationContext();
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, (AxisDescription)context.getAxisConfiguration());
                SecurityManager secManager = SandeshaUtil.getSecurityManager(context);
                OMElement theSTR = createSeqPart.getSecurityTokenReference();
                SecurityToken token = null;
                if (theSTR != null) {
                    MessageContext msgcontext = createSeqRMMsg.getMessageContext();
                    token = secManager.getSecurityToken(theSTR, msgcontext);
                    SOAPBody body = msgcontext.getEnvelope().getBody();
                    secManager.checkProofOfPossession(token, (OMElement)body, msgcontext);
                }
                if ((toEPR = createSeqMsg.getTo()).hasAnonymousAddress()) {
                    RMSBean findBean = new RMSBean();
                    findBean.setReplyToEndpointReference(toEPR);
                    findBean.setTerminationPauserForCS(true);
                    RMSBean rmsBean = storageManager.getRMSBeanMgr().findUnique(findBean);
                    if (rmsBean != null) {
                        MessageContext requestSideRefMessage = storageManager.retrieveMessageContext(rmsBean.getReferenceMessageStoreKey(), context);
                        if (requestSideRefMessage == null) {
                            FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("referencedMessageNotFound", rmsBean.getInternalSequenceID()), new Exception(), null);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                            }
                            return false;
                        }
                        RMMsgContext requestSideRefRMMessage = MsgInitializer.initializeMessage(requestSideRefMessage);
                        TerminateManager.addTerminateSequenceMessage(requestSideRefRMMessage, rmsBean.getInternalSequenceID(), rmsBean.getSequenceID(), storageManager);
                    }
                }
                MessageContext outMessage = null;
                RMDBean rmdBean = SequenceManager.setupNewSequence(createSeqRMMsg, storageManager, secManager, token);
                if (rmdBean == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                RMMsgContext createSeqResponse = RMMsgCreator.createCreateSeqResponseMsg(createSeqRMMsg, rmdBean);
                outMessage = createSeqResponse.getMessageContext();
                outMessage.setMessageID(SandeshaUtil.getUUID());
                createSeqResponse.setFlow(2);
                createSeqResponse.setProperty("Sandesha2AppProcessingDone", "true");
                CreateSequenceResponse createSeqResPart = createSeqResponse.getCreateSequenceResponse();
                SequenceOffer offer = createSeqPart.getSequenceOffer();
                if (offer != null) {
                    Accept accept = createSeqResPart.getAccept();
                    if (accept == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)SandeshaMessageHelper.getMessage("noAcceptPart"));
                        }
                        FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("noAcceptPart"), new Exception(), null);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                        }
                        return false;
                    }
                    String offeredSequenceID = offer.getIdentifer().getIdentifier();
                    RMSBean finderBean = new RMSBean();
                    finderBean.setSequenceID(offeredSequenceID);
                    RMSBean rMSBean = storageManager.getRMSBeanMgr().findUnique(finderBean);
                    boolean offerAccepted = false;
                    String outgoingSideInternalSequenceId = SandeshaUtil.getOutgoingSideInternalSequenceID(rmdBean.getSequenceID());
                    if (rMSBean != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Duplicate offer so we can't accept as we can't be sure it's from the same client: " + offeredSequenceID));
                        }
                        offerAccepted = false;
                    } else {
                        boolean isValidseqID = this.isValidseqID(offeredSequenceID, context, createSeqRMMsg, storageManager);
                        offerAccepted = true;
                        if (isValidseqID && "Spec_2007_02".equals(rmdBean.getRMVersion())) {
                            Endpoint endpoint = offer.getEndpoint();
                            if (endpoint != null) {
                                String addressingNamespace = (String)createSeqRMMsg.getProperty("WSAddressingVersion");
                                String endpointAddress = endpoint.getEPR().getAddress();
                                if (SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace).equals(endpointAddress)) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"CSeq msg contains offer with an anonymous EPR");
                                    }
                                    log.warn((Object)SandeshaMessageHelper.getMessage("sequenceMEPWarning", createSeqRMMsg.getMessageContext().getMessageID(), offeredSequenceID));
                                }
                                rMSBean = new RMSBean();
                                rMSBean.setOfferedEndPointEPR(endpoint.getEPR());
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Offer Refused as it included a null endpoint");
                                }
                                offerAccepted = false;
                            }
                        } else if (isValidseqID && "Spec_2005_02".equals(rmdBean.getRMVersion())) {
                            rMSBean = new RMSBean();
                        }
                        if (isValidseqID) {
                            rMSBean.setSequenceID(offeredSequenceID);
                            rMSBean.setInternalSequenceID(outgoingSideInternalSequenceId);
                            rMSBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
                            if (!storageManager.getRMSBeanMgr().insert(rMSBean)) {
                                offerAccepted = false;
                            }
                        }
                    }
                    if (offerAccepted) {
                        if (rmdBean.getToEndpointReference() != null) {
                            rMSBean.setToEndpointReference(rmdBean.getToEndpointReference());
                        } else {
                            String specVersion = rmdBean.getRMVersion();
                            if ("Spec_2005_02".equals(specVersion)) {
                                rMSBean.setToEndpointReference(new EndpointReference("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"));
                            }
                        }
                        rMSBean.setAcksToEndpointReference(rmdBean.getReplyToEndpointReference());
                        rMSBean.setReplyToEndpointReference(rmdBean.getReplyToEndpointReference());
                        rMSBean.setLastActivatedTime(System.currentTimeMillis());
                        rMSBean.setRMVersion(rmdBean.getRMVersion());
                        rMSBean.setClientCompletedMessages(new RangeString());
                        rmdBean.setOutboundInternalSequence(outgoingSideInternalSequenceId);
                        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
                        rmdBeanMgr.update(rmdBean);
                        rMSBean.setSecurityTokenData(rmdBean.getSecurityTokenData());
                        EndpointReference reference = rMSBean.getAcksToEndpointReference();
                        if ((reference == null || reference.hasAnonymousAddress()) && "Spec_2007_02".equals(createSeqRMMsg.getRMSpecVersion())) {
                            rMSBean.setPollingMode(true);
                        }
                        rMSBean.setSoapVersion(SandeshaUtil.getSOAPVersion(createSeqRMMsg.getSOAPEnvelope()));
                        storageManager.getRMSBeanMgr().update(rMSBean);
                        SandeshaUtil.startWorkersForSequence(context, rMSBean);
                    } else {
                        createSeqResPart.setAccept(null);
                        createSeqResponse.addSOAPEnvelope();
                    }
                }
                outMessage.setResponseWritten(true);
                rmdBean.setLastActivatedTime(System.currentTimeMillis());
                if (toEPR.hasAnonymousAddress() && "Spec_2007_02".equals(createSeqRMMsg.getRMSpecVersion())) {
                    rmdBean.setPollingMode(true);
                }
                storageManager.getRMDBeanMgr().update(rmdBean);
                SandeshaUtil.startWorkersForSequence(context, rmdBean);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                try {
                    AxisEngine.send((MessageContext)outMessage);
                }
                catch (AxisFault e) {
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("couldNotSendCreateSeqResponse", SandeshaUtil.getStackTraceFromException((Exception)((Object)e))), (Exception)((Object)e), rmdBean.getAcksToEndpointReference());
                    Transaction tran = null;
                    try {
                        tran = storageManager.getTransaction();
                        storageManager.getRMDBeanMgr().delete(rmdBean.getSequenceID());
                        if (tran != null && tran.isActive()) {
                            tran.commit();
                        }
                        tran = null;
                    }
                    catch (SandeshaStorageException ex) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Caught an exception deleting the RMD bean", (Throwable)((Object)ex));
                        }
                    }
                    finally {
                        if (tran != null && tran.isActive()) {
                            tran.rollback();
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                EndpointReference replyTo = createSeqMsg.getReplyTo();
                if (replyTo == null || replyTo.hasAnonymousAddress()) {
                    TransportUtils.setResponseWritten((MessageContext)createSeqMsg, (boolean)true);
                }
                createSeqRMMsg.pause();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caught an exception processing CreateSequence message", (Throwable)e);
                }
                if (createSeqRMMsg.getMessageContext().getProperty("Code") == null && createSeqRMMsg.getMessageContext().getProperty("faultcode") == null) {
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaUtil.getStackTraceFromException(e), e, null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                if (createSeqRMMsg.getMessageContext().getProperty("Code") == null) break block56;
                if (e instanceof AxisFault) {
                    throw (AxisFault)((Object)e);
                }
                throw new SandeshaException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.TRUE));
        }
        return true;
    }

    private boolean isValidseqID(String sequenceId, ConfigurationContext configCtx, RMMsgContext createSeqRMMsg, StorageManager storageManager) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: CreateSeqMsgProcessor::isValidseqID, " + sequenceId));
        }
        if ("".equals(sequenceId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CreateSeqMsgProcessor::isValidseqID, false");
            }
            return false;
        }
        if (sequenceId.length() <= 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CreateSeqMsgProcessor::isValidseqID, false");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: CreateSeqMsgProcessor::isValidseqID, true");
        }
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        OperationContext operationContext;
        MessageContext msgCtx;
        SandeshaListener faultCallback;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: CreateSeqMsgProcessor::processOutMessage");
        }
        if ((faultCallback = (SandeshaListener)(msgCtx = rmMsgCtx.getMessageContext()).getOptions().getProperty("Sandesha2Listener")) != null && (operationContext = msgCtx.getOperationContext()) != null) {
            operationContext.setProperty("Sandesha2Listener", (Object)faultCallback);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CreateSeqMsgProcessor::processOutMessage " + Boolean.FALSE));
        }
        return false;
    }
}

