/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public class CustomEnumLogicalTypeFactory
implements LogicalTypes.LogicalTypeFactory {
    private static final LogicalType CUSTOM_ENUM = new CustomEnumLogicalType("custom-enum");

    public LogicalType fromSchema(Schema schema) {
        return CUSTOM_ENUM;
    }

    public String getTypeName() {
        return CUSTOM_ENUM.getName();
    }

    public static class CustomEnumLogicalType
    extends LogicalType {
        public CustomEnumLogicalType(String logicalTypeName) {
            super(logicalTypeName);
        }

        public void validate(Schema schema) {
            super.validate(schema);
            if (schema.getType() != Schema.Type.ENUM) {
                throw new IllegalArgumentException("Custom Enum can only be used with an underlying Enum type");
            }
        }
    }
}

