/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;

public abstract class AbstractRequestsServlet
extends AbstractServlet {
    protected final ICcApplicationContext appCtx;

    public AbstractRequestsServlet(ConcurrentMap<String, Object> ctx, ICcApplicationContext appCtx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        ArrayNode requestsJson = JSONUtil.createArray();
        Collection<IClientRequest> requests = this.getRequests();
        for (IClientRequest req : requests) {
            requestsJson.add((JsonNode)req.asJson());
        }
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        response.setStatus(HttpResponseStatus.OK);
        JSONUtil.writeNode((Writer)response.writer(), (JsonNode)requestsJson);
        response.writer().flush();
    }

    abstract Collection<IClientRequest> getRequests();
}

