/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Map<String, String> toProperties(RecordConstructor recordConstructor) throws CompilationException {
        return ConfigurationUtil.toProperties(ExpressionUtils.toNode(recordConstructor));
    }

    public static Map<String, String> toProperties(AdmObjectNode parameters) throws CompilationException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry field : parameters.getFields()) {
            IAdmNode value = (IAdmNode)field.getValue();
            map.put((String)field.getKey(), ConfigurationUtil.getStringValue(value));
        }
        return map;
    }

    public static String getStringValue(IAdmNode value) throws CompilationException {
        switch (value.getType()) {
            case BOOLEAN: 
            case DOUBLE: 
            case BIGINT: {
                return value.toString();
            }
            case STRING: {
                return ((AdmStringNode)value).get();
            }
        }
        throw new CompilationException(ErrorCode.CONFIGURATION_PARAMETER_INVALID_TYPE, new Serializable[]{value.getType()});
    }
}

