/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.flush;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.metadata.AbstractColumnMetadata;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.PathInfoSerializer;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.ArraySchemaNode;
import org.apache.asterix.column.metadata.schema.collection.MultisetSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.metadata.schema.visitor.SchemaBuilderFromIATypeVisitor;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.column.util.SchemaStringBuilderVisitor;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.IColumnValuesWriterFactory;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FlushColumnMetadata
extends AbstractColumnMetadata {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels;
    private final Mutable<IColumnWriteMultiPageOp> multiPageOpRef;
    private final FieldNamesDictionary fieldNamesDictionary;
    private final ObjectSchemaNode root;
    private final ObjectSchemaNode metaRoot;
    private final IColumnValuesWriterFactory columnWriterFactory;
    private final List<IColumnValuesWriter> columnWriters;
    private final ArrayBackedValueStorage serializedMetadata;
    private final PathInfoSerializer pathInfoSerializer;
    private final IntArrayList nullWriterIndexes;
    private final boolean metaContainsKeys;
    private boolean changed;
    private int level;
    private int repeated;

    public FlushColumnMetadata(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, List<Integer> keySourceIndicator, IColumnValuesWriterFactory columnWriterFactory, Mutable<IColumnWriteMultiPageOp> multiPageOpRef) throws HyracksDataException {
        super(datasetType, metaType, primaryKeys.size());
        this.multiPageOpRef = multiPageOpRef;
        this.columnWriterFactory = columnWriterFactory;
        this.definitionLevels = new HashMap<AbstractSchemaNestedNode, RunLengthIntArray>();
        this.columnWriters = new ArrayList<IColumnValuesWriter>();
        this.level = -1;
        this.repeated = 0;
        this.fieldNamesDictionary = new FieldNamesDictionary();
        this.root = new ObjectSchemaNode();
        this.metaRoot = metaType != null ? new ObjectSchemaNode() : null;
        this.pathInfoSerializer = new PathInfoSerializer();
        this.nullWriterIndexes = new IntArrayList();
        this.addDefinitionLevelsAndGet(this.root);
        SchemaBuilderFromIATypeVisitor builder = new SchemaBuilderFromIATypeVisitor(this, primaryKeys);
        boolean bl = this.metaContainsKeys = metaType != null && keySourceIndicator.get(0) == 1;
        if (this.metaContainsKeys) {
            this.addDefinitionLevelsAndGet(this.metaRoot);
            metaType.accept((IATypeVisitor)builder, (Object)this.metaRoot);
            datasetType.accept((IATypeVisitor)builder, (Object)this.root);
        } else {
            datasetType.accept((IATypeVisitor)builder, (Object)this.root);
            if (this.metaRoot != null) {
                this.addDefinitionLevelsAndGet(this.metaRoot);
                metaType.accept((IATypeVisitor)builder, (Object)this.metaRoot);
            }
        }
        this.serializedMetadata = new ArrayBackedValueStorage();
        this.changed = true;
        this.serializeColumnsMetadata();
    }

    private FlushColumnMetadata(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, boolean metaContainsKeys, IColumnValuesWriterFactory columnWriterFactory, Mutable<IColumnWriteMultiPageOp> multiPageOpRef, List<IColumnValuesWriter> columnWriters, FieldNamesDictionary fieldNamesDictionary, ObjectSchemaNode root, ObjectSchemaNode metaRoot, Map<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels, ArrayBackedValueStorage serializedMetadata) {
        super(datasetType, metaType, primaryKeys.size());
        this.multiPageOpRef = multiPageOpRef;
        this.columnWriterFactory = columnWriterFactory;
        this.definitionLevels = definitionLevels;
        this.columnWriters = columnWriters;
        this.level = -1;
        this.repeated = 0;
        this.fieldNamesDictionary = fieldNamesDictionary;
        this.root = root;
        this.metaRoot = metaRoot;
        this.metaContainsKeys = metaContainsKeys;
        this.pathInfoSerializer = new PathInfoSerializer();
        this.nullWriterIndexes = new IntArrayList();
        this.addDefinitionLevelsAndGet(root);
        this.serializedMetadata = serializedMetadata;
        this.changed = false;
    }

    public FieldNamesDictionary getFieldNamesDictionary() {
        return this.fieldNamesDictionary;
    }

    public ObjectSchemaNode getRoot() {
        return this.root;
    }

    public ObjectSchemaNode getMetaRoot() {
        return this.metaRoot;
    }

    public Mutable<IColumnWriteMultiPageOp> getMultiPageOpRef() {
        return this.multiPageOpRef;
    }

    public IValueReference serializeColumnsMetadata() throws HyracksDataException {
        if (this.changed) {
            try {
                this.serializeChanges();
                FlushColumnMetadata.logSchema(this.root, this.metaRoot, this.fieldNamesDictionary);
                this.changed = false;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        return this.serializedMetadata;
    }

    private void serializeChanges() throws IOException {
        this.serializedMetadata.reset();
        DataOutput output = this.serializedMetadata.getDataOutput();
        int writersOffsetPointer = this.reserveInt(output);
        int fieldNamesOffsetPointer = this.reserveInt(output);
        int schemaOffsetPointer = this.reserveInt(output);
        int metaSchemaOffsetPointer = this.reserveInt(output);
        int pathInfoOffsetPointer = this.reserveInt(output);
        this.setOffset(writersOffsetPointer);
        output.writeInt(this.columnWriters.size());
        for (IColumnValuesWriter writer : this.columnWriters) {
            writer.serialize(output);
        }
        this.setOffset(fieldNamesOffsetPointer);
        this.fieldNamesDictionary.serialize(output);
        this.pathInfoSerializer.reset();
        this.setOffset(schemaOffsetPointer);
        this.root.serialize(output, this.pathInfoSerializer);
        if (this.metaRoot != null) {
            this.setOffset(metaSchemaOffsetPointer);
            this.metaRoot.serialize(output, this.pathInfoSerializer);
        }
        this.setOffset(pathInfoOffsetPointer);
        this.pathInfoSerializer.serialize(output, this.getNumberOfColumns());
    }

    private int reserveInt(DataOutput output) throws IOException {
        int offset = this.serializedMetadata.getLength();
        output.writeInt(-1);
        return offset;
    }

    private void setOffset(int pointer) {
        int offset = this.serializedMetadata.getLength();
        IntegerPointable.setInteger((byte[])this.serializedMetadata.getByteArray(), (int)pointer, (int)offset);
    }

    public static FlushColumnMetadata create(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, List<Integer> keySourceIndicator, IColumnValuesWriterFactory columnWriterFactory, Mutable<IColumnWriteMultiPageOp> multiPageOpRef, IValueReference serializedMetadata) throws HyracksDataException {
        boolean metaContainsKeys = metaType != null && keySourceIndicator.get(0) == 1;
        try {
            return FlushColumnMetadata.createMutableMetadata(datasetType, metaType, primaryKeys, metaContainsKeys, columnWriterFactory, multiPageOpRef, serializedMetadata);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private static FlushColumnMetadata createMutableMetadata(ARecordType datasetType, ARecordType metaType, List<List<String>> primaryKeys, boolean metaContainsKeys, IColumnValuesWriterFactory columnWriterFactory, Mutable<IColumnWriteMultiPageOp> multiPageOpRef, IValueReference serializedMetadata) throws IOException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(serializedMetadata.getByteArray(), serializedMetadata.getStartOffset(), serializedMetadata.getLength()));
        input.skipBytes(20);
        ArrayList<IColumnValuesWriter> writers = new ArrayList<IColumnValuesWriter>();
        FlushColumnMetadata.deserializeWriters(input, writers, columnWriterFactory);
        FieldNamesDictionary fieldNamesDictionary = FieldNamesDictionary.deserialize(input);
        HashMap<AbstractSchemaNestedNode, RunLengthIntArray> definitionLevels = new HashMap<AbstractSchemaNestedNode, RunLengthIntArray>();
        ObjectSchemaNode root = (ObjectSchemaNode)AbstractSchemaNode.deserialize(input, definitionLevels);
        ObjectSchemaNode metaRoot = null;
        if (metaType != null) {
            metaRoot = (ObjectSchemaNode)AbstractSchemaNode.deserialize(input, definitionLevels);
        }
        ArrayBackedValueStorage schemaStorage = new ArrayBackedValueStorage(serializedMetadata.getLength());
        schemaStorage.append(serializedMetadata);
        FlushColumnMetadata.logSchema(root, metaRoot, fieldNamesDictionary);
        return new FlushColumnMetadata(datasetType, metaType, primaryKeys, metaContainsKeys, columnWriterFactory, multiPageOpRef, writers, fieldNamesDictionary, root, metaRoot, definitionLevels, schemaStorage);
    }

    public void abort() throws HyracksDataException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.serializedMetadata.getByteArray()));
        try {
            this.abort(input);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void abort(DataInputStream input) throws IOException {
        this.level = -1;
        this.repeated = 0;
        this.changed = false;
        this.columnWriters.clear();
        FlushColumnMetadata.deserializeWriters(input, this.columnWriters, this.columnWriterFactory);
        this.fieldNamesDictionary.abort(input);
        this.definitionLevels.clear();
        this.root.abort(input, this.definitionLevels);
    }

    public static void deserializeWriters(DataInput input, List<IColumnValuesWriter> writers, IColumnValuesWriterFactory columnWriterFactory) throws IOException {
        int numberOfWriters = input.readInt();
        for (int i = 0; i < numberOfWriters; ++i) {
            writers.add(AbstractColumnValuesWriter.deserialize(input, columnWriterFactory));
        }
    }

    public void init(IColumnWriteMultiPageOp multiPageOp) throws HyracksDataException {
        this.multiPageOpRef.setValue((Object)multiPageOp);
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            this.columnWriters.get(i).reset();
        }
    }

    public IColumnValuesWriter getWriter(int columnIndex) {
        return this.columnWriters.get(columnIndex);
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columnWriters.size();
    }

    public AbstractSchemaNode getOrCreateChild(AbstractSchemaNode child, ATypeTag childTypeTag) throws HyracksDataException {
        AbstractSchemaNode currentChild = child;
        ATypeTag normalizedTypeTag = ColumnValuesUtil.getNormalizedTypeTag(childTypeTag);
        if (currentChild == null || normalizedTypeTag != ATypeTag.MISSING && normalizedTypeTag != ATypeTag.NULL && currentChild.getTypeTag() != ATypeTag.UNION && ColumnValuesUtil.getNormalizedTypeTag(currentChild.getTypeTag()) != normalizedTypeTag) {
            currentChild = this.createChild(child, childTypeTag);
            this.changed = true;
        }
        return currentChild;
    }

    public void enterLevel(AbstractSchemaNestedNode node) {
        ++this.level;
        if (node.isCollection()) {
            ++this.repeated;
        }
    }

    public void exitLevel(AbstractSchemaNestedNode node) {
        --this.level;
        if (node.isCollection()) {
            --this.repeated;
        }
    }

    public void enterNode(AbstractSchemaNestedNode parent, AbstractSchemaNode node) throws HyracksDataException {
        this.flushDefinitionLevels(this.level, parent, node);
        if (node.isObjectOrCollection()) {
            ++this.level;
            if (node.isCollection()) {
                ++this.repeated;
            }
        }
    }

    public void exitNode(AbstractSchemaNode node) {
        if (node.isNested()) {
            this.definitionLevels.get((AbstractSchemaNestedNode)node).add(this.level);
            if (node.isObjectOrCollection()) {
                --this.level;
            }
        }
        node.incrementCounter();
    }

    public void exitCollectionNode(AbstractCollectionSchemaNode collectionNode, int numberOfItems) {
        RunLengthIntArray collectionDefLevels = this.definitionLevels.get(collectionNode);
        collectionDefLevels.add(this.level - 1);
        --this.level;
        --this.repeated;
        collectionNode.incrementCounter();
    }

    public RunLengthIntArray getDefinitionLevels(AbstractCollectionSchemaNode collectionSchemaNode) {
        return this.definitionLevels.get(collectionSchemaNode);
    }

    public void clearDefinitionLevels(AbstractSchemaNestedNode nestedNode) {
        this.definitionLevels.get(nestedNode).reset();
    }

    public void flushDefinitionLevels(int level, AbstractSchemaNestedNode parent, AbstractSchemaNode node) throws HyracksDataException {
        if (parent != null) {
            RunLengthIntArray parentDefLevels = this.definitionLevels.get(parent);
            if (node.getCounter() < parentDefLevels.getSize()) {
                int parentMask = ColumnValuesUtil.getNullMask(level);
                int childMask = ColumnValuesUtil.getNullMask(level + 1);
                this.flushDefinitionLevels(parentMask, childMask, parentDefLevels, node);
            }
        }
    }

    public void addNestedNull(AbstractSchemaNestedNode parent, AbstractSchemaNestedNode node) throws HyracksDataException {
        this.flushDefinitionLevels(this.level, parent, node);
        this.definitionLevels.get(node).add(ColumnValuesUtil.getNullMask(this.level + 2) | this.level);
        node.incrementCounter();
    }

    public void close() {
        this.multiPageOpRef.setValue(null);
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            this.columnWriters.get(i).close();
        }
    }

    private void flushDefinitionLevels(int parentMask, int childMask, RunLengthIntArray parentDefLevels, AbstractSchemaNode node) throws HyracksDataException {
        int startIndex = node.getCounter();
        if (node.isNested()) {
            RunLengthIntArray childDefLevels = this.definitionLevels.get((AbstractSchemaNestedNode)node);
            this.flushNestedDefinitionLevel(parentMask, childMask, startIndex, parentDefLevels, childDefLevels);
        } else {
            IColumnValuesWriter writer = this.columnWriters.get(((PrimitiveSchemaNode)node).getColumnIndex());
            this.flushWriterDefinitionLevels(parentMask, childMask, startIndex, parentDefLevels, writer);
        }
        node.setCounter(parentDefLevels.getSize());
    }

    private void flushNestedDefinitionLevel(int parentMask, int childMask, int startIndex, RunLengthIntArray parentDefLevels, RunLengthIntArray childDefLevels) {
        if (parentDefLevels.getSize() == 0) {
            return;
        }
        int blockIndex = parentDefLevels.getBlockIndex(startIndex);
        int remainingValues = parentDefLevels.getBlockSize(blockIndex, startIndex);
        int firstBlockValue = ColumnValuesUtil.getChildValue(parentMask, childMask, parentDefLevels.getBlockValue(blockIndex));
        childDefLevels.add(firstBlockValue, remainingValues);
        for (int i = blockIndex + 1; i < parentDefLevels.getNumberOfBlocks(); ++i) {
            int blockValue = ColumnValuesUtil.getChildValue(parentMask, childMask, parentDefLevels.getBlockValue(i));
            childDefLevels.add(blockValue, parentDefLevels.getBlockSize(i));
        }
    }

    private void flushWriterDefinitionLevels(int parentMask, int childMask, int startIndex, RunLengthIntArray parentDefLevels, IColumnValuesWriter writer) throws HyracksDataException {
        if (parentDefLevels.getSize() == 0) {
            return;
        }
        int blockIndex = parentDefLevels.getBlockIndex(startIndex);
        int remainingValues = parentDefLevels.getBlockSize(blockIndex, startIndex);
        int firstBlockValue = ColumnValuesUtil.getChildValue(parentMask, childMask, parentDefLevels.getBlockValue(blockIndex));
        writer.writeLevels(firstBlockValue, remainingValues);
        for (int i = blockIndex + 1; i < parentDefLevels.getNumberOfBlocks(); ++i) {
            int blockValue = ColumnValuesUtil.getChildValue(parentMask, childMask, parentDefLevels.getBlockValue(i));
            writer.writeLevels(blockValue, parentDefLevels.getBlockSize(i));
        }
    }

    private AbstractSchemaNode createChild(AbstractSchemaNode child, ATypeTag childTypeTag) throws HyracksDataException {
        AbstractSchemaNode createdChild;
        ATypeTag normalizedTypeTag = ColumnValuesUtil.getNormalizedTypeTag(childTypeTag);
        if (child != null) {
            if (child.getTypeTag() == ATypeTag.NULL) {
                int columnIndex = ((PrimitiveSchemaNode)child).getColumnIndex();
                RunLengthIntArray defLevels = this.columnWriters.get(columnIndex).getDefinitionLevelsIntArray();
                this.nullWriterIndexes.add(columnIndex);
                createdChild = this.createChild(normalizedTypeTag);
                int mask = ColumnValuesUtil.getNullMask(this.level);
                this.flushDefinitionLevels(mask, mask, defLevels, createdChild);
            } else {
                createdChild = this.addDefinitionLevelsAndGet(new UnionSchemaNode(child, this.createChild(normalizedTypeTag)));
            }
        } else {
            createdChild = this.createChild(childTypeTag);
        }
        return createdChild;
    }

    private AbstractSchemaNode createChild(ATypeTag childTypeTag) throws HyracksDataException {
        switch (childTypeTag) {
            case OBJECT: {
                return this.addDefinitionLevelsAndGet(new ObjectSchemaNode());
            }
            case ARRAY: {
                return this.addDefinitionLevelsAndGet(new ArraySchemaNode());
            }
            case MULTISET: {
                return this.addDefinitionLevelsAndGet(new MultisetSchemaNode());
            }
            case NULL: 
            case MISSING: 
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case STRING: 
            case UUID: {
                int columnIndex = this.nullWriterIndexes.isEmpty() ? this.columnWriters.size() : this.nullWriterIndexes.removeInt(0);
                boolean primaryKey = columnIndex < this.getNumberOfPrimaryKeys();
                ATypeTag normalizedTypeTag = primaryKey ? childTypeTag : ColumnValuesUtil.getNormalizedTypeTag(childTypeTag);
                boolean writeAlways = primaryKey || this.repeated > 0;
                boolean filtered = !primaryKey;
                int maxLevel = primaryKey ? 1 : this.level + 1;
                IColumnValuesWriter writer = this.columnWriterFactory.createValueWriter(normalizedTypeTag, columnIndex, maxLevel, writeAlways, filtered);
                if (this.multiPageOpRef.getValue() != null) {
                    writer.reset();
                }
                this.addColumn(columnIndex, writer);
                return new PrimitiveSchemaNode(columnIndex, normalizedTypeTag, primaryKey);
            }
        }
        throw new IllegalStateException("Unsupported type " + childTypeTag);
    }

    private void addColumn(int index, IColumnValuesWriter writer) {
        if (index == this.columnWriters.size()) {
            this.columnWriters.add(writer);
        } else {
            this.columnWriters.set(index, writer);
        }
    }

    private AbstractSchemaNode addDefinitionLevelsAndGet(AbstractSchemaNestedNode nestedNode) {
        this.definitionLevels.put(nestedNode, new RunLengthIntArray());
        return nestedNode;
    }

    private static void logSchema(ObjectSchemaNode root, ObjectSchemaNode metaRoot, FieldNamesDictionary fieldNamesDictionary) throws HyracksDataException {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        SchemaStringBuilderVisitor schemaBuilder = new SchemaStringBuilderVisitor(fieldNamesDictionary);
        String recordSchema = LogRedactionUtil.userData((String)schemaBuilder.build(root));
        LOGGER.debug("Schema for {} has changed: \n {}", (Object)SchemaStringBuilderVisitor.RECORD_SCHEMA, (Object)recordSchema);
        if (metaRoot != null) {
            String metaRecordSchema = LogRedactionUtil.userData((String)schemaBuilder.build(metaRoot));
            LOGGER.debug("Schema for {} has changed: \n {}", (Object)SchemaStringBuilderVisitor.META_RECORD_SCHEMA, (Object)metaRecordSchema);
        }
    }
}

