/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.io.Serializable;
import org.apache.asterix.common.config.TransactionProperties;

public class LogManagerProperties
implements Serializable {
    private static final long serialVersionUID = 2084227360840799662L;
    public static final String lineSeparator = System.getProperty("line.separator");
    private static final String DEFAULT_LOG_FILE_PREFIX = "transaction_log";
    private final String logFilePrefix;
    private final String logDir;
    private final int logPageSize;
    private final int numLogPages;
    private final long logPartitionSize;

    public LogManagerProperties(TransactionProperties txnProperties, String nodeId) {
        this.logPageSize = txnProperties.getLogBufferPageSize();
        this.numLogPages = txnProperties.getLogBufferNumPages();
        long logPartitionSize = txnProperties.getLogPartitionSize();
        this.logDir = txnProperties.getLogDirectory(nodeId);
        this.logFilePrefix = DEFAULT_LOG_FILE_PREFIX;
        int logBufferSize = this.logPageSize * this.numLogPages;
        this.logPartitionSize = logPartitionSize / (long)logBufferSize * (long)logBufferSize;
    }

    public long getLogPartitionSize() {
        return this.logPartitionSize;
    }

    public String getLogFilePrefix() {
        return this.logFilePrefix;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }

    public int getNumLogPages() {
        return this.numLogPages;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("log_dir_ : " + this.logDir + lineSeparator);
        builder.append("log_file_prefix" + this.logFilePrefix + lineSeparator);
        builder.append("log_page_size : " + this.logPageSize + lineSeparator);
        builder.append("num_log_pages : " + this.numLogPages + lineSeparator);
        builder.append("log_partition_size : " + this.logPartitionSize + lineSeparator);
        return builder.toString();
    }
}

