/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.stream.AbstractStreamRecordReader;
import org.apache.asterix.external.input.stream.DiscretizedMultipleInputStream;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AvroRecordReader
extends AbstractStreamRecordReader<org.apache.avro.generic.GenericRecord> {
    private final GenericRecord<org.apache.avro.generic.GenericRecord> record = new GenericRecord();
    private final DiscretizedMultipleInputStream inputStream;
    private final Supplier<String> dataSourceName;
    private org.apache.avro.generic.GenericRecord avroRecord;
    private DataFileStream<org.apache.avro.generic.GenericRecord> dataFileStream;
    private boolean done;
    private static final List<String> recordReaderFormats = Collections.unmodifiableList(Arrays.asList("avro"));

    public AvroRecordReader(AsterixInputStream inputStream, Map<String, String> config) throws IOException {
        this.inputStream = new DiscretizedMultipleInputStream(inputStream);
        this.done = false;
        this.dataSourceName = ExternalDataUtils.isTrue(config, "redact-warnings") ? ExternalDataConstants.EMPTY_STRING : inputStream::getStreamName;
        this.advance();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.done) {
                this.inputStream.close();
            }
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public boolean stop() {
        try {
            this.inputStream.stop();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public IRawRecord<org.apache.avro.generic.GenericRecord> next() throws IOException {
        this.avroRecord = (org.apache.avro.generic.GenericRecord)this.dataFileStream.next((Object)this.avroRecord);
        this.record.set(this.avroRecord);
        return this.record;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.dataFileStream == null) {
            return false;
        }
        if (this.dataFileStream.hasNext()) {
            return true;
        }
        return this.advance() && this.dataFileStream.hasNext();
    }

    @Override
    public void setFeedLogManager(IFeedLogManager feedLogManager) throws HyracksDataException {
        this.inputStream.setFeedLogManager(feedLogManager);
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
        this.inputStream.setController(controller);
    }

    @Override
    public boolean handleException(Throwable th) {
        return this.inputStream.handleException(th);
    }

    @Override
    public List<String> getRecordReaderFormats() {
        return recordReaderFormats;
    }

    @Override
    public void configure(IHyracksTaskContext ctx, AsterixInputStream inputStream, Map<String, String> config) throws HyracksDataException {
    }

    private boolean advance() throws IOException {
        if (this.inputStream.advance()) {
            GenericDatumReader datumReader = new GenericDatumReader();
            this.dataFileStream = new DataFileStream((InputStream)this.inputStream, (DatumReader)datumReader);
            return true;
        }
        return false;
    }
}

