/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class EditDistanceListIsFilterableDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = EditDistanceListIsFilterableDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new EditDistanceListIsFilterableEvaluator(args, ctx);
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE;
    }

    private static class EditDistanceListIsFilterableEvaluator
    implements IScalarEvaluator {
        protected final IPointable listPtr = new VoidPointable();
        protected final IPointable edThreshPtr = new VoidPointable();
        protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        protected final DataOutput output = this.resultStorage.getDataOutput();
        protected final IScalarEvaluator listEval;
        protected final IScalarEvaluator edThreshEval;
        private final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);

        public EditDistanceListIsFilterableEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext context) throws HyracksDataException {
            this.listEval = args[0].createScalarEvaluator(context);
            this.edThreshEval = args[1].createScalarEvaluator(context);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            long listLen;
            this.resultStorage.reset();
            this.listEval.evaluate(tuple, this.listPtr);
            this.edThreshEval.evaluate(tuple, this.edThreshPtr);
            if (PointableHelper.checkAndSetMissingOrNull((IPointable)result, (IPointable)this.listPtr, (IPointable)this.edThreshPtr)) {
                return;
            }
            byte[] bytes = this.listPtr.getByteArray();
            int offset = this.listPtr.getStartOffset();
            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
            switch (typeTag) {
                case MULTISET: {
                    listLen = AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)offset);
                    break;
                }
                case ARRAY: {
                    listLen = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)offset);
                    break;
                }
                default: {
                    throw new TypeMismatchException(BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE, 0, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, new byte[]{ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG});
                }
            }
            bytes = this.edThreshPtr.getByteArray();
            offset = this.edThreshPtr.getStartOffset();
            long edThresh = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.EDIT_DISTANCE_LIST_IS_FILTERABLE.getName(), (int)1, (byte[])bytes, (int)offset);
            long lowerBound = listLen - edThresh;
            try {
                if (lowerBound <= 0L) {
                    this.booleanSerde.serialize((Object)ABoolean.FALSE, this.output);
                } else {
                    this.booleanSerde.serialize((Object)ABoolean.TRUE, this.output);
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

