/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.IExternalLangIPCProto;
import org.apache.asterix.external.ipc.AbstractPythonIPCProto;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.msgpack.core.buffer.MessageBufferInput;

public class PythonTCPSocketProto
extends AbstractPythonIPCProto
implements IExternalLangIPCProto {
    private final ExternalFunctionResultRouter router;
    private final Process proc;

    public PythonTCPSocketProto(OutputStream sockOut, ExternalFunctionResultRouter router, Process pythonProc) {
        super(sockOut);
        this.router = router;
        this.proc = pythonProc;
    }

    @Override
    public void start() {
        Pair keyAndBufferBox = this.router.insertRoute(this.recvBuffer);
        this.routeId = (Long)keyAndBufferBox.getFirst();
        this.bufferBox = (Pair)keyAndBufferBox.getSecond();
    }

    @Override
    public void quit() throws HyracksDataException {
        this.messageBuilder.quit();
        this.router.removeRoute(Long.valueOf(this.routeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMsg() throws IOException, AsterixException {
        Exception except;
        try {
            Pair pair = this.bufferBox;
            synchronized (pair) {
                while ((((ByteBuffer)this.bufferBox.getFirst()).limit() == 0 || this.bufferBox.getSecond() != null) && this.proc.isAlive()) {
                    this.bufferBox.wait(100L);
                }
            }
            except = this.router.getAndRemoveException(Long.valueOf(this.routeId));
            if (!this.proc.isAlive()) {
                except = new IOException("Python process exited with code: " + this.proc.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AsterixException(ErrorCode.EXTERNAL_UDF_EXCEPTION, (Throwable)e, new Serializable[0]);
        }
        if (except != null) {
            throw new AsterixException((Throwable)except);
        }
        if (this.bufferBox.getFirst() != this.recvBuffer) {
            this.recvBuffer = (ByteBuffer)this.bufferBox.getFirst();
        }
        this.messageBuilder.readHead(this.recvBuffer);
        if (this.messageBuilder.type == MessageType.ERROR) {
            this.unpackerInput.reset(this.recvBuffer.array(), this.recvBuffer.position() + this.recvBuffer.arrayOffset(), this.recvBuffer.remaining());
            this.unpacker.reset((MessageBufferInput)this.unpackerInput);
            throw new AsterixException(this.unpacker.unpackString());
        }
    }
}

