/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class UnionExpectedSchemaNode
extends AbstractComplexExpectedSchemaNode {
    private final Map<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode> children = new EnumMap<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode>(ExpectedSchemaNodeType.class);

    protected UnionExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        super(parent, sourceLocation, functionName);
    }

    @Override
    protected void replaceChild(IExpectedSchemaNode oldChildNode, IExpectedSchemaNode newChildNode) {
        throw new UnsupportedOperationException("Cannot replace a child of UNION");
    }

    protected void addChild(AbstractComplexExpectedSchemaNode node) {
        this.children.put(node.getType(), node);
    }

    public void createChild(ExpectedSchemaNodeType nodeType, SourceLocation sourceLocation, String functionName) {
        this.children.computeIfAbsent(nodeType, k -> UnionExpectedSchemaNode.createNestedNode(k, this, sourceLocation, functionName));
    }

    public AbstractComplexExpectedSchemaNode getChild(ExpectedSchemaNodeType type) {
        return this.children.get((Object)type);
    }

    public Set<Map.Entry<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode>> getChildren() {
        return this.children.entrySet();
    }

    @Override
    public ExpectedSchemaNodeType getType() {
        return ExpectedSchemaNodeType.UNION;
    }

    @Override
    public <R, T> R accept(IExpectedSchemaNodeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }

    @Override
    public IExpectedSchemaNode replaceIfNeeded(ExpectedSchemaNodeType expectedNodeType, SourceLocation sourceLocation, String functionName) {
        if (expectedNodeType == ExpectedSchemaNodeType.ANY) {
            return super.replaceIfNeeded(expectedNodeType, sourceLocation, functionName);
        }
        return this;
    }
}

