/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.linearize;

import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.rtree.impls.DoublePrimitiveValueProviderFactory;
import org.apache.hyracks.storage.common.arraylist.DoubleArrayList;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;

public class HilbertDoubleComparator
implements ILinearizeComparator {
    private final int dim;
    private final HilbertState[] states;
    private double[] bounds;
    private double stepsize;
    private int state;
    private IntArrayList stateStack = new IntArrayList(1000, 200);
    private DoubleArrayList boundsStack = new DoubleArrayList(2000, 400);
    private IPrimitiveValueProvider valueProvider = DoublePrimitiveValueProviderFactory.INSTANCE.createPrimitiveValueProvider();
    private double[] a;
    private double[] b;

    public HilbertDoubleComparator(int dimension) {
        if (dimension != 2) {
            throw new IllegalArgumentException();
        }
        this.dim = dimension;
        this.a = new double[this.dim];
        this.b = new double[this.dim];
        this.states = new HilbertState[]{new HilbertState(new int[]{3, 0, 1, 0}, new int[]{0, 1, 3, 2}), new HilbertState(new int[]{1, 1, 0, 2}, new int[]{2, 1, 3, 0}), new HilbertState(new int[]{2, 3, 2, 1}, new int[]{2, 3, 1, 0}), new HilbertState(new int[]{0, 2, 3, 3}, new int[]{0, 3, 1, 2})};
        this.resetStateMachine();
    }

    private void resetStateMachine() {
        this.state = 0;
        this.stateStack.clear();
        this.stepsize = 8.988465674311579E307;
        this.bounds = new double[this.dim];
        this.boundsStack.clear();
    }

    public int compare() {
        block16: {
            int j;
            boolean zoomOut;
            boolean equal = true;
            for (int i = 0; i < this.dim; ++i) {
                if (this.a[i] == this.b[i]) continue;
                equal = false;
            }
            if (equal) {
                return 0;
            }
            do {
                if (this.stateStack.size() <= this.dim) {
                    this.resetStateMachine();
                    break block16;
                }
                zoomOut = false;
                for (int i = 0; i < this.dim; ++i) {
                    if (!(Math.min(this.a[i], this.b[i]) <= this.bounds[i] - 2.0 * this.stepsize) && !(Math.max(this.a[i], this.b[i]) >= this.bounds[i] + 2.0 * this.stepsize)) continue;
                    zoomOut = true;
                    break;
                }
                this.state = this.stateStack.getLast();
                this.stateStack.removeLast();
                for (j = this.dim - 1; j >= 0; --j) {
                    this.bounds[j] = this.boundsStack.getLast();
                    this.boundsStack.removeLast();
                }
                this.stepsize *= 2.0;
            } while (zoomOut);
            this.state = this.stateStack.getLast();
            this.stateStack.removeLast();
            for (j = this.dim - 1; j >= 0; --j) {
                this.bounds[j] = this.boundsStack.getLast();
                this.boundsStack.removeLast();
            }
            this.stepsize *= 2.0;
        }
        while (true) {
            this.stateStack.add(this.state);
            for (int j = 0; j < this.dim; ++j) {
                this.boundsStack.add(this.bounds[j]);
            }
            int quadrantA = 0;
            int quadrantB = 0;
            for (int i = this.dim - 1; i >= 0; --i) {
                if (this.a[i] >= this.bounds[i]) {
                    quadrantA ^= 1 << this.dim - i - 1;
                }
                if (this.b[i] >= this.bounds[i]) {
                    quadrantB ^= 1 << this.dim - i - 1;
                }
                if (this.a[i] >= this.bounds[i]) {
                    int n = i;
                    this.bounds[n] = this.bounds[n] + this.stepsize;
                    continue;
                }
                int n = i;
                this.bounds[n] = this.bounds[n] - this.stepsize;
            }
            this.stepsize /= 2.0;
            if (this.stepsize <= 2.0 * DoublePointable.getEpsilon()) {
                return 0;
            }
            if (quadrantA != quadrantB) {
                int posA = this.states[this.state].position[quadrantA];
                int posB = this.states[this.state].position[quadrantB];
                if (posA < posB) {
                    return -1;
                }
                return 1;
            }
            this.state = this.states[this.state].nextState[quadrantA];
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        for (int i = 0; i < this.dim; ++i) {
            this.a[i] = DoublePointable.getDouble((byte[])b1, (int)(s1 + i * l1));
            this.b[i] = DoublePointable.getDouble((byte[])b2, (int)(s2 + i * l2));
        }
        return this.compare();
    }

    public int getDimensions() {
        return this.dim;
    }

    private class HilbertState {
        public final int[] nextState;
        public final int[] position;

        public HilbertState(int[] nextState, int[] order) {
            this.nextState = nextState;
            this.position = order;
        }
    }
}

