/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.RemoteCommand;
import org.apache.commons.io.IOUtils;

public class WaitForClusterCommand
extends RemoteCommand {
    public WaitForClusterCommand(Args args) {
        super(args);
    }

    @Override
    public int execute() throws IOException {
        int timeoutSecs = this.args.getTimeoutSecs();
        this.log("Waiting " + (String)(timeoutSecs > 0 ? "up to " + timeoutSecs + " seconds " : "") + "for cluster " + this.hostPort + " to be available.");
        long startTime = System.currentTimeMillis();
        long timeoutMillis = TimeUnit.SECONDS.toMillis(timeoutSecs);
        boolean first = true;
        String lastState = null;
        while (true) {
            if (!first) {
                if (timeoutMillis > 0L && startTime + timeoutMillis < System.currentTimeMillis()) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return 22;
                }
            }
            first = false;
            try {
                String result;
                ObjectMapper om;
                JsonNode json;
                HttpURLConnection conn = this.openConnection(this.args.getClusterStatePath(), RemoteCommand.Method.GET);
                if (conn.getResponseCode() != 200 || !"ACTIVE".equals(lastState = (json = (om = new ObjectMapper()).readTree(result = IOUtils.toString((InputStream)conn.getInputStream(), (String)StandardCharsets.UTF_8.name()))).get("state").asText())) continue;
                this.log("Cluster started and is ACTIVE.");
                return 0;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        this.log("Cluster " + this.hostPort + " was not available before timeout of " + timeoutSecs + " seconds was exhausted" + (String)(lastState != null ? " (state: " + lastState + ")" : "") + "; check logs for more information");
        return 1;
    }
}

